/*
 * Decompiled with CFR 0.152.
 */
package zipkin2.storage;

import com.google.auto.value.AutoValue;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import zipkin2.Annotation;
import zipkin2.Span;
import zipkin2.internal.Nullable;
import zipkin2.storage.AutoValue_QueryRequest;

@AutoValue
public abstract class QueryRequest {
    @Nullable
    public abstract String serviceName();

    @Nullable
    public abstract String spanName();

    public abstract Map<String, String> annotationQuery();

    @Nullable
    public abstract Long minDuration();

    @Nullable
    public abstract Long maxDuration();

    public abstract long endTs();

    public abstract long lookback();

    public abstract int limit();

    @Nullable
    public String annotationQueryString() {
        StringBuilder result = new StringBuilder();
        Iterator<Map.Entry<String, String>> i = this.annotationQuery().entrySet().iterator();
        while (i.hasNext()) {
            Map.Entry<String, String> next = i.next();
            result.append(next.getKey());
            if (!next.getValue().isEmpty()) {
                result.append('=').append(next.getValue());
            }
            if (!i.hasNext()) continue;
            result.append(" and ");
        }
        return result.length() > 0 ? result.toString() : null;
    }

    public abstract Builder toBuilder();

    public static Builder newBuilder() {
        return new AutoValue_QueryRequest.Builder().annotationQuery(Collections.<String, String>emptyMap());
    }

    public boolean test(List<Span> spans) {
        long timestamp = 0L;
        for (Span span : spans) {
            if (span.timestampAsLong() == 0L) continue;
            if (span.parentId() == null) {
                timestamp = span.timestampAsLong();
                break;
            }
            if (timestamp != 0L && timestamp <= span.timestampAsLong()) continue;
            timestamp = span.timestampAsLong();
        }
        if (timestamp == 0L || timestamp < (this.endTs() - this.lookback()) * 1000L || timestamp > this.endTs() * 1000L) {
            return false;
        }
        LinkedHashSet<String> serviceNames = new LinkedHashSet<String>();
        boolean testedDuration = this.minDuration() == null && this.maxDuration() == null;
        String spanNameToMatch = this.spanName();
        LinkedHashMap<String, String> annotationQueryRemaining = new LinkedHashMap<String, String>(this.annotationQuery());
        for (Span span : spans) {
            String localServiceName = span.localServiceName();
            if (localServiceName != null) {
                serviceNames.add(localServiceName);
            }
            if (this.serviceName() == null || this.serviceName().equals(localServiceName)) {
                for (Annotation annotation : span.annotations()) {
                    if (!"".equals(annotationQueryRemaining.get(annotation.value()))) continue;
                    annotationQueryRemaining.remove(annotation.value());
                }
                for (Map.Entry entry : span.tags().entrySet()) {
                    String value = (String)annotationQueryRemaining.get(entry.getKey());
                    if (value == null || !value.isEmpty() && !value.equals(entry.getValue())) continue;
                    annotationQueryRemaining.remove(entry.getKey());
                }
                if (spanNameToMatch == null || spanNameToMatch.equals(span.name())) {
                    spanNameToMatch = null;
                }
            }
            if (this.serviceName() != null && !this.serviceName().equals(localServiceName) || testedDuration) continue;
            if (this.minDuration() != null && this.maxDuration() != null) {
                testedDuration = span.durationAsLong() >= this.minDuration() && span.durationAsLong() <= this.maxDuration();
                continue;
            }
            if (this.minDuration() == null) continue;
            testedDuration = span.durationAsLong() >= this.minDuration();
        }
        return (this.serviceName() == null || serviceNames.contains(this.serviceName())) && spanNameToMatch == null && annotationQueryRemaining.isEmpty() && testedDuration;
    }

    QueryRequest() {
    }

    @AutoValue.Builder
    public static abstract class Builder {
        public abstract Builder serviceName(@Nullable String var1);

        public abstract Builder spanName(@Nullable String var1);

        public Builder parseAnnotationQuery(@Nullable String annotationQuery) {
            if (annotationQuery == null || annotationQuery.isEmpty()) {
                return this;
            }
            LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
            for (String ann : annotationQuery.split(" and ", 100)) {
                int idx = ann.indexOf(61);
                if (idx == -1) {
                    map.put(ann, "");
                    continue;
                }
                String[] keyValue = ann.split("=", 2);
                map.put(ann.substring(0, idx), keyValue.length < 2 ? "" : ann.substring(idx + 1));
            }
            return this.annotationQuery(map);
        }

        public abstract Builder annotationQuery(Map<String, String> var1);

        public abstract Builder minDuration(@Nullable Long var1);

        public abstract Builder maxDuration(@Nullable Long var1);

        public abstract Builder endTs(long var1);

        public abstract Builder lookback(long var1);

        public abstract Builder limit(int var1);

        @Nullable
        abstract String serviceName();

        @Nullable
        abstract String spanName();

        abstract Map<String, String> annotationQuery();

        @Nullable
        abstract Long minDuration();

        @Nullable
        abstract Long maxDuration();

        abstract long endTs();

        abstract int limit();

        abstract QueryRequest autoBuild();

        public final QueryRequest build() {
            if (this.serviceName() != null) {
                this.serviceName(this.serviceName().toLowerCase(Locale.ROOT));
            }
            if (this.spanName() != null) {
                this.spanName(this.spanName().toLowerCase(Locale.ROOT));
            }
            this.annotationQuery().remove("");
            if ("".equals(this.serviceName())) {
                this.serviceName(null);
            }
            if ("".equals(this.spanName()) || "all".equals(this.spanName())) {
                this.spanName(null);
            }
            if (this.endTs() <= 0L) {
                throw new IllegalArgumentException("endTs <= 0");
            }
            if (this.limit() <= 0) {
                throw new IllegalArgumentException("limit <= 0");
            }
            if (this.minDuration() != null) {
                if (this.minDuration() <= 0L) {
                    throw new IllegalArgumentException("minDuration <= 0");
                }
                if (this.maxDuration() != null && this.maxDuration() < this.minDuration()) {
                    throw new IllegalArgumentException("maxDuration < minDuration");
                }
            } else if (this.maxDuration() != null) {
                throw new IllegalArgumentException("maxDuration is only valid with minDuration");
            }
            return this.autoBuild();
        }

        Builder() {
        }
    }
}

