/*
 * Decompiled with CFR 0.152.
 */
package ma.glasnost.orika;

import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import ma.glasnost.orika.metadata.Type;
import ma.glasnost.orika.metadata.TypeFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MapEntry<K, V>
implements Map.Entry<K, V> {
    private K key;
    public V value;

    public MapEntry() {
    }

    public MapEntry(K key, V value) {
        this.key = key;
        this.value = value;
    }

    private MapEntry(Map.Entry<K, V> copy) {
        this.key = copy.getKey();
        this.value = copy.getValue();
    }

    @Override
    public K getKey() {
        return this.key;
    }

    @Override
    public V getValue() {
        return this.value;
    }

    public void setKey(K key) {
        this.key = key;
    }

    @Override
    public V setValue(V value) {
        V originalValue = this.value;
        this.value = value;
        return originalValue;
    }

    public static <K, V> Type<MapEntry<K, V>> concreteEntryType(Type<? extends Map<K, V>> mapType) {
        Type<MapEntry<K, V>> type = TypeFactory.valueOf(MapEntry.class, mapType.getActualTypeArguments());
        return type;
    }

    public String toString() {
        return "[" + this.getKey() + "=" + this.getValue() + "]";
    }

    public static <K, V> Type<Map.Entry<K, V>> entryType(Type<? extends Map<K, V>> mapType) {
        Type<Map.Entry<K, V>> type = TypeFactory.valueOf(Map.Entry.class, mapType.getActualTypeArguments());
        return type;
    }

    public static <K, V> Set<MapEntry<K, V>> entrySet(Map<K, V> map) {
        return new MapEntrySet(map.entrySet());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class MapEntryIterator<K, V>
    implements Iterator<MapEntry<K, V>> {
        private Iterator<Map.Entry<K, V>> delegate;

        private MapEntryIterator(Iterator<Map.Entry<K, V>> delegate) {
            this.delegate = delegate;
        }

        @Override
        public boolean hasNext() {
            return this.delegate.hasNext();
        }

        @Override
        public MapEntry<K, V> next() {
            return new MapEntry(this.delegate.next());
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class MapEntrySet<K, V>
    implements Set<MapEntry<K, V>> {
        private Set<Map.Entry<K, V>> delegate;

        private MapEntrySet(Set<Map.Entry<K, V>> delegate) {
            this.delegate = delegate;
        }

        @Override
        public int size() {
            return this.delegate.size();
        }

        @Override
        public boolean isEmpty() {
            return this.delegate.isEmpty();
        }

        @Override
        public boolean contains(Object o) {
            throw new UnsupportedOperationException();
        }

        @Override
        public Iterator<MapEntry<K, V>> iterator() {
            return new MapEntryIterator(this.delegate.iterator());
        }

        @Override
        public Object[] toArray() {
            return null;
        }

        @Override
        public <T> T[] toArray(T[] a) {
            return null;
        }

        @Override
        public boolean add(MapEntry<K, V> o) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean remove(Object o) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean containsAll(Collection<?> c) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean addAll(Collection<? extends MapEntry<K, V>> c) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean retainAll(Collection<?> c) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean removeAll(Collection<?> c) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void clear() {
            throw new UnsupportedOperationException();
        }
    }
}

