/*
 * Decompiled with CFR 0.152.
 */
package ma.glasnost.orika;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.LinkedBlockingQueue;
import ma.glasnost.orika.MappingContextFactory;
import ma.glasnost.orika.metadata.ClassMap;
import ma.glasnost.orika.metadata.MapperKey;
import ma.glasnost.orika.metadata.Type;
import ma.glasnost.orika.metadata.TypeFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MappingContext {
    private final Map<Type<?>, Type<?>> mapping = new HashMap();
    private final Map<java.lang.reflect.Type, Map<Object, Object>> cache = new HashMap<java.lang.reflect.Type, Map<Object, Object>>();
    private List<Map<MapperKey, ClassMap<?, ?>>> mappersSeen;
    private Map<Object, Object> properties;
    private Map<Object, Object> globalProperties;
    private boolean isNew = true;
    private int depth;
    private Type<?> resolvedSourceType;
    private Type<?> resolvedDestinationType;

    private MappingContext(Map<Object, Object> globalProperties) {
        this.globalProperties = globalProperties;
    }

    public <S, D> Type<? extends D> getConcreteClass(Type<S> sourceType, Type<D> destinationType) {
        if (this.isNew) {
            return null;
        }
        Type<?> type = this.mapping.get(sourceType);
        if (type != null && destinationType.isAssignableFrom(type)) {
            return type;
        }
        return null;
    }

    public void registerConcreteClass(Type<?> subjectClass, Type<?> concreteClass) {
        this.mapping.put(subjectClass, concreteClass);
        this.isNew = false;
    }

    @Deprecated
    public <S, D> void cacheMappedObject(S source, D destination) {
        this.cacheMappedObject(source, TypeFactory.typeOf(destination), destination);
    }

    public <S, D> void cacheMappedObject(S source, java.lang.reflect.Type destinationType, D destination) {
        Map<Object, Object> localCache = this.cache.get(destinationType);
        if (localCache == null) {
            localCache = new IdentityHashMap<Object, Object>(2);
            this.cache.put(destinationType, localCache);
        }
        localCache.put(source, destination);
        Type dest = TypeFactory.valueOf(destinationType);
        for (Type<?> t : dest.getInterfaces()) {
            this.cacheMappedObject(source, t, destination);
        }
        this.isNew = false;
    }

    @Deprecated
    public <S, D> boolean isAlreadyMapped(S source, java.lang.reflect.Type destinationType) {
        if (this.isNew) {
            return false;
        }
        Map<Object, Object> localCache = this.cache.get(destinationType);
        return localCache != null && localCache.get(source) != null;
    }

    public <D> D getMappedObject(Object source, java.lang.reflect.Type destinationType) {
        if (this.isNew) {
            return null;
        }
        Map<Object, Object> localCache = this.cache.get(destinationType);
        return (D)(localCache == null ? null : localCache.get(source));
    }

    public void registerMapperGeneration(ClassMap<?, ?> classMap) {
        Map<MapperKey, ClassMap<?, ?>> list;
        if (this.mappersSeen == null) {
            this.mappersSeen = new ArrayList();
        }
        Map<MapperKey, ClassMap<?, ?>> map = list = this.mappersSeen.isEmpty() ? null : this.mappersSeen.get(this.depth - 1);
        if (list == null) {
            list = new HashMap();
        }
        list.put(classMap.getMapperKey(), classMap);
    }

    public ClassMap<?, ?> getMapperGeneration(MapperKey mapperKey) {
        Map<MapperKey, ClassMap<?, ?>> map;
        ClassMap result = null;
        Map<MapperKey, ClassMap<?, ?>> map2 = map = this.mappersSeen == null || this.mappersSeen.isEmpty() ? null : this.mappersSeen.get(this.depth - 1);
        if (map != null) {
            result = (ClassMap)map.get(mapperKey);
        }
        return result;
    }

    public void beginMapping() {
        ++this.depth;
    }

    public void endMapping() {
        --this.depth;
    }

    public void reset() {
        this.cache.clear();
        this.mapping.clear();
        if (this.properties != null) {
            this.properties.clear();
        }
        if (this.mappersSeen != null) {
            this.mappersSeen.clear();
        }
        this.isNew = true;
        this.depth = 0;
    }

    public void setProperty(Object key, Object value) {
        if (this.properties == null) {
            this.properties = new HashMap<Object, Object>();
        }
        this.properties.put(key, value);
    }

    public Object getProperty(Object key) {
        Object result;
        Object object = result = this.properties != null ? this.properties.get(key) : null;
        if (result == null && this.globalProperties != null) {
            result = this.globalProperties.get(key);
        }
        return result;
    }

    public Type<?> getResolvedSourceType() {
        return this.resolvedSourceType;
    }

    public void setResolvedSourceType(Type<?> resolvedSourceType) {
        this.resolvedSourceType = resolvedSourceType;
    }

    public Type<?> getResolvedDestinationType() {
        return this.resolvedDestinationType;
    }

    public void setResolvedDestinationType(Type<?> resolvedDestinationType) {
        this.resolvedDestinationType = resolvedDestinationType;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class NonCyclicMappingContext
    extends MappingContext {
        public NonCyclicMappingContext() {
            super(null);
        }

        @Override
        public <S, D> void cacheMappedObject(S source, D destination) {
        }

        @Override
        public <S, D> void cacheMappedObject(S source, java.lang.reflect.Type destinationType, D destination) {
        }

        @Override
        public <S, D> boolean isAlreadyMapped(S source, java.lang.reflect.Type destinationType) {
            return false;
        }

        @Override
        public <D> D getMappedObject(Object source, java.lang.reflect.Type destinationType) {
            return null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Factory
    implements MappingContextFactory {
        LinkedBlockingQueue<MappingContext> contextQueue = new LinkedBlockingQueue();
        ConcurrentHashMap<Object, Object> globalProperties = new ConcurrentHashMap();

        @Override
        public MappingContext getContext() {
            MappingContext context = this.contextQueue.poll();
            return context != null ? context : new MappingContext(this.globalProperties);
        }

        @Override
        public void release(MappingContext context) {
            context.reset();
            this.contextQueue.offer(context);
        }

        @Override
        public Map<Object, Object> getGlobalProperties() {
            return this.globalProperties;
        }
    }
}

