/*
 * Decompiled with CFR 0.152.
 */
package ma.glasnost.orika.converter;

import com.googlecode.concurrentlinkedhashmap.ConcurrentLinkedHashMap;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import ma.glasnost.orika.Converter;
import ma.glasnost.orika.MapperFacade;
import ma.glasnost.orika.converter.Converter;
import ma.glasnost.orika.converter.ConverterFactory;
import ma.glasnost.orika.impl.Comparators;
import ma.glasnost.orika.impl.util.ClassUtil;
import ma.glasnost.orika.metadata.ConverterKey;
import ma.glasnost.orika.metadata.Type;
import ma.glasnost.orika.metadata.TypeFactory;
import ma.glasnost.orika.util.SortedSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultConverterFactory
implements ConverterFactory {
    private static final Integer CACHE_SIZE = 2000;
    private final Map<ConverterKey, Converter<Object, Object>> converterCache;
    private final Set<Converter<Object, Object>> converters;
    private final Map<String, Converter<Object, Object>> convertersMap;
    private MapperFacade mapperFacade;

    public DefaultConverterFactory(Map<ConverterKey, Converter<Object, Object>> converterCache, Set<Converter<Object, Object>> converters) {
        this.converterCache = converterCache;
        this.converters = new SortedSet<Converter<Object, Object>>(converters, Comparators.CONVERTER);
        this.convertersMap = new ConcurrentHashMap<String, Converter<Object, Object>>();
    }

    public DefaultConverterFactory() {
        this(DefaultConverterFactory.getConcurrentMap(), new LinkedHashSet<Converter<Object, Object>>());
    }

    private static Map<ConverterKey, Converter<Object, Object>> getConcurrentMap() {
        ConcurrentLinkedHashMap.Builder builder = new ConcurrentLinkedHashMap.Builder();
        try {
            Method maximumWeightedCapacity = ConcurrentLinkedHashMap.Builder.class.getMethod("maximumWeightedCapacity", Integer.TYPE);
            maximumWeightedCapacity.invoke((Object)builder, (int)CACHE_SIZE);
        }
        catch (IllegalAccessException e) {
            throw new IllegalStateException(e);
        }
        catch (InvocationTargetException e) {
            throw new IllegalStateException(e.getTargetException());
        }
        catch (NoSuchMethodException e) {
            try {
                Method maximumWeightedCapacity = ConcurrentLinkedHashMap.Builder.class.getMethod("maximumWeightedCapacity", Long.TYPE);
                maximumWeightedCapacity.invoke((Object)builder, CACHE_SIZE.longValue());
            }
            catch (NoSuchMethodException e1) {
                throw new IllegalStateException(e1);
            }
            catch (IllegalAccessException e1) {
                throw new IllegalStateException(e1);
            }
            catch (InvocationTargetException e1) {
                throw new IllegalStateException(e1);
            }
        }
        return builder.build();
    }

    @Override
    public void setMapperFacade(MapperFacade mapperFacade) {
        this.mapperFacade = mapperFacade;
        for (Converter<Object, Object> converter : this.converters) {
            converter.setMapperFacade(mapperFacade);
        }
        for (Converter<Object, Object> converter : this.convertersMap.values()) {
            converter.setMapperFacade(mapperFacade);
        }
    }

    @Override
    public boolean canConvert(Type<?> sourceType, Type<?> destinationType) {
        boolean canConvert = this._canConvert(sourceType, destinationType);
        if (canConvert) {
            return true;
        }
        if (sourceType.isPrimitive()) {
            sourceType = TypeFactory.valueOf(ClassUtil.getWrapperType(sourceType.getRawType()));
            canConvert = this._canConvert(sourceType, destinationType);
        }
        if (canConvert) {
            return true;
        }
        if (destinationType.isPrimitive()) {
            destinationType = TypeFactory.valueOf(ClassUtil.getWrapperType(destinationType.getRawType()));
            canConvert = this._canConvert(sourceType, destinationType);
        }
        return canConvert;
    }

    private boolean _canConvert(Type<?> sourceType, Type<?> destinationType) {
        boolean canConvert = false;
        ConverterKey key = new ConverterKey(sourceType, destinationType);
        if (this.converterCache.containsKey(key)) {
            return true;
        }
        for (Converter<Object, Object> converter : this.converters) {
            if (!converter.canConvert(sourceType, destinationType)) continue;
            this.converterCache.put(key, converter);
            canConvert = true;
            break;
        }
        return canConvert;
    }

    @Override
    public boolean hasConverter(String converterId) {
        return this.convertersMap.containsKey(converterId);
    }

    @Override
    public Converter<Object, Object> getConverter(Type<?> sourceClass, Type<?> destinationClass) {
        Converter<Object, Object> converter = this._converter(sourceClass, destinationClass);
        if (converter != null) {
            return converter;
        }
        if (sourceClass.isPrimitive()) {
            sourceClass = TypeFactory.valueOf(ClassUtil.getWrapperType(sourceClass.getRawType()));
            converter = this._converter(sourceClass, destinationClass);
        }
        if (converter != null) {
            return converter;
        }
        if (destinationClass.isPrimitive()) {
            destinationClass = TypeFactory.valueOf(ClassUtil.getWrapperType(destinationClass.getRawType()));
            converter = this._converter(sourceClass, destinationClass);
        }
        if (converter != null) {
            return converter;
        }
        return null;
    }

    private Converter<Object, Object> _converter(Type<?> sourceClass, Type<?> destinationClass) {
        ConverterKey key = new ConverterKey(sourceClass, destinationClass);
        if (this.converterCache.containsKey(key)) {
            return this.converterCache.get(key);
        }
        for (Converter<Object, Object> converter : this.converters) {
            if (!converter.canConvert(sourceClass, destinationClass)) continue;
            this.converterCache.put(key, converter);
            return converter;
        }
        return null;
    }

    @Override
    public Converter<Object, Object> getConverter(String converterId) {
        return this.convertersMap.get(converterId);
    }

    @Override
    public <S, D> void registerConverter(Converter<S, D> converter) {
        if (this.mapperFacade != null) {
            converter.setMapperFacade(this.mapperFacade);
        }
        this.converters.add(converter);
    }

    @Override
    public <S, D> void registerConverter(String converterId, Converter<S, D> converter) {
        if (this.mapperFacade != null) {
            converter.setMapperFacade(this.mapperFacade);
        }
        this.convertersMap.put(converterId, converter);
    }

    @Override
    @Deprecated
    public <S, D> void registerConverter(ma.glasnost.orika.converter.Converter<S, D> converter) {
        this.registerConverter(new Converter.LegacyConverter<S, D>(converter));
    }

    @Override
    @Deprecated
    public <S, D> void registerConverter(String converterId, ma.glasnost.orika.converter.Converter<S, D> converter) {
        this.registerConverter(converterId, new Converter.LegacyConverter<S, D>(converter));
    }
}

