/*
 * Decompiled with CFR 0.152.
 */
package ma.glasnost.orika.converter.builtin;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import ma.glasnost.orika.CustomConverter;
import ma.glasnost.orika.metadata.Type;
import ma.glasnost.orika.metadata.TypeFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CloneableConverter
extends CustomConverter<Object, Object> {
    private final Set<Type<Cloneable>> clonedTypes = new HashSet<Type<Cloneable>>();
    private final Map<Class<?>, Method> cachedMethods;
    private final Method cloneMethod;

    public CloneableConverter(java.lang.reflect.Type ... types) {
        WeakHashMap methodCache;
        Method clone;
        try {
            clone = Object.class.getDeclaredMethod("clone", new Class[0]);
            clone.setAccessible(true);
            methodCache = null;
        }
        catch (SecurityException e) {
            clone = null;
            methodCache = new WeakHashMap();
        }
        catch (NoSuchMethodException e) {
            throw new IllegalStateException(e);
        }
        this.cloneMethod = clone;
        this.cachedMethods = methodCache;
        for (java.lang.reflect.Type type : types) {
            this.clonedTypes.add(TypeFactory.valueOf(type));
        }
    }

    private boolean shouldClone(Type<?> type) {
        for (Type<Cloneable> registeredType : this.clonedTypes) {
            if (!registeredType.isAssignableFrom(type)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean canConvert(Type<?> sourceType, Type<?> destinationType) {
        return this.shouldClone(sourceType) && sourceType.equals(destinationType);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object convert(Object source, Type<? extends Object> destinationType) {
        try {
            Method clone;
            if (this.cloneMethod != null) {
                clone = this.cloneMethod;
            } else {
                clone = this.cachedMethods.get(source.getClass());
                if (clone == null) {
                    Map<Class<?>, Method> map = this.cachedMethods;
                    synchronized (map) {
                        try {
                            clone = ((Class)destinationType.getRawType()).getMethod("clone", new Class[0]);
                            this.cachedMethods.put(source.getClass(), clone);
                        }
                        catch (NoSuchMethodException e) {
                            throw new IllegalStateException(e);
                        }
                        catch (SecurityException e) {
                            throw new IllegalStateException(e);
                        }
                    }
                }
            }
            if (System.getSecurityManager() != null) {
                return AccessController.doPrivileged(new CloneAction(clone, source));
            }
            return clone.invoke(source, new Object[0]);
        }
        catch (IllegalArgumentException e) {
            throw new IllegalStateException(e);
        }
        catch (IllegalAccessException e) {
            throw new IllegalStateException(e);
        }
        catch (InvocationTargetException e) {
            throw new IllegalStateException(e);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class CloneAction
    implements PrivilegedAction<Object> {
        private final Method method;
        private final Object target;

        private CloneAction(Method method, Object target) {
            this.method = method;
            this.target = target;
        }

        @Override
        public Object run() {
            try {
                return this.method.invoke(this.target, new Object[0]);
            }
            catch (IllegalAccessException e) {
                String accessibleClause = this.method.isAccessible() ? "(even though " + this.method + " is accessible)" : "";
                throw new IllegalStateException("Call to clone method not accessible for " + this.target.getClass().getCanonicalName() + accessibleClause, e);
            }
            catch (InvocationTargetException e) {
                throw new IllegalStateException("Call to clone method failed for " + this.target.getClass().getCanonicalName(), e.getTargetException());
            }
        }
    }
}

