/*
 * Decompiled with CFR 0.152.
 */
package ma.glasnost.orika.converter.builtin;

import ma.glasnost.orika.CustomConverter;
import ma.glasnost.orika.impl.util.ClassUtil;
import ma.glasnost.orika.metadata.Type;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConstructorConverter
extends CustomConverter<Object, Object> {
    @Override
    public boolean canConvert(Type<?> sourceType, Type<?> destinationType) {
        try {
            return ((Class)destinationType.getRawType()).getConstructor(new Class[]{sourceType.getRawType()}) != null;
        }
        catch (NoSuchMethodException e) {
            try {
                if (sourceType.isPrimitive()) {
                    return ((Class)destinationType.getRawType()).getConstructor(ClassUtil.getWrapperType(sourceType.getRawType())) != null;
                }
                if (sourceType.isPrimitiveWrapper()) {
                    return ((Class)destinationType.getRawType()).getConstructor(ClassUtil.getPrimitiveType(sourceType.getRawType())) != null;
                }
                return false;
            }
            catch (NoSuchMethodException e1) {
                return false;
            }
        }
        catch (Exception e) {
            return false;
        }
    }

    @Override
    public Object convert(Object source, Type<? extends Object> destinationType) {
        try {
            return ((Class)destinationType.getRawType()).getConstructor(source.getClass()).newInstance(source);
        }
        catch (NoSuchMethodException e) {
            try {
                if (source.getClass().isPrimitive()) {
                    return ((Class)destinationType.getRawType()).getConstructor(ClassUtil.getWrapperType(source.getClass())).newInstance(source);
                }
                if (ClassUtil.isPrimitiveWrapper(source.getClass())) {
                    return ((Class)destinationType.getRawType()).getConstructor(ClassUtil.getPrimitiveType(source.getClass())).newInstance(source);
                }
                return false;
            }
            catch (Exception e1) {
                return false;
            }
        }
        catch (Exception e) {
            throw new IllegalArgumentException(e);
        }
    }
}

