/*
 * Decompiled with CFR 0.152.
 */
package ma.glasnost.orika.converter.builtin;

import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.GregorianCalendar;
import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.datatype.XMLGregorianCalendar;
import ma.glasnost.orika.CustomConverter;
import ma.glasnost.orika.converter.BidirectionalConverter;
import ma.glasnost.orika.metadata.Type;

public class DateAndTimeConverters {
    private static java.util.Date toDate(XMLGregorianCalendar source) {
        return source.toGregorianCalendar().getTime();
    }

    private static java.util.Date toDate(Calendar source) {
        return source.getTime();
    }

    private static java.util.Date toDate(Long source) {
        return new java.util.Date(source);
    }

    private static Calendar toCalendar(XMLGregorianCalendar source) {
        return DateAndTimeConverters.toCalendar(source.toGregorianCalendar().getTime());
    }

    private static Calendar toCalendar(java.util.Date source) {
        Calendar c = Calendar.getInstance();
        c.setTime(source);
        return c;
    }

    private static Calendar toCalendar(Long source) {
        return DateAndTimeConverters.toCalendar(new java.util.Date(source));
    }

    private static XMLGregorianCalendar toXMLGregorianCalendar(Calendar source, DatatypeFactory factory) {
        return DateAndTimeConverters.toXMLGregorianCalendar(source.getTime(), factory);
    }

    private static XMLGregorianCalendar toXMLGregorianCalendar(java.util.Date source, DatatypeFactory factory) {
        GregorianCalendar c = new GregorianCalendar();
        c.setTime(source);
        return factory.newXMLGregorianCalendar(c);
    }

    private static XMLGregorianCalendar toXMLGregorianCalendar(Long source, DatatypeFactory factory) {
        return DateAndTimeConverters.toXMLGregorianCalendar(new java.util.Date(source), factory);
    }

    private static Long toLong(java.util.Date source) {
        return source.getTime();
    }

    private static Long toLong(Calendar source) {
        return DateAndTimeConverters.toLong(source.getTime());
    }

    private static Long toLong(XMLGregorianCalendar source) {
        return DateAndTimeConverters.toLong(source.toGregorianCalendar().getTime());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class DateToTimestampConverter
    extends CustomConverter<java.util.Date, Timestamp> {
        @Override
        public Timestamp convert(java.util.Date source, Type<? extends Timestamp> destinationType) {
            return new Timestamp(DateAndTimeConverters.toLong(source));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class XmlGregorianCalendarToTimestampConverter
    extends CustomConverter<XMLGregorianCalendar, Timestamp> {
        @Override
        public Timestamp convert(XMLGregorianCalendar source, Type<? extends Timestamp> destinationType) {
            return new Timestamp(DateAndTimeConverters.toLong(source));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class LongToXmlGregorianCalendarConverter
    extends BidirectionalConverter<Long, XMLGregorianCalendar> {
        private DatatypeFactory factory;

        public LongToXmlGregorianCalendarConverter() {
            try {
                this.factory = DatatypeFactory.newInstance();
            }
            catch (DatatypeConfigurationException e) {
                throw new IllegalStateException(e);
            }
        }

        @Override
        public XMLGregorianCalendar convertTo(Long source, Type<XMLGregorianCalendar> destinationType) {
            return DateAndTimeConverters.toXMLGregorianCalendar(source, this.factory);
        }

        @Override
        public Long convertFrom(XMLGregorianCalendar source, Type<Long> destinationType) {
            return DateAndTimeConverters.toLong(source);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class LongToCalendarConverter
    extends BidirectionalConverter<Long, Calendar> {
        @Override
        public Calendar convertTo(Long source, Type<Calendar> destinationType) {
            return DateAndTimeConverters.toCalendar(source);
        }

        @Override
        public Long convertFrom(Calendar source, Type<Long> destinationType) {
            return DateAndTimeConverters.toLong(source);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class LongToTimeConverter
    extends BidirectionalConverter<Long, Time> {
        @Override
        public Time convertTo(Long source, Type<Time> destinationType) {
            return new Time(source);
        }

        @Override
        public Long convertFrom(Time source, Type<Long> destinationType) {
            return DateAndTimeConverters.toLong(source);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class LongToSqlDateConverter
    extends BidirectionalConverter<Long, Date> {
        @Override
        public Date convertTo(Long source, Type<Date> destinationType) {
            return new Date(source);
        }

        @Override
        public Long convertFrom(Date source, Type<Long> destinationType) {
            return DateAndTimeConverters.toLong(source);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class LongToDateConverter
    extends BidirectionalConverter<Long, java.util.Date> {
        @Override
        public java.util.Date convertTo(Long source, Type<java.util.Date> destinationType) {
            return DateAndTimeConverters.toDate(source);
        }

        @Override
        public Long convertFrom(java.util.Date source, Type<Long> destinationType) {
            return DateAndTimeConverters.toLong(source);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class CalendarToXmlGregorianCalendarConverter
    extends BidirectionalConverter<Calendar, XMLGregorianCalendar> {
        private DatatypeFactory factory;

        public CalendarToXmlGregorianCalendarConverter() {
            try {
                this.factory = DatatypeFactory.newInstance();
            }
            catch (DatatypeConfigurationException e) {
                throw new IllegalStateException(e);
            }
        }

        @Override
        public XMLGregorianCalendar convertTo(Calendar source, Type<XMLGregorianCalendar> destinationType) {
            return DateAndTimeConverters.toXMLGregorianCalendar(source, this.factory);
        }

        @Override
        public Calendar convertFrom(XMLGregorianCalendar source, Type<Calendar> destinationType) {
            return DateAndTimeConverters.toCalendar(source);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class DateToXmlGregorianCalendarConverter
    extends BidirectionalConverter<java.util.Date, XMLGregorianCalendar> {
        private DatatypeFactory factory;

        public DateToXmlGregorianCalendarConverter() {
            try {
                this.factory = DatatypeFactory.newInstance();
            }
            catch (DatatypeConfigurationException e) {
                throw new IllegalStateException(e);
            }
        }

        @Override
        public XMLGregorianCalendar convertTo(java.util.Date source, Type<XMLGregorianCalendar> destinationType) {
            return DateAndTimeConverters.toXMLGregorianCalendar(source, this.factory);
        }

        @Override
        public java.util.Date convertFrom(XMLGregorianCalendar source, Type<java.util.Date> destinationType) {
            return DateAndTimeConverters.toDate(source);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class CalendarToTimeConverter
    extends CustomConverter<Calendar, Time> {
        @Override
        public Time convert(Calendar source, Type<? extends Time> destinationType) {
            return new Time(DateAndTimeConverters.toLong(source));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class CalendarToSqlDateConverter
    extends CustomConverter<Calendar, Date> {
        @Override
        public Date convert(Calendar source, Type<? extends Date> destinationType) {
            return new Date(DateAndTimeConverters.toLong(source));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class XmlGregorianCalendarToTimeConverter
    extends CustomConverter<XMLGregorianCalendar, Time> {
        @Override
        public Time convert(XMLGregorianCalendar source, Type<? extends Time> destinationType) {
            return new Time(DateAndTimeConverters.toLong(source));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class XmlGregorianCalendarToSqlDateConverter
    extends CustomConverter<XMLGregorianCalendar, Date> {
        @Override
        public Date convert(XMLGregorianCalendar source, Type<? extends Date> destinationType) {
            return new Date(DateAndTimeConverters.toLong(source));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class TimeToDateConverter
    extends CustomConverter<Time, java.util.Date> {
        @Override
        public java.util.Date convert(Time source, Type<? extends java.util.Date> destinationType) {
            return new java.util.Date(source.getTime());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class SqlDateToDateConverter
    extends CustomConverter<Date, java.util.Date> {
        @Override
        public java.util.Date convert(Date source, Type<? extends java.util.Date> destinationType) {
            return new java.util.Date(source.getTime());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class DateToTimeConverter
    extends CustomConverter<java.util.Date, Time> {
        @Override
        public Time convert(java.util.Date source, Type<? extends Time> destinationType) {
            return new Time(source.getTime());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class DateToSqlDateConverter
    extends CustomConverter<java.util.Date, Date> {
        @Override
        public Date convert(java.util.Date source, Type<? extends Date> destinationType) {
            return new Date(source.getTime());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class DateToCalendarConverter
    extends BidirectionalConverter<java.util.Date, Calendar> {
        @Override
        public Calendar convertTo(java.util.Date source, Type<Calendar> destinationType) {
            return DateAndTimeConverters.toCalendar(source);
        }

        @Override
        public java.util.Date convertFrom(Calendar source, Type<java.util.Date> destinationType) {
            return DateAndTimeConverters.toDate(source);
        }
    }
}

