/*
 * Decompiled with CFR 0.152.
 */
package ma.glasnost.orika.converter.builtin;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import ma.glasnost.orika.converter.BidirectionalConverter;
import ma.glasnost.orika.metadata.Type;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DateToStringConverter
extends BidirectionalConverter<Date, String> {
    private final String pattern;
    private final ThreadLocal<SimpleDateFormat> dateFormats = new ThreadLocal();

    private SimpleDateFormat getDateFormat() {
        SimpleDateFormat formatter = this.dateFormats.get();
        if (formatter == null) {
            formatter = new SimpleDateFormat(this.pattern);
            this.dateFormats.set(formatter);
        }
        return formatter;
    }

    public DateToStringConverter(String format) {
        this.pattern = format;
    }

    @Override
    public String convertTo(Date source, Type<String> destinationType) {
        return this.getDateFormat().format(source);
    }

    @Override
    public Date convertFrom(String source, Type<Date> destinationType) {
        try {
            return this.getDateFormat().parse(source);
        }
        catch (ParseException e) {
            return null;
        }
    }
}

