/*
 * Decompiled with CFR 0.152.
 */
package ma.glasnost.orika.converter.builtin;

import java.math.BigDecimal;
import java.math.BigInteger;
import ma.glasnost.orika.converter.BidirectionalConverter;
import ma.glasnost.orika.metadata.Type;

public class NumericConverters {

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class FloatToShortConverter
    extends BidirectionalConverter<Float, Short> {
        private final boolean truncate;

        public FloatToShortConverter(boolean truncate) {
            this.truncate = truncate;
        }

        @Override
        public Short convertTo(Float source, Type<Short> destinationType) {
            if (!(this.truncate || source.compareTo(Float.valueOf(32767.0f)) <= 0 && source.compareTo(Float.valueOf(-32768.0f)) >= 0)) {
                throw new ArithmeticException("Overflow: " + source + " cannot be represented by " + Short.class.getCanonicalName());
            }
            return source.shortValue();
        }

        @Override
        public Float convertFrom(Short source, Type<Float> destinationType) {
            return Float.valueOf(source.floatValue());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class FloatToIntegerConverter
    extends BidirectionalConverter<Float, Integer> {
        private final boolean truncate;

        public FloatToIntegerConverter(boolean truncate) {
            this.truncate = truncate;
        }

        @Override
        public Integer convertTo(Float source, Type<Integer> destinationType) {
            if (!(this.truncate || source.compareTo(Float.valueOf(2.1474836E9f)) <= 0 && source.compareTo(Float.valueOf(-2.1474836E9f)) >= 0)) {
                throw new ArithmeticException("Overflow: " + source + " cannot be represented by " + Integer.class.getCanonicalName());
            }
            return source.intValue();
        }

        @Override
        public Float convertFrom(Integer source, Type<Float> destinationType) {
            return Float.valueOf(source.floatValue());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class FloatToLongConverter
    extends BidirectionalConverter<Float, Long> {
        private final boolean truncate;

        public FloatToLongConverter(boolean truncate) {
            this.truncate = truncate;
        }

        @Override
        public Long convertTo(Float source, Type<Long> destinationType) {
            if (!(this.truncate || source.compareTo(Float.valueOf(9.223372E18f)) <= 0 && source.compareTo(Float.valueOf(-9.223372E18f)) >= 0)) {
                throw new ArithmeticException("Overflow: " + source + " cannot be represented by " + Long.class.getCanonicalName());
            }
            return source.longValue();
        }

        @Override
        public Float convertFrom(Long source, Type<Float> destinationType) {
            return Float.valueOf(source.floatValue());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class DoubleToShortConverter
    extends BidirectionalConverter<Double, Short> {
        private final boolean truncate;

        public DoubleToShortConverter(boolean truncate) {
            this.truncate = truncate;
        }

        @Override
        public Short convertTo(Double source, Type<Short> destinationType) {
            if (!(this.truncate || source.compareTo(32767.0) <= 0 && source.compareTo(-32768.0) >= 0)) {
                throw new ArithmeticException("Overflow: " + source + " cannot be represented by " + Short.class.getCanonicalName());
            }
            return source.shortValue();
        }

        @Override
        public Double convertFrom(Short source, Type<Double> destinationType) {
            return source.doubleValue();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class DoubleToIntegerConverter
    extends BidirectionalConverter<Double, Integer> {
        private final boolean truncate;

        public DoubleToIntegerConverter(boolean truncate) {
            this.truncate = truncate;
        }

        @Override
        public Integer convertTo(Double source, Type<Integer> destinationType) {
            if (!(this.truncate || source.compareTo(2.147483647E9) <= 0 && source.compareTo(-2.147483648E9) >= 0)) {
                throw new ArithmeticException("Overflow: " + source + " cannot be represented by " + Integer.class.getCanonicalName());
            }
            return source.intValue();
        }

        @Override
        public Double convertFrom(Integer source, Type<Double> destinationType) {
            return source.doubleValue();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class DoubleToLongConverter
    extends BidirectionalConverter<Double, Long> {
        private final boolean truncate;

        public DoubleToLongConverter(boolean truncate) {
            this.truncate = truncate;
        }

        @Override
        public Long convertTo(Double source, Type<Long> destinationType) {
            if (!(this.truncate || source.compareTo(9.223372036854776E18) <= 0 && source.compareTo(-9.223372036854776E18) >= 0)) {
                throw new ArithmeticException("Overflow: " + source + " cannot be represented by " + Long.class.getCanonicalName());
            }
            return source.longValue();
        }

        @Override
        public Double convertFrom(Long source, Type<Double> destinationType) {
            return source.doubleValue();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class LongToIntegerConverter
    extends BidirectionalConverter<Long, Integer> {
        private final boolean truncate;

        public LongToIntegerConverter(boolean truncate) {
            this.truncate = truncate;
        }

        @Override
        public Integer convertTo(Long source, Type<Integer> destinationType) {
            if (!(this.truncate || source.compareTo((Long)Integer.MAX_VALUE) <= 0 && source.compareTo((Long)Integer.MIN_VALUE) >= 0)) {
                throw new ArithmeticException("Overflow: " + source + " cannot be represented by " + Integer.class.getCanonicalName());
            }
            return source.intValue();
        }

        @Override
        public Long convertFrom(Integer source, Type<Long> destinationType) {
            return source.longValue();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class LongToShortConverter
    extends BidirectionalConverter<Long, Short> {
        private final boolean truncate;

        public LongToShortConverter(boolean truncate) {
            this.truncate = truncate;
        }

        @Override
        public Short convertTo(Long source, Type<Short> destinationType) {
            if (!(this.truncate || source.compareTo(32767L) <= 0 && source.compareTo(-32768L) >= 0)) {
                throw new ArithmeticException("Overflow: " + source + " cannot be represented by " + Short.class.getCanonicalName());
            }
            return source.shortValue();
        }

        @Override
        public Long convertFrom(Short source, Type<Long> destinationType) {
            return source.longValue();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class IntegerToShortConverter
    extends BidirectionalConverter<Integer, Short> {
        private final boolean truncate;

        public IntegerToShortConverter(boolean truncate) {
            this.truncate = truncate;
        }

        @Override
        public Short convertTo(Integer source, Type<Short> destinationType) {
            if (!(this.truncate || source.compareTo((Integer)Short.MAX_VALUE) <= 0 && source.compareTo((Integer)Short.MIN_VALUE) >= 0)) {
                throw new ArithmeticException("Overflow: " + source + " cannot be represented by " + Short.class.getCanonicalName());
            }
            return source.shortValue();
        }

        @Override
        public Integer convertFrom(Short source, Type<Integer> destinationType) {
            return source.intValue();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class BigIntegerToIntegerConverter
    extends BidirectionalConverter<BigInteger, Integer> {
        private static final BigInteger MAX_INT = BigInteger.valueOf(Integer.MAX_VALUE);
        private static final BigInteger MIN_INT = BigInteger.valueOf(Integer.MIN_VALUE);
        private final boolean truncate;

        public BigIntegerToIntegerConverter(boolean truncate) {
            this.truncate = truncate;
        }

        @Override
        public Integer convertTo(BigInteger source, Type<Integer> destinationType) {
            if (!(this.truncate || source.compareTo(MAX_INT) <= 0 && source.compareTo(MIN_INT) >= 0)) {
                throw new ArithmeticException("Overflow: " + source + " cannot be represented by " + Integer.class.getCanonicalName());
            }
            return source.intValue();
        }

        @Override
        public BigInteger convertFrom(Integer source, Type<BigInteger> destinationType) {
            return BigInteger.valueOf(source.longValue());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class BigIntegerToLongConverter
    extends BidirectionalConverter<BigInteger, Long> {
        private static final BigInteger MAX_LONG = BigInteger.valueOf(Long.MAX_VALUE);
        private static final BigInteger MIN_LONG = BigInteger.valueOf(Long.MIN_VALUE);
        private final boolean truncate;

        public BigIntegerToLongConverter(boolean truncate) {
            this.truncate = truncate;
        }

        @Override
        public Long convertTo(BigInteger source, Type<Long> destinationType) {
            if (!(this.truncate || source.compareTo(MAX_LONG) <= 0 && source.compareTo(MIN_LONG) >= 0)) {
                throw new ArithmeticException("Overflow: " + source + " cannot be represented by " + Long.class.getCanonicalName());
            }
            return source.longValue();
        }

        @Override
        public BigInteger convertFrom(Long source, Type<BigInteger> destinationType) {
            return BigInteger.valueOf(source);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class BigDecimalToFloatConverter
    extends BidirectionalConverter<BigDecimal, Float> {
        @Override
        public Float convertTo(BigDecimal source, Type<Float> destinationType) {
            return Float.valueOf(source.floatValue());
        }

        @Override
        public BigDecimal convertFrom(Float source, Type<BigDecimal> destinationType) {
            return BigDecimal.valueOf(source.doubleValue());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class BigDecimalToDoubleConverter
    extends BidirectionalConverter<BigDecimal, Double> {
        @Override
        public Double convertTo(BigDecimal source, Type<Double> destinationType) {
            return source.doubleValue();
        }

        @Override
        public BigDecimal convertFrom(Double source, Type<BigDecimal> destinationType) {
            return BigDecimal.valueOf(source);
        }
    }
}

