/*
 * Decompiled with CFR 0.152.
 */
package ma.glasnost.orika.impl;

import java.util.concurrent.ConcurrentHashMap;
import ma.glasnost.orika.BoundMapperFacade;
import ma.glasnost.orika.MapperFacade;
import ma.glasnost.orika.MapperFactory;
import ma.glasnost.orika.MappingContext;
import ma.glasnost.orika.MappingContextFactory;
import ma.glasnost.orika.ObjectFactory;
import ma.glasnost.orika.impl.mapping.strategy.MappingStrategy;
import ma.glasnost.orika.metadata.Type;
import ma.glasnost.orika.metadata.TypeFactory;
import ma.glasnost.orika.unenhance.UnenhanceStrategy;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class DefaultBoundMapperFacade<A, B>
implements BoundMapperFacade<A, B> {
    protected final BoundStrategyCache aToB;
    protected final BoundStrategyCache bToA;
    protected final BoundStrategyCache aToBInPlace;
    protected final BoundStrategyCache bToAInPlace;
    protected volatile ObjectFactory<A> objectFactoryA;
    protected volatile ObjectFactory<B> objectFactoryB;
    protected final java.lang.reflect.Type rawAType;
    protected final java.lang.reflect.Type rawBType;
    protected final Type<A> aType;
    protected final Type<B> bType;
    protected final MapperFactory mapperFactory;
    protected final MappingContextFactory contextFactory;

    DefaultBoundMapperFacade(MapperFactory mapperFactory, MappingContextFactory contextFactory, java.lang.reflect.Type typeOfA, java.lang.reflect.Type typeOfB) {
        this.mapperFactory = mapperFactory;
        this.contextFactory = contextFactory;
        this.rawAType = typeOfA;
        this.rawBType = typeOfB;
        this.aType = TypeFactory.valueOf(typeOfA);
        this.bType = TypeFactory.valueOf(typeOfB);
        this.aToB = new BoundStrategyCache(this.aType, this.bType, mapperFactory.getMapperFacade(), mapperFactory.getUserUnenhanceStrategy(), false);
        this.bToA = new BoundStrategyCache(this.bType, this.aType, mapperFactory.getMapperFacade(), mapperFactory.getUserUnenhanceStrategy(), false);
        this.aToBInPlace = new BoundStrategyCache(this.aType, this.bType, mapperFactory.getMapperFacade(), mapperFactory.getUserUnenhanceStrategy(), true);
        this.bToAInPlace = new BoundStrategyCache(this.bType, this.aType, mapperFactory.getMapperFacade(), mapperFactory.getUserUnenhanceStrategy(), true);
    }

    @Override
    public Type<A> getAType() {
        return this.aType;
    }

    @Override
    public Type<B> getBType() {
        return this.bType;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public B map(A instanceA) {
        MappingContext context = this.contextFactory.getContext();
        try {
            B b = this.map(instanceA, context);
            return b;
        }
        finally {
            this.contextFactory.release(context);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public A mapReverse(B source) {
        MappingContext context = this.contextFactory.getContext();
        try {
            A a = this.mapReverse(source, context);
            return a;
        }
        finally {
            this.contextFactory.release(context);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public B map(A instanceA, B instanceB) {
        MappingContext context = this.contextFactory.getContext();
        try {
            B b = this.map(instanceA, instanceB, context);
            return b;
        }
        finally {
            this.contextFactory.release(context);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public A mapReverse(B instanceB, A instanceA) {
        MappingContext context = this.contextFactory.getContext();
        try {
            A a = this.mapReverse(instanceB, instanceA, context);
            return a;
        }
        finally {
            this.contextFactory.release(context);
        }
    }

    @Override
    public B map(A instanceA, MappingContext context) {
        Object result = context.getMappedObject(instanceA, this.bType);
        if (result == null && instanceA != null) {
            result = this.aToB.getStrategy(instanceA, context).map(instanceA, null, context);
        }
        return (B)result;
    }

    @Override
    public A mapReverse(B instanceB, MappingContext context) {
        Object result = context.getMappedObject(instanceB, this.aType);
        if (result == null && instanceB != null) {
            result = this.bToA.getStrategy(instanceB, context).map(instanceB, null, context);
        }
        return (A)result;
    }

    @Override
    public B map(A instanceA, B instanceB, MappingContext context) {
        Object result = context.getMappedObject(instanceA, this.bType);
        if (result == null && instanceA != null) {
            result = this.aToBInPlace.getStrategy(instanceA, context).map(instanceA, instanceB, context);
        }
        return (B)result;
    }

    @Override
    public A mapReverse(B instanceB, A instanceA, MappingContext context) {
        Object result = context.getMappedObject(instanceB, this.aType);
        if (result == null && instanceB != null) {
            result = this.bToAInPlace.getStrategy(instanceB, context).map(instanceB, instanceA, context);
        }
        return (A)result;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "(" + this.aType + ", " + this.bType + ")";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public B newObject(A source, MappingContext context) {
        if (this.objectFactoryB == null) {
            DefaultBoundMapperFacade defaultBoundMapperFacade = this;
            synchronized (defaultBoundMapperFacade) {
                if (this.objectFactoryB == null) {
                    this.objectFactoryB = this.mapperFactory.lookupObjectFactory(this.bType);
                }
            }
        }
        return this.objectFactoryB.create(source, context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public A newObjectReverse(B source, MappingContext context) {
        if (this.objectFactoryA == null) {
            DefaultBoundMapperFacade defaultBoundMapperFacade = this;
            synchronized (defaultBoundMapperFacade) {
                if (this.objectFactoryA == null) {
                    this.objectFactoryA = this.mapperFactory.lookupObjectFactory(this.aType);
                }
            }
        }
        return this.objectFactoryA.create(source, context);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class BoundStrategyCache {
        private final Type<?> aType;
        private final Type<?> bType;
        private final boolean inPlace;
        private final MapperFacade mapperFacade;
        private final UnenhanceStrategy unenhanceStrategy;
        protected final ConcurrentHashMap<Class<?>, MappingStrategy> strategies = new ConcurrentHashMap(2);
        private volatile Class<?> idClass;
        private volatile MappingStrategy defaultStrategy;

        private BoundStrategyCache(Type<?> aType, Type<?> bType, MapperFacade mapperFacade, UnenhanceStrategy unenhanceStrategy, boolean inPlace) {
            this.aType = aType;
            this.bType = bType;
            this.mapperFacade = mapperFacade;
            this.unenhanceStrategy = unenhanceStrategy;
            this.inPlace = inPlace;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public MappingStrategy getStrategy(Object sourceObject, MappingContext context) {
            MappingStrategy strategy = null;
            Class<?> sourceClass = this.getClass(sourceObject);
            if (this.defaultStrategy != null && sourceClass.equals(this.idClass)) {
                strategy = this.defaultStrategy;
            } else if (this.defaultStrategy == null) {
                BoundStrategyCache boundStrategyCache = this;
                synchronized (boundStrategyCache) {
                    if (this.defaultStrategy == null) {
                        this.defaultStrategy = this.mapperFacade.resolveMappingStrategy(sourceObject, this.aType, this.bType, this.inPlace, context);
                        this.idClass = sourceClass;
                        this.strategies.put(this.idClass, this.defaultStrategy);
                    }
                }
                strategy = this.defaultStrategy;
            } else {
                strategy = this.strategies.get(sourceClass);
                if (strategy == null) {
                    strategy = this.mapperFacade.resolveMappingStrategy(sourceObject, this.aType, this.bType, this.inPlace, context);
                    this.strategies.put(sourceClass, strategy);
                }
            }
            context.setResolvedSourceType(strategy.getSoureType());
            context.setResolvedDestinationType(strategy.getDestinationType());
            return strategy;
        }

        protected Class<?> getClass(Object object) {
            if (this.unenhanceStrategy == null) {
                return object.getClass();
            }
            return this.unenhanceStrategy.unenhanceObject(object, TypeFactory.TYPE_OF_OBJECT).getClass();
        }
    }
}

