/*
 * Decompiled with CFR 0.152.
 */
package ma.glasnost.orika.impl;

import java.util.ArrayList;
import java.util.List;
import ma.glasnost.orika.MapperFactory;
import ma.glasnost.orika.impl.generator.AggregateSpecification;
import ma.glasnost.orika.impl.generator.CodeGenerationStrategy;
import ma.glasnost.orika.impl.generator.Specification;
import ma.glasnost.orika.impl.generator.specification.AnyTypeToString;
import ma.glasnost.orika.impl.generator.specification.ApplyRegisteredMapper;
import ma.glasnost.orika.impl.generator.specification.ArrayOrCollectionToArray;
import ma.glasnost.orika.impl.generator.specification.ArrayOrCollectionToCollection;
import ma.glasnost.orika.impl.generator.specification.ArrayOrCollectionToMap;
import ma.glasnost.orika.impl.generator.specification.Convert;
import ma.glasnost.orika.impl.generator.specification.CopyByReference;
import ma.glasnost.orika.impl.generator.specification.EnumToEnum;
import ma.glasnost.orika.impl.generator.specification.MapToArray;
import ma.glasnost.orika.impl.generator.specification.MapToCollection;
import ma.glasnost.orika.impl.generator.specification.MapToMap;
import ma.glasnost.orika.impl.generator.specification.MultiOccurrenceElementToObject;
import ma.glasnost.orika.impl.generator.specification.MultiOccurrenceToMultiOccurrence;
import ma.glasnost.orika.impl.generator.specification.ObjectToMultiOccurrenceElement;
import ma.glasnost.orika.impl.generator.specification.ObjectToObject;
import ma.glasnost.orika.impl.generator.specification.PrimitiveAndObject;
import ma.glasnost.orika.impl.generator.specification.StringToEnum;
import ma.glasnost.orika.impl.generator.specification.StringToStringConvertible;
import ma.glasnost.orika.impl.generator.specification.UnmappableEnum;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultCodeGenerationStrategy
implements CodeGenerationStrategy {
    private final ArrayList<Specification> specifications = new ArrayList();
    private final ArrayList<AggregateSpecification> aggregateSpecifications;

    DefaultCodeGenerationStrategy() {
        this.specifications.add(new Convert());
        this.specifications.add(new CopyByReference());
        this.specifications.add(new ApplyRegisteredMapper());
        this.specifications.add(new EnumToEnum());
        this.specifications.add(new StringToEnum());
        this.specifications.add(new UnmappableEnum());
        this.specifications.add(new ArrayOrCollectionToArray());
        this.specifications.add(new ArrayOrCollectionToCollection());
        this.specifications.add(new MapToMap());
        this.specifications.add(new MapToArray());
        this.specifications.add(new MapToCollection());
        this.specifications.add(new ArrayOrCollectionToMap());
        this.specifications.add(new StringToStringConvertible());
        this.specifications.add(new AnyTypeToString());
        this.specifications.add(new MultiOccurrenceElementToObject());
        this.specifications.add(new ObjectToMultiOccurrenceElement());
        this.specifications.add(new PrimitiveAndObject());
        this.specifications.add(new ObjectToObject());
        this.aggregateSpecifications = new ArrayList();
        this.aggregateSpecifications.add(new MultiOccurrenceToMultiOccurrence());
    }

    @Override
    public void setMapperFactory(MapperFactory mapperFactory) {
        for (Specification specification : this.specifications) {
            specification.setMapperFactory(mapperFactory);
        }
        for (AggregateSpecification aggregateSpecification : this.aggregateSpecifications) {
            aggregateSpecification.setMapperFactory(mapperFactory);
        }
    }

    @Override
    public void addSpecification(Specification spec, CodeGenerationStrategy.Position relativePosition, Class<Specification> relativeSpec) {
        DefaultCodeGenerationStrategy.addSpec(this.specifications, spec, relativePosition, relativeSpec);
    }

    private static <T> void addSpec(List<T> specifications, T spec, CodeGenerationStrategy.Position relativePosition, Class<T> relativeSpec) {
        if (relativePosition == null || relativePosition == CodeGenerationStrategy.Position.LAST) {
            specifications.add(spec);
        } else if (relativePosition == CodeGenerationStrategy.Position.FIRST) {
            specifications.add(0, spec);
        } else {
            int len = specifications.size();
            for (int i = 0; i < len; ++i) {
                T s = specifications.get(i);
                if (!s.getClass().equals(relativeSpec)) continue;
                switch (relativePosition) {
                    case IN_PLACE_OF: {
                        specifications.remove(i);
                        break;
                    }
                    case BEFORE: {
                        break;
                    }
                    case AFTER: {
                        ++i;
                    }
                }
                specifications.add(i, spec);
                break;
            }
        }
    }

    @Override
    public List<Specification> getSpecifications() {
        return this.specifications;
    }

    @Override
    public void addAggregateSpecification(AggregateSpecification spec, CodeGenerationStrategy.Position relativePosition, Class<AggregateSpecification> relativeSpec) {
        DefaultCodeGenerationStrategy.addSpec(this.aggregateSpecifications, spec, relativePosition, relativeSpec);
    }

    @Override
    public List<AggregateSpecification> getAggregateSpecifications() {
        return this.aggregateSpecifications;
    }
}

