/*
 * Decompiled with CFR 0.152.
 */
package ma.glasnost.orika.impl;

import java.lang.reflect.Constructor;
import java.lang.reflect.Proxy;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import ma.glasnost.orika.BoundMapperFacade;
import ma.glasnost.orika.DefaultFieldMapper;
import ma.glasnost.orika.MapEntry;
import ma.glasnost.orika.Mapper;
import ma.glasnost.orika.MapperFacade;
import ma.glasnost.orika.MapperFactory;
import ma.glasnost.orika.MappingContext;
import ma.glasnost.orika.MappingContextFactory;
import ma.glasnost.orika.MappingException;
import ma.glasnost.orika.MappingHint;
import ma.glasnost.orika.ObjectFactory;
import ma.glasnost.orika.Properties;
import ma.glasnost.orika.constructor.ConstructorResolverStrategy;
import ma.glasnost.orika.converter.ConverterFactory;
import ma.glasnost.orika.converter.builtin.BuiltinConverters;
import ma.glasnost.orika.impl.Comparators;
import ma.glasnost.orika.impl.DefaultBoundMapperFacade;
import ma.glasnost.orika.impl.DefaultCodeGenerationStrategy;
import ma.glasnost.orika.impl.DefaultConstructorObjectFactory;
import ma.glasnost.orika.impl.GeneratedMapperBase;
import ma.glasnost.orika.impl.GeneratedObjectFactory;
import ma.glasnost.orika.impl.MapperFacadeImpl;
import ma.glasnost.orika.impl.NonCyclicBoundMapperFacade;
import ma.glasnost.orika.impl.ReversedMapper;
import ma.glasnost.orika.impl.UtilityResolver;
import ma.glasnost.orika.impl.generator.CodeGenerationStrategy;
import ma.glasnost.orika.impl.generator.CompilerStrategy;
import ma.glasnost.orika.impl.generator.MapperGenerator;
import ma.glasnost.orika.impl.generator.ObjectFactoryGenerator;
import ma.glasnost.orika.impl.util.ClassUtil;
import ma.glasnost.orika.inheritance.DefaultSuperTypeResolverStrategy;
import ma.glasnost.orika.inheritance.SuperTypeResolverStrategy;
import ma.glasnost.orika.metadata.ClassMap;
import ma.glasnost.orika.metadata.ClassMapBuilder;
import ma.glasnost.orika.metadata.ClassMapBuilderFactory;
import ma.glasnost.orika.metadata.ClassMapBuilderForArrays;
import ma.glasnost.orika.metadata.ClassMapBuilderForLists;
import ma.glasnost.orika.metadata.ClassMapBuilderForMaps;
import ma.glasnost.orika.metadata.MapperKey;
import ma.glasnost.orika.metadata.TypeFactory;
import ma.glasnost.orika.property.PropertyResolverStrategy;
import ma.glasnost.orika.unenhance.BaseUnenhancer;
import ma.glasnost.orika.unenhance.UnenhanceStrategy;
import ma.glasnost.orika.util.SortedCollection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultMapperFactory
implements MapperFactory {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultMapperFactory.class);
    private final MapperFacade mapperFacade;
    private final MapperGenerator mapperGenerator;
    private final ObjectFactoryGenerator objectFactoryGenerator;
    private final Map<MapperKey, ClassMap<Object, Object>> classMapRegistry;
    private final SortedCollection<Mapper<Object, Object>> mappersRegistry;
    private final MappingContextFactory contextFactory;
    private final ConcurrentHashMap<ma.glasnost.orika.metadata.Type<? extends Object>, ObjectFactory<? extends Object>> objectFactoryRegistry;
    private final Map<ma.glasnost.orika.metadata.Type<?>, Set<ma.glasnost.orika.metadata.Type<?>>> explicitAToBRegistry;
    private final Map<ma.glasnost.orika.metadata.Type<?>, Set<ma.glasnost.orika.metadata.Type<?>>> dynamicAToBRegistry;
    private final List<DefaultFieldMapper> defaultFieldMappers;
    private final UnenhanceStrategy unenhanceStrategy;
    private final UnenhanceStrategy userUnenahanceStrategy;
    private final ConverterFactory converterFactory;
    private final CompilerStrategy compilerStrategy;
    private final PropertyResolverStrategy propertyResolverStrategy;
    private final Map<Type, ma.glasnost.orika.metadata.Type<?>> concreteTypeRegistry;
    private final ClassMapBuilderFactory classMapBuilderFactory;
    private ClassMapBuilderFactory chainClassMapBuilderFactory;
    private final Map<MapperKey, Set<ClassMap<Object, Object>>> usedMapperMetadataRegistry;
    private final boolean useAutoMapping;
    private final boolean useBuiltinConverters;
    private volatile boolean isBuilt = false;
    private volatile boolean isBuilding = false;

    protected DefaultMapperFactory(MapperFactoryBuilder<?, ?> builder) {
        this.converterFactory = builder.converterFactory;
        this.compilerStrategy = builder.compilerStrategy;
        this.classMapRegistry = new ConcurrentHashMap<MapperKey, ClassMap<Object, Object>>();
        this.mappersRegistry = new SortedCollection<Mapper<Object, Object>>(Comparators.MAPPER);
        this.explicitAToBRegistry = new ConcurrentHashMap();
        this.dynamicAToBRegistry = new ConcurrentHashMap();
        this.usedMapperMetadataRegistry = new ConcurrentHashMap<MapperKey, Set<ClassMap<Object, Object>>>();
        this.objectFactoryRegistry = new ConcurrentHashMap();
        this.defaultFieldMappers = new CopyOnWriteArrayList<DefaultFieldMapper>();
        this.userUnenahanceStrategy = builder.unenhanceStrategy;
        this.unenhanceStrategy = this.buildUnenhanceStrategy(builder.unenhanceStrategy, builder.superTypeStrategy);
        this.contextFactory = new MappingContext.Factory();
        this.mapperFacade = this.buildMapperFacade(this.contextFactory, this.unenhanceStrategy);
        this.concreteTypeRegistry = new ConcurrentHashMap();
        if (builder.classMaps != null) {
            for (ClassMap<?, ?> classMap : builder.classMaps) {
                this.registerClassMap(classMap);
            }
        }
        this.propertyResolverStrategy = builder.propertyResolverStrategy;
        this.classMapBuilderFactory = builder.classMapBuilderFactory;
        this.classMapBuilderFactory.setPropertyResolver(this.propertyResolverStrategy);
        this.classMapBuilderFactory.setMapperFactory(this);
        this.addClassMapBuilderFactory(new ClassMapBuilderForArrays.Factory());
        this.addClassMapBuilderFactory(new ClassMapBuilderForLists.Factory());
        this.addClassMapBuilderFactory(new ClassMapBuilderForMaps.Factory());
        this.mapperGenerator = new MapperGenerator(this, builder.compilerStrategy);
        this.objectFactoryGenerator = new ObjectFactoryGenerator(this, builder.constructorResolverStrategy, builder.compilerStrategy);
        this.useAutoMapping = builder.useAutoMapping;
        this.useBuiltinConverters = builder.useBuiltinConverters;
        builder.codeGenerationStrategy.setMapperFactory(this);
        Map<Object, Object> props = this.contextFactory.getGlobalProperties();
        props.put((Object)Properties.SHOULD_MAP_NULLS, builder.mapNulls);
        props.put((Object)Properties.CODE_GENERATION_STRATEGY, builder.codeGenerationStrategy);
        props.put((Object)Properties.COMPILER_STRATEGY, builder.compilerStrategy);
        props.put((Object)Properties.PROPERTY_RESOLVER_STRATEGY, builder.propertyResolverStrategy);
        props.put((Object)Properties.UNENHANCE_STRATEGY, this.unenhanceStrategy);
        props.put((Object)Properties.MAPPER_FACTORY, this);
        this.registerConcreteType(Collection.class, ArrayList.class);
        this.registerConcreteType(List.class, ArrayList.class);
        this.registerConcreteType(Set.class, LinkedHashSet.class);
        this.registerConcreteType(Map.class, LinkedHashMap.class);
        this.registerConcreteType(Map.Entry.class, MapEntry.class);
    }

    protected void addClassMapBuilderFactory(ClassMapBuilderFactory factory) {
        factory.setChainClassMapBuilderFactory(this.chainClassMapBuilderFactory);
        this.chainClassMapBuilderFactory = factory;
        factory.setPropertyResolver(this.propertyResolverStrategy);
        factory.setMapperFactory(this);
    }

    protected UnenhanceStrategy buildUnenhanceStrategy(UnenhanceStrategy unenhanceStrategy, SuperTypeResolverStrategy superTypeStrategy) {
        BaseUnenhancer unenhancer = new BaseUnenhancer();
        if (unenhanceStrategy != null) {
            unenhancer.addUnenhanceStrategy(unenhanceStrategy);
        }
        if (superTypeStrategy != null) {
            unenhancer.addSuperTypeResolverStrategy(superTypeStrategy);
        }
        DefaultSuperTypeResolverStrategy inaccessibleTypeStrategy = new DefaultSuperTypeResolverStrategy(){

            public boolean isTypeAccessible(ma.glasnost.orika.metadata.Type<?> type) {
                try {
                    DefaultMapperFactory.this.compilerStrategy.assureTypeIsAccessible((Class<?>)type.getRawType());
                    return true;
                }
                catch (CompilerStrategy.SourceCodeGenerationException e) {
                    return false;
                }
            }

            @Override
            public boolean isAcceptable(ma.glasnost.orika.metadata.Type<?> type) {
                return this.isTypeAccessible(type) && !Proxy.class.equals((Object)type.getRawType());
            }
        };
        unenhancer.addSuperTypeResolverStrategy(inaccessibleTypeStrategy);
        return unenhancer;
    }

    protected MapperFacade buildMapperFacade(MappingContextFactory contextFactory, UnenhanceStrategy unenhanceStrategy) {
        return new MapperFacadeImpl(this, contextFactory, unenhanceStrategy);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <A, B> Mapper<A, B> lookupMapper(MapperKey mapperKey) {
        MappingContext context = this.contextFactory.getContext();
        try {
            Mapper<Object, Object> mapper = this.lookupMapper(mapperKey, context);
            return mapper;
        }
        finally {
            this.contextFactory.release(context);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Mapper<Object, Object> lookupMapper(MapperKey mapperKey, MappingContext context) {
        GeneratedMapperBase mapper = this.getRegisteredMapper(mapperKey.getAType(), mapperKey.getBType(), false);
        if (mapper == null && this.useAutoMapping) {
            DefaultMapperFactory defaultMapperFactory = this;
            synchronized (defaultMapperFactory) {
                try {
                    if (ClassUtil.isImmutable(mapperKey.getBType()) && !this.objectFactoryRegistry.containsKey(mapperKey.getBType())) {
                        throw new MappingException("No converter registered for conversion from " + mapperKey.getAType() + " to " + mapperKey.getBType() + ", nor any ObjectFactory which can generate " + mapperKey.getBType() + " from " + mapperKey.getAType());
                    }
                    if (LOGGER.isDebugEnabled()) {
                        LOGGER.debug("No mapper registered for " + mapperKey + ": attempting to generate");
                    }
                    ClassMap<Object, Object> classMap = this.classMap(mapperKey.getAType(), mapperKey.getBType()).byDefault(new DefaultFieldMapper[0]).toClassMap();
                    this.buildObjectFactories(classMap, context);
                    mapper = this.buildMapper(classMap, true, context);
                    this.initializeUsedMappers(classMap);
                }
                catch (MappingException e) {
                    e.setSourceType(mapperKey.getAType());
                    e.setDestinationType(mapperKey.getBType());
                    throw e;
                }
            }
        }
        return mapper;
    }

    @Override
    public boolean existsRegisteredMapper(ma.glasnost.orika.metadata.Type<?> sourceType, ma.glasnost.orika.metadata.Type<?> destinationType, boolean includeAutoGeneratedMappers) {
        return this.getRegisteredMapper(sourceType, destinationType, includeAutoGeneratedMappers) != null;
    }

    protected <A, B> Mapper<A, B> getRegisteredMapper(MapperKey mapperKey) {
        return this.getRegisteredMapper(mapperKey.getAType(), mapperKey.getBType(), false);
    }

    protected <A, B> Mapper<A, B> getRegisteredMapper(ma.glasnost.orika.metadata.Type<A> typeA, ma.glasnost.orika.metadata.Type<B> typeB, boolean includeAutoGeneratedMappers) {
        for (Mapper<Object, Object> mapper : this.mappersRegistry) {
            if (mapper.getAType().equals(typeA) && mapper.getBType().equals(typeB) || mapper.getAType().equals(typeB) && mapper.getBType().equals(typeA)) {
                return mapper;
            }
            if ((!mapper.getAType().isAssignableFrom(typeA) || !mapper.getBType().isAssignableFrom(typeB)) && (!mapper.getAType().isAssignableFrom(typeB) || !mapper.getBType().isAssignableFrom(typeA))) continue;
            if (includeAutoGeneratedMappers || !(mapper instanceof GeneratedMapperBase)) {
                return mapper;
            }
            if (((GeneratedMapperBase)mapper).isFromAutoMapping()) continue;
            return mapper;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MapperFacade getMapperFacade() {
        if (!this.isBuilt) {
            MapperFacade mapperFacade = this.mapperFacade;
            synchronized (mapperFacade) {
                if (!this.isBuilt) {
                    this.build();
                }
            }
        }
        return this.mapperFacade;
    }

    public <D> void registerObjectFactory(ObjectFactory<D> objectFactory, ma.glasnost.orika.metadata.Type<D> destinationType) {
        this.objectFactoryRegistry.put(destinationType, objectFactory);
    }

    @Override
    @Deprecated
    public void registerMappingHint(MappingHint ... hints) {
        DefaultFieldMapper[] mappers = new DefaultFieldMapper[hints.length];
        int len = hints.length;
        for (int i = 0; i < len; ++i) {
            mappers[i] = new MappingHint.DefaultFieldMappingConverter(hints[i]);
        }
        this.registerDefaultFieldMapper(mappers);
    }

    @Override
    public void registerDefaultFieldMapper(DefaultFieldMapper ... mappers) {
        this.defaultFieldMappers.addAll(Arrays.asList(mappers));
    }

    @Override
    public void registerConcreteType(ma.glasnost.orika.metadata.Type<?> abstractType, ma.glasnost.orika.metadata.Type<?> concreteType) {
        this.concreteTypeRegistry.put(abstractType, concreteType);
    }

    @Override
    public void registerConcreteType(Class<?> abstractType, Class<?> concreteType) {
        this.concreteTypeRegistry.put(abstractType, TypeFactory.valueOf(concreteType));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> ObjectFactory<T> lookupObjectFactory(ma.glasnost.orika.metadata.Type<T> targetType) {
        MappingContext context = this.contextFactory.getContext();
        try {
            ObjectFactory<T> objectFactory = this.lookupObjectFactory(targetType, context);
            return objectFactory;
        }
        finally {
            this.contextFactory.release(context);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> ObjectFactory<T> lookupObjectFactory(ma.glasnost.orika.metadata.Type<T> type, MappingContext context) {
        ObjectFactory<Object> result;
        block12: {
            if (type == null) {
                return null;
            }
            ma.glasnost.orika.metadata.Type<Object> targetType = type;
            result = this.objectFactoryRegistry.get(targetType);
            if (result != null) break block12;
            DefaultMapperFactory defaultMapperFactory = this;
            synchronized (defaultMapperFactory) {
                Constructor<?>[] constructors;
                block13: {
                    block11: {
                        if (!ClassUtil.isConcrete(targetType)) {
                            targetType = this.resolveConcreteType(targetType, targetType);
                        }
                        constructors = ((Class)targetType.getRawType()).getConstructors();
                        if (!this.useAutoMapping && this.isBuilt) break block13;
                        if (constructors.length == 1 && constructors[0].getParameterTypes().length == 0) {
                            result = new DefaultConstructorObjectFactory(targetType.getRawType());
                        } else {
                            try {
                                result = this.objectFactoryGenerator.build(targetType, context);
                            }
                            catch (MappingException e) {
                                for (Constructor<?> c : constructors) {
                                    if (c.getParameterTypes().length != 0) continue;
                                    result = new DefaultConstructorObjectFactory(targetType.getRawType());
                                    break;
                                }
                                if (result != null) break block11;
                                throw e;
                            }
                        }
                    }
                    ObjectFactory<? extends Object> existing = this.objectFactoryRegistry.putIfAbsent(targetType, result);
                    if (existing == null) break block12;
                    result = existing;
                    break block12;
                }
                for (Constructor<?> constructor : constructors) {
                    if (constructor.getParameterTypes().length != 0) continue;
                    result = new DefaultConstructorObjectFactory(targetType.getRawType());
                    break;
                }
            }
        }
        return result;
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public <S, D> ma.glasnost.orika.metadata.Type<? extends D> lookupConcreteDestinationType(ma.glasnost.orika.metadata.Type<S> sourceType, ma.glasnost.orika.metadata.Type<D> destinationType, MappingContext context) {
        void var4_10;
        void var4_8;
        ma.glasnost.orika.metadata.Type<D> type;
        ma.glasnost.orika.metadata.Type<D> type2 = type = context == null ? null : context.getConcreteClass(sourceType, destinationType);
        if (type != null) {
            return type;
        }
        Set<ma.glasnost.orika.metadata.Type<?>> destinationSet = this.explicitAToBRegistry.get(sourceType);
        if (destinationSet != null && !destinationSet.isEmpty()) {
            for (ma.glasnost.orika.metadata.Type<?> type3 : destinationSet) {
                if (!destinationType.isAssignableFrom(type3) || !ClassUtil.isConcrete(type3) || !type3.equals(destinationType) && !this.existsRegisteredMapper(sourceType, type3, false) && ClassUtil.isConcrete(destinationType)) continue;
                return type3;
            }
        }
        if (ClassUtil.isConcrete(destinationType)) {
            return destinationType;
        }
        destinationSet = this.dynamicAToBRegistry.get(sourceType);
        if (destinationSet != null && !destinationSet.isEmpty()) {
            for (ma.glasnost.orika.metadata.Type<?> type3 : destinationSet) {
                if (!destinationType.isAssignableFrom(type3) || !ClassUtil.isConcrete(type3) || !type3.equals(destinationType) && !this.existsRegisteredMapper(sourceType, type3, false) && ClassUtil.isConcrete(destinationType)) continue;
                return type3;
            }
        } else {
            Mapper<S, D> registeredMapper = this.getRegisteredMapper(sourceType, destinationType, true);
            if (registeredMapper != null) {
                ma.glasnost.orika.metadata.Type<Object> type4;
                ma.glasnost.orika.metadata.Type<Object> type5 = type4 = registeredMapper.getAType().isAssignableFrom(sourceType) ? registeredMapper.getBType() : registeredMapper.getAType();
                if (ClassUtil.isConcrete(type4)) return null;
                ma.glasnost.orika.metadata.Type<?> type6 = this.resolveConcreteType(type4, destinationType);
            } else {
                ma.glasnost.orika.metadata.Type<?> type7 = this.resolveConcreteType(destinationType, destinationType);
            }
        }
        if (var4_8 != null) return var4_10;
        ma.glasnost.orika.metadata.Type<?> type8 = this.resolveConcreteType(destinationType, destinationType);
        return var4_10;
    }

    protected ma.glasnost.orika.metadata.Type<?> resolveConcreteType(ma.glasnost.orika.metadata.Type<?> type, ma.glasnost.orika.metadata.Type<?> originalType) {
        ma.glasnost.orika.metadata.Type<Object> concreteType = this.concreteTypeRegistry.get(type);
        if (concreteType == null && (concreteType = this.concreteTypeRegistry.get(type.getRawType())) != null) {
            concreteType = TypeFactory.resolveValueOf(concreteType.getRawType(), type);
        }
        if (concreteType != null && !concreteType.isAssignableFrom(originalType)) {
            if (ClassUtil.isConcrete(originalType)) {
                concreteType = originalType;
            } else {
                concreteType = this.concreteTypeRegistry.get(originalType);
                if (concreteType == null && (concreteType = this.concreteTypeRegistry.get(originalType.getRawType())) != null) {
                    concreteType = TypeFactory.resolveValueOf(concreteType, originalType);
                }
            }
        }
        return concreteType;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized <A, B> void registerClassMap(ClassMap<A, B> classMap) {
        this.classMapRegistry.put(new MapperKey(classMap.getAType(), classMap.getBType()), classMap);
        if (this.isBuilding || this.isBuilt) {
            MappingContext context = this.contextFactory.getContext();
            try {
                this.buildMapper(classMap, this.isBuilding, context);
                this.buildObjectFactories(classMap, context);
                this.initializeUsedMappers(classMap);
            }
            finally {
                this.contextFactory.release(context);
            }
        }
    }

    @Override
    public <A, B> void registerClassMap(ClassMapBuilder<A, B> builder) {
        this.registerClassMap(builder.toClassMap());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void build() {
        if (!this.isBuilding && !this.isBuilt) {
            this.isBuilding = true;
            MappingContext context = this.contextFactory.getContext();
            try {
                this.converterFactory.setMapperFacade(this.mapperFacade);
                if (this.useBuiltinConverters) {
                    BuiltinConverters.register(this.converterFactory);
                }
                this.buildClassMapRegistry();
                for (ClassMap<Object, Object> classMap : this.classMapRegistry.values()) {
                    this.buildMapper(classMap, false, context);
                }
                for (ClassMap<Object, Object> classMap : this.classMapRegistry.values()) {
                    this.buildObjectFactories(classMap, context);
                    this.initializeUsedMappers(classMap);
                }
            }
            finally {
                this.contextFactory.release(context);
            }
            this.isBuilt = true;
            this.isBuilding = false;
        }
    }

    @Override
    public Set<ClassMap<Object, Object>> lookupUsedClassMap(MapperKey mapperKey) {
        Set<ClassMap<Object, Object>> usedClassMapSet = this.usedMapperMetadataRegistry.get(mapperKey);
        if (usedClassMapSet == null) {
            usedClassMapSet = Collections.emptySet();
        }
        return usedClassMapSet;
    }

    private void buildClassMapRegistry() {
        HashMap<MapperKey, ClassMap> classMapsDictionary = new HashMap<MapperKey, ClassMap>();
        HashSet<ClassMap<Object, Object>> classMaps = new HashSet<ClassMap<Object, Object>>(this.classMapRegistry.values());
        for (ClassMap classMap : classMaps) {
            classMapsDictionary.put(new MapperKey(classMap.getAType(), classMap.getBType()), classMap);
        }
        for (ClassMap classMap : classMaps) {
            MapperKey key = new MapperKey(classMap.getAType(), classMap.getBType());
            HashSet<ClassMap> usedClassMapSet = new HashSet<ClassMap>();
            for (MapperKey parentMapperKey : classMap.getUsedMappers()) {
                ClassMap usedClassMap = (ClassMap)classMapsDictionary.get(parentMapperKey);
                if (usedClassMap == null) {
                    throw new MappingException("Cannot find class mapping using mapper : " + classMap.getMapperClassName());
                }
                usedClassMapSet.add(usedClassMap);
            }
            this.usedMapperMetadataRegistry.put(key, usedClassMapSet);
        }
    }

    private <S, D> void buildObjectFactories(ClassMap<S, D> classMap, MappingContext context) {
        GeneratedObjectFactory objectFactory;
        ma.glasnost.orika.metadata.Type<S> aType = classMap.getAType();
        ma.glasnost.orika.metadata.Type<D> bType = classMap.getBType();
        if (classMap.getConstructorA() != null && this.lookupObjectFactory(aType) == null) {
            objectFactory = this.objectFactoryGenerator.build(aType, context);
            this.registerObjectFactory((ObjectFactory<D>)objectFactory, (ma.glasnost.orika.metadata.Type<D>)aType);
        }
        if (classMap.getConstructorB() != null && this.lookupObjectFactory(bType) == null) {
            objectFactory = this.objectFactoryGenerator.build(bType, context);
            this.registerObjectFactory((ObjectFactory<D>)objectFactory, bType);
        }
    }

    private void initializeUsedMappers(ClassMap<?, ?> classMap) {
        Mapper[] usedMappers;
        Mapper mapper = this.lookupMapper(new MapperKey(classMap.getAType(), classMap.getBType()));
        ArrayList<Mapper<Object, Object>> parentMappers = new ArrayList<Mapper<Object, Object>>();
        if (!classMap.getUsedMappers().isEmpty()) {
            for (MapperKey parentMapperKey : classMap.getUsedMappers()) {
                this.collectUsedMappers(classMap, parentMappers, parentMapperKey);
            }
        } else {
            usedMappers = new SortedCollection(Comparators.MAPPER_KEY);
            for (MapperKey key : this.classMapRegistry.keySet()) {
                if (key.getAType().equals(classMap.getAType()) && key.getBType().equals(classMap.getBType()) || !key.getAType().isAssignableFrom(classMap.getAType()) || !key.getBType().isAssignableFrom(classMap.getBType())) continue;
                usedMappers.add(key);
            }
            if (!usedMappers.isEmpty()) {
                MapperKey parentKey = (MapperKey)usedMappers.first();
                this.collectUsedMappers(classMap, parentMappers, parentKey);
            }
        }
        usedMappers = parentMappers.toArray(new Mapper[parentMappers.size()]);
        for (int i = 0; i < usedMappers.length; ++i) {
            Mapper usedMapper = usedMappers[i];
            if (!usedMapper.getAType().isAssignableFrom(classMap.getBType()) || !usedMapper.getBType().isAssignableFrom(classMap.getAType())) continue;
            usedMappers[i] = ReversedMapper.reverse(usedMapper);
        }
        mapper.setUsedMappers(usedMappers);
    }

    private void collectUsedMappers(ClassMap<?, ?> classMap, List<Mapper<Object, Object>> parentMappers, MapperKey parentMapperKey) {
        Mapper parentMapper = this.lookupMapper(parentMapperKey);
        if (parentMapper == null) {
            throw new MappingException("Cannot find used mappers for : " + classMap.getMapperClassName());
        }
        parentMappers.add(parentMapper);
        Set<ClassMap<Object, Object>> usedClassMapSet = this.usedMapperMetadataRegistry.get(parentMapperKey);
        if (usedClassMapSet != null) {
            for (ClassMap<Object, Object> cm : usedClassMapSet) {
                this.collectUsedMappers(cm, parentMappers, new MapperKey(cm.getAType(), cm.getBType()));
            }
        }
    }

    private GeneratedMapperBase buildMapper(ClassMap<?, ?> classMap, boolean isAutoGenerated, MappingContext context) {
        this.register(classMap.getAType(), classMap.getBType(), isAutoGenerated);
        this.register(classMap.getBType(), classMap.getAType(), isAutoGenerated);
        MapperKey mapperKey = new MapperKey(classMap.getAType(), classMap.getBType());
        GeneratedMapperBase mapper = this.mapperGenerator.build(classMap, context);
        mapper.setMapperFacade(this.mapperFacade);
        mapper.setFromAutoMapping(isAutoGenerated);
        if (classMap.getCustomizedMapper() != null) {
            Mapper<Object, Object> customizedMapper = classMap.getCustomizedMapper();
            mapper.setCustomMapper(customizedMapper);
        }
        this.mappersRegistry.add(mapper);
        this.classMapRegistry.put(mapperKey, classMap);
        return mapper;
    }

    protected <S, D> void register(ma.glasnost.orika.metadata.Type<S> sourceType, ma.glasnost.orika.metadata.Type<D> destinationType, boolean isAutoGenerated) {
        Map<ma.glasnost.orika.metadata.Type<?>, Set<ma.glasnost.orika.metadata.Type<?>>> registry = isAutoGenerated ? this.dynamicAToBRegistry : this.explicitAToBRegistry;
        Set<ma.glasnost.orika.metadata.Type<?>> destinationSet = registry.get(sourceType);
        if (destinationSet == null) {
            destinationSet = new TreeSet();
            registry.put(sourceType, destinationSet);
        }
        destinationSet.add(destinationType);
    }

    @Override
    public <A, B> ClassMap<A, B> getClassMap(MapperKey mapperKey) {
        return this.classMapRegistry.get(mapperKey);
    }

    @Override
    public Set<ma.glasnost.orika.metadata.Type<? extends Object>> lookupMappedClasses(ma.glasnost.orika.metadata.Type<?> type) {
        TreeSet<ma.glasnost.orika.metadata.Type<? extends Object>> mappedClasses = new TreeSet<ma.glasnost.orika.metadata.Type<? extends Object>>();
        Set<ma.glasnost.orika.metadata.Type<?>> types = this.explicitAToBRegistry.get(type);
        if (types != null) {
            mappedClasses.addAll(types);
        }
        if ((types = this.dynamicAToBRegistry.get(type)) != null) {
            mappedClasses.addAll(types);
        }
        return mappedClasses;
    }

    @Override
    public ConverterFactory getConverterFactory() {
        return this.converterFactory;
    }

    @Override
    public <T> void registerObjectFactory(ObjectFactory<T> objectFactory, Class<T> targetClass) {
        this.registerObjectFactory((ObjectFactory<D>)objectFactory, (ma.glasnost.orika.metadata.Type)TypeFactory.valueOf(targetClass));
    }

    protected ClassMapBuilderFactory getClassMapBuilderFactory() {
        if (!this.classMapBuilderFactory.isInitialized()) {
            this.classMapBuilderFactory.setDefaultFieldMappers(this.defaultFieldMappers.toArray(new DefaultFieldMapper[this.defaultFieldMappers.size()]));
        }
        return this.classMapBuilderFactory;
    }

    @Override
    public <A, B> ClassMapBuilder<A, B> classMap(ma.glasnost.orika.metadata.Type<A> aType, ma.glasnost.orika.metadata.Type<B> bType) {
        ClassMapBuilderFactory classMapBuilderFactory = this.chainClassMapBuilderFactory.choiceClassMapBuilderFactory(aType, bType);
        if (classMapBuilderFactory != null) {
            return classMapBuilderFactory.map(aType, bType);
        }
        return this.getClassMapBuilderFactory().map(aType, bType);
    }

    @Override
    public <A, B> ClassMapBuilder<A, B> classMap(Class<A> aType, ma.glasnost.orika.metadata.Type<B> bType) {
        return this.classMap(TypeFactory.valueOf(aType), bType);
    }

    @Override
    public <A, B> ClassMapBuilder<A, B> classMap(ma.glasnost.orika.metadata.Type<A> aType, Class<B> bType) {
        return this.classMap(aType, TypeFactory.valueOf(bType));
    }

    @Override
    public <A, B> ClassMapBuilder<A, B> classMap(Class<A> aType, Class<B> bType) {
        return this.classMap(TypeFactory.valueOf(aType), TypeFactory.valueOf(bType));
    }

    @Override
    public synchronized <A, B> void registerMapper(Mapper<A, B> mapper) {
        this.mappersRegistry.add(mapper);
        mapper.setMapperFacade(this.mapperFacade);
        this.register(mapper.getAType(), mapper.getBType(), false);
        this.register(mapper.getBType(), mapper.getAType(), false);
    }

    public <S, D> BoundMapperFacade<S, D> getMapperFacade(ma.glasnost.orika.metadata.Type<S> sourceType, ma.glasnost.orika.metadata.Type<D> destinationType) {
        return this.getMapperFacade(sourceType, destinationType, true);
    }

    public <S, D> BoundMapperFacade<S, D> getMapperFacade(ma.glasnost.orika.metadata.Type<S> sourceType, ma.glasnost.orika.metadata.Type<D> destinationType, boolean containsCycles) {
        if (!this.isBuilt && !this.isBuilding) {
            this.build();
        }
        if (!containsCycles) {
            return new NonCyclicBoundMapperFacade(this, this.contextFactory, sourceType, destinationType);
        }
        return new DefaultBoundMapperFacade(this, this.contextFactory, sourceType, destinationType);
    }

    @Override
    public <A, B> BoundMapperFacade<A, B> getMapperFacade(Class<A> aType, Class<B> bType) {
        return this.getMapperFacade(aType, bType, true);
    }

    @Override
    public <A, B> BoundMapperFacade<A, B> getMapperFacade(Class<A> aType, Class<B> bType, boolean containsCycles) {
        return this.getMapperFacade((ma.glasnost.orika.metadata.Type)TypeFactory.valueOf(aType), (ma.glasnost.orika.metadata.Type)TypeFactory.valueOf(bType), containsCycles);
    }

    @Override
    public UnenhanceStrategy getUserUnenhanceStrategy() {
        return this.userUnenahanceStrategy;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Builder
    extends MapperFactoryBuilder<DefaultMapperFactory, Builder> {
        @Override
        public DefaultMapperFactory build() {
            return new DefaultMapperFactory(this);
        }

        @Override
        protected Builder self() {
            return this;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static abstract class MapperFactoryBuilder<F extends DefaultMapperFactory, B extends MapperFactoryBuilder<F, B>> {
        protected UnenhanceStrategy unenhanceStrategy;
        protected SuperTypeResolverStrategy superTypeStrategy;
        protected ConstructorResolverStrategy constructorResolverStrategy;
        protected CompilerStrategy compilerStrategy;
        protected Set<ClassMap<?, ?>> classMaps;
        protected ConverterFactory converterFactory;
        protected PropertyResolverStrategy propertyResolverStrategy;
        protected ClassMapBuilderFactory classMapBuilderFactory;
        protected CodeGenerationStrategy codeGenerationStrategy = new DefaultCodeGenerationStrategy();
        protected boolean useBuiltinConverters = true;
        protected boolean useAutoMapping = true;
        protected boolean mapNulls = true;

        public MapperFactoryBuilder() {
            this.converterFactory = UtilityResolver.getDefaultConverterFactory();
            this.constructorResolverStrategy = UtilityResolver.getDefaultConstructorResolverStrategy();
            this.compilerStrategy = UtilityResolver.getDefaultCompilerStrategy();
            this.propertyResolverStrategy = UtilityResolver.getDefaultPropertyResolverStrategy();
            this.classMapBuilderFactory = UtilityResolver.getDefaultClassMapBuilderFactory();
        }

        protected abstract B self();

        public B classMaps(Set<ClassMap<?, ?>> classMaps) {
            this.classMaps = classMaps;
            return this.self();
        }

        public B unenhanceStrategy(UnenhanceStrategy unenhanceStrategy) {
            this.unenhanceStrategy = unenhanceStrategy;
            return this.self();
        }

        public B superTypeResolverStrategy(SuperTypeResolverStrategy superTypeStrategy) {
            this.superTypeStrategy = superTypeStrategy;
            return this.self();
        }

        public B constructorResolverStrategy(ConstructorResolverStrategy constructorResolverStrategy) {
            this.constructorResolverStrategy = constructorResolverStrategy;
            return this.self();
        }

        public B converterFactory(ConverterFactory converterFactory) {
            this.converterFactory = converterFactory;
            return this.self();
        }

        public B compilerStrategy(CompilerStrategy compilerStrategy) {
            this.compilerStrategy = compilerStrategy;
            return this.self();
        }

        public B propertyResolverStrategy(PropertyResolverStrategy propertyResolverStrategy) {
            this.propertyResolverStrategy = propertyResolverStrategy;
            return this.self();
        }

        public B classMapBuilderFactory(ClassMapBuilderFactory classMapBuilderFactory) {
            this.classMapBuilderFactory = classMapBuilderFactory;
            return this.self();
        }

        public B useAutoMapping(boolean useAutoMapping) {
            this.useAutoMapping = useAutoMapping;
            return this.self();
        }

        public B useBuiltinConverters(boolean useBuiltinConverters) {
            this.useBuiltinConverters = useBuiltinConverters;
            return this.self();
        }

        @Deprecated
        public B usedBuiltinConverters(boolean useBuiltinConverters) {
            this.useBuiltinConverters = useBuiltinConverters;
            return this.self();
        }

        public B mapNulls(boolean mapNulls) {
            this.mapNulls = mapNulls;
            return this.self();
        }

        public CodeGenerationStrategy getCodeGenerationStrategy() {
            return this.codeGenerationStrategy;
        }

        public abstract F build();
    }
}

