/*
 * Decompiled with CFR 0.152.
 */
package ma.glasnost.orika.impl;

import java.util.Arrays;
import java.util.List;

public class ExceptionUtility {
    public static List<String> corePackages = Arrays.asList("java.", "javax.", "sun.", "sunw.", "com.sun.", "com.ibm.", "javassist.", "com.thoughtworks.paranamer.");

    public static boolean originatedByOrika(Throwable t) {
        for (StackTraceElement ste : t.getStackTrace()) {
            if (ExceptionUtility.isJreClass(ste.getClassName())) continue;
            return ExceptionUtility.isOrikaClass(ste.getClassName());
        }
        return false;
    }

    private static boolean isOrikaClass(String className) {
        return className.startsWith("ma.glasnost.orika.") && !className.startsWith("ma.glasnost.orika.test.");
    }

    private static boolean isJreClass(String className) {
        for (String pkg : corePackages) {
            if (!className.startsWith(pkg)) continue;
            return true;
        }
        return false;
    }
}

