/*
 * Decompiled with CFR 0.152.
 */
package ma.glasnost.orika.impl;

import com.googlecode.concurrentlinkedhashmap.ConcurrentLinkedHashMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import ma.glasnost.orika.Converter;
import ma.glasnost.orika.MapEntry;
import ma.glasnost.orika.Mapper;
import ma.glasnost.orika.MapperFacade;
import ma.glasnost.orika.MapperFactory;
import ma.glasnost.orika.MappingContext;
import ma.glasnost.orika.MappingContextFactory;
import ma.glasnost.orika.MappingException;
import ma.glasnost.orika.ObjectFactory;
import ma.glasnost.orika.converter.ConverterFactory;
import ma.glasnost.orika.impl.ExceptionUtility;
import ma.glasnost.orika.impl.ReversedMapper;
import ma.glasnost.orika.impl.mapping.strategy.MappingStrategy;
import ma.glasnost.orika.impl.mapping.strategy.MappingStrategyKey;
import ma.glasnost.orika.impl.mapping.strategy.MappingStrategyRecorder;
import ma.glasnost.orika.impl.util.ClassUtil;
import ma.glasnost.orika.metadata.MapperKey;
import ma.glasnost.orika.metadata.Type;
import ma.glasnost.orika.metadata.TypeFactory;
import ma.glasnost.orika.unenhance.UnenhanceStrategy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MapperFacadeImpl
implements MapperFacade {
    private final MapperFactory mapperFactory;
    private final MappingContextFactory contextFactory;
    private final UnenhanceStrategy unenhanceStrategy;
    private final UnenhanceStrategy userUnenhanceStrategy;
    private final Map<MappingStrategyKey, MappingStrategy> strategyCache = new ConcurrentLinkedHashMap.Builder().maximumWeightedCapacity(500).build();
    private final Logger log = LoggerFactory.getLogger(this.getClass());

    public MapperFacadeImpl(MapperFactory mapperFactory, MappingContextFactory contextFactory, UnenhanceStrategy unenhanceStrategy) {
        this.mapperFactory = mapperFactory;
        this.unenhanceStrategy = unenhanceStrategy;
        this.userUnenhanceStrategy = mapperFactory.getUserUnenhanceStrategy();
        this.contextFactory = contextFactory;
    }

    private <S, D> Type<S> normalizeSourceType(S sourceObject, Type<S> sourceType, Type<D> destinationType) {
        Type<S> resolvedType = null;
        if (sourceType != null) {
            if (destinationType != null && (this.canCopyByReference(destinationType, sourceType) || this.canConvert(sourceType, destinationType))) {
                resolvedType = sourceType;
            } else {
                if (sourceType.isAssignableFrom(sourceObject.getClass())) {
                    sourceType = TypeFactory.valueOf(sourceObject.getClass());
                }
                resolvedType = ClassUtil.isConcrete(sourceType) ? this.unenhanceStrategy.unenhanceType(sourceObject, sourceType) : this.unenhanceStrategy.unenhanceType(sourceObject, TypeFactory.resolveTypeOf(sourceObject, sourceType));
            }
        } else {
            resolvedType = this.unenhanceStrategy.unenhanceType(sourceObject, TypeFactory.typeOf(sourceObject));
        }
        return resolvedType;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <S, D> D map(S sourceObject, Type<S> sourceType, Type<D> destinationClass) {
        MappingContext context = this.contextFactory.getContext();
        try {
            D d = this.map(sourceObject, sourceType, destinationClass, context);
            return d;
        }
        finally {
            this.contextFactory.release(context);
        }
    }

    protected Class<?> getClass(Object object) {
        if (this.userUnenhanceStrategy == null) {
            return object.getClass();
        }
        return this.userUnenhanceStrategy.unenhanceObject(object, TypeFactory.TYPE_OF_OBJECT).getClass();
    }

    @Override
    public <S, D> MappingStrategy resolveMappingStrategy(S sourceObject, java.lang.reflect.Type initialSourceType, java.lang.reflect.Type initialDestinationType, boolean mapInPlace, MappingContext context) {
        MappingStrategyKey key = new MappingStrategyKey(this.getClass(sourceObject), initialSourceType, initialDestinationType, mapInPlace);
        MappingStrategy strategy = this.strategyCache.get(key);
        if (strategy == null) {
            Type<Object> sourceType = initialSourceType != null ? TypeFactory.valueOf(initialSourceType) : TypeFactory.typeOf(sourceObject);
            Type destinationType = TypeFactory.valueOf(initialDestinationType);
            MappingStrategyRecorder strategyRecorder = new MappingStrategyRecorder(key, this.unenhanceStrategy);
            Type<S> resolvedSourceType = this.normalizeSourceType(sourceObject, sourceType, destinationType);
            S resolvedSourceObject = mapInPlace ? sourceObject : this.unenhanceStrategy.unenhanceObject(sourceObject, sourceType);
            strategyRecorder.setResolvedSourceType(resolvedSourceType);
            strategyRecorder.setResolvedDestinationType(destinationType);
            if (sourceObject != resolvedSourceObject) {
                strategyRecorder.setUnenhance(true);
            }
            if (!mapInPlace && this.canCopyByReference(destinationType, resolvedSourceType)) {
                strategyRecorder.setCopyByReference(true);
            } else if (!mapInPlace && this.canConvert(resolvedSourceType, destinationType)) {
                strategyRecorder.setResolvedConverter(this.mapperFactory.getConverterFactory().getConverter(resolvedSourceType, destinationType));
            } else {
                Type resolvedDestinationType;
                if (mapInPlace) {
                    resolvedDestinationType = destinationType;
                } else {
                    strategyRecorder.setInstantiate(true);
                    resolvedDestinationType = this.mapperFactory.lookupConcreteDestinationType(resolvedSourceType, destinationType, context);
                    if (resolvedDestinationType == null) {
                        if (!ClassUtil.isConcrete(destinationType)) {
                            MappingException e = new MappingException("No concrete class mapping defined for source class " + resolvedSourceType.getName());
                            e.setDestinationType(destinationType);
                            e.setSourceType(resolvedSourceType);
                            throw e;
                        }
                        resolvedDestinationType = destinationType;
                    }
                }
                strategyRecorder.setResolvedDestinationType(resolvedDestinationType);
                strategyRecorder.setResolvedMapper(this.resolveMapper(resolvedSourceType, resolvedDestinationType));
                if (!mapInPlace) {
                    strategyRecorder.setResolvedObjectFactory(this.mapperFactory.lookupObjectFactory(resolvedDestinationType));
                }
            }
            strategy = strategyRecorder.playback();
            if (this.log.isDebugEnabled()) {
                this.log.debug(strategyRecorder.describeDetails());
            }
            this.strategyCache.put(key, strategy);
        }
        context.setResolvedSourceType(strategy.getSoureType());
        context.setResolvedDestinationType(strategy.getDestinationType());
        return strategy;
    }

    @Override
    public <S, D> D map(S sourceObject, Type<S> sourceType, Type<D> destinationType, MappingContext context) {
        try {
            if (destinationType == null) {
                throw new MappingException("Can not map to a null class.");
            }
            if (sourceObject == null) {
                return null;
            }
            Object existingResult = context.getMappedObject(sourceObject, destinationType);
            if (existingResult == null) {
                MappingStrategy strategy = this.resolveMappingStrategy(sourceObject, sourceType, destinationType, false, context);
                existingResult = strategy.map(sourceObject, null, context);
            }
            return existingResult;
        }
        catch (MappingException e) {
            throw e;
        }
        catch (RuntimeException e) {
            if (!ExceptionUtility.originatedByOrika(e)) {
                throw e;
            }
            throw new MappingException("Error encountered while mapping for the following inputs: \nrawSource=" + sourceObject + "\nsourceClass=" + (sourceObject != null ? sourceObject.getClass() : null) + "\nsourceType=" + sourceType + "\ndestinationType=" + destinationType, e);
        }
    }

    private <D, S> boolean canCopyByReference(Type<D> destinationType, Type<S> resolvedSourceType) {
        if (ClassUtil.isImmutable(resolvedSourceType) && resolvedSourceType.equals(destinationType)) {
            return true;
        }
        if (resolvedSourceType.isPrimitiveWrapper() && resolvedSourceType.getRawType().equals(ClassUtil.getWrapperType(destinationType.getRawType()))) {
            return true;
        }
        return resolvedSourceType.isPrimitive() && destinationType.getRawType().equals(ClassUtil.getWrapperType(resolvedSourceType.getRawType()));
    }

    @Override
    public <S, D> void map(S sourceObject, D destinationObject, Type<S> sourceType, Type<D> destinationType, MappingContext context) {
        try {
            if (context.getMappedObject(sourceObject, destinationType) == null) {
                MappingStrategy strategy = this.resolveMappingStrategy(sourceObject, sourceType, destinationType, true, context);
                strategy.map(sourceObject, destinationObject, context);
            }
        }
        catch (MappingException e) {
            throw e;
        }
        catch (RuntimeException e) {
            if (destinationObject == null) {
                throw new MappingException("[destinationObject] can not be null.");
            }
            if (destinationType == null) {
                throw new MappingException("[destinationType] can not be null.");
            }
            if (sourceObject == null) {
                throw new MappingException("[sourceObject] can not be null.");
            }
            if (!ExceptionUtility.originatedByOrika(e)) {
                throw e;
            }
            throw new MappingException("Error encountered while mapping for the following inputs: \nrawSource=" + sourceObject + "\nsourceClass=" + (sourceObject != null ? sourceObject.getClass() : null) + "\nsourceType=" + sourceType + "\nrawDestination=" + destinationObject + "\ndestinationClass=" + (destinationObject != null ? destinationObject.getClass() : null) + "\ndestinationType=" + destinationType, e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <S, D> void map(S sourceObject, D destinationObject, Type<S> sourceType, Type<D> destinationType) {
        MappingContext context = this.contextFactory.getContext();
        try {
            this.map(sourceObject, destinationObject, sourceType, destinationType, context);
        }
        finally {
            this.contextFactory.release(context);
        }
    }

    @Override
    public <S, D> void map(S sourceObject, D destinationObject, MappingContext context) {
        try {
            if (destinationObject == null) {
                throw new MappingException("[destinationObject] can not be null.");
            }
            if (sourceObject == null) {
                throw new MappingException("[sourceObject] can not be null.");
            }
            if (context.getMappedObject(sourceObject, destinationObject.getClass()) == null) {
                MappingStrategy strategy = this.resolveMappingStrategy(sourceObject, null, destinationObject.getClass(), true, context);
                strategy.map(sourceObject, destinationObject, context);
            }
        }
        catch (MappingException e) {
            throw e;
        }
        catch (RuntimeException e) {
            if (!ExceptionUtility.originatedByOrika(e)) {
                throw e;
            }
            throw new MappingException("Error encountered while mapping for the following inputs: \nrawSource=" + sourceObject + "\nsourceClass=" + (sourceObject != null ? sourceObject.getClass() : null) + "\nrawDestination=" + destinationObject + "\ndestinationClass=" + (destinationObject != null ? destinationObject.getClass() : null), e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <S, D> void map(S sourceObject, D destinationObject) {
        MappingContext context = this.contextFactory.getContext();
        try {
            this.map(sourceObject, destinationObject, context);
        }
        finally {
            this.contextFactory.release(context);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final <S, D> Set<D> mapAsSet(Iterable<S> source, Type<S> sourceType, Type<D> destinationType) {
        MappingContext context = this.contextFactory.getContext();
        try {
            Set<D> set = this.mapAsSet(source, sourceType, destinationType, context);
            return set;
        }
        finally {
            this.contextFactory.release(context);
        }
    }

    @Override
    public final <S, D> Set<D> mapAsSet(Iterable<S> source, Type<S> sourceType, Type<D> destinationType, MappingContext context) {
        return (Set)this.mapAsCollection(source, sourceType, destinationType, new HashSet(), context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final <S, D> List<D> mapAsList(Iterable<S> source, Type<S> sourceType, Type<D> destinationType) {
        MappingContext context = this.contextFactory.getContext();
        try {
            List list = (List)this.mapAsCollection(source, sourceType, destinationType, new ArrayList(), context);
            return list;
        }
        finally {
            this.contextFactory.release(context);
        }
    }

    @Override
    public final <S, D> List<D> mapAsList(Iterable<S> source, Type<S> sourceType, Type<D> destinationType, MappingContext context) {
        return (List)this.mapAsCollection(source, sourceType, destinationType, new ArrayList(), context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <S, D> D[] mapAsArray(D[] destination, Iterable<S> source, Type<S> sourceType, Type<D> destinationType) {
        MappingContext context = this.contextFactory.getContext();
        try {
            D[] DArray = this.mapAsArray(destination, source, sourceType, destinationType, context);
            return DArray;
        }
        finally {
            this.contextFactory.release(context);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <S, D> D[] mapAsArray(D[] destination, S[] source, Type<S> sourceType, Type<D> destinationType) {
        MappingContext context = this.contextFactory.getContext();
        try {
            D[] DArray = this.mapAsArray(destination, source, sourceType, destinationType, context);
            return DArray;
        }
        finally {
            this.contextFactory.release(context);
        }
    }

    @Override
    public <S, D> D[] mapAsArray(D[] destination, Iterable<S> source, Type<S> sourceType, Type<D> destinationType, MappingContext context) {
        if (source == null) {
            return null;
        }
        int i = 0;
        for (S s : source) {
            destination[i++] = this.map(s, sourceType, destinationType);
        }
        return destination;
    }

    @Override
    public <S, D> D[] mapAsArray(D[] destination, S[] source, Type<S> sourceType, Type<D> destinationType, MappingContext context) {
        if (source == null) {
            return null;
        }
        int i = 0;
        for (S s : source) {
            destination[i++] = this.map(s, sourceType, destinationType, context);
        }
        return destination;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <S, D> List<D> mapAsList(S[] source, Type<S> sourceType, Type<D> destinationType) {
        MappingContext context = this.contextFactory.getContext();
        try {
            List<D> list = this.mapAsList(source, sourceType, destinationType, context);
            return list;
        }
        finally {
            this.contextFactory.release(context);
        }
    }

    @Override
    public <S, D> List<D> mapAsList(S[] source, Type<S> sourceType, Type<D> destinationType, MappingContext context) {
        ArrayList<D> destination = new ArrayList<D>(source.length);
        for (S s : source) {
            destination.add(this.map(s, sourceType, destinationType, context));
        }
        return destination;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <S, D> Set<D> mapAsSet(S[] source, Type<S> sourceType, Type<D> destinationType) {
        MappingContext context = this.contextFactory.getContext();
        try {
            Set<D> set = this.mapAsSet(source, sourceType, destinationType, context);
            return set;
        }
        finally {
            this.contextFactory.release(context);
        }
    }

    @Override
    public <S, D> Set<D> mapAsSet(S[] source, Type<S> sourceType, Type<D> destinationType, MappingContext context) {
        HashSet<D> destination = new HashSet<D>(source.length);
        for (S s : source) {
            destination.add(this.map(s, sourceType, destinationType, context));
        }
        return destination;
    }

    @Override
    public <S, D> void mapAsCollection(Iterable<S> source, Collection<D> destination, Type<S> sourceType, Type<D> destinationType, MappingContext context) {
        if (source == null) {
            return;
        }
        if (destination != null) {
            destination.clear();
            for (S item : source) {
                destination.add(this.map(item, sourceType, destinationType, context));
            }
        }
    }

    @Override
    public <S, D> void mapAsCollection(S[] source, Collection<D> destination, Type<S> sourceType, Type<D> destinationType, MappingContext context) {
        if (source == null) {
            return;
        }
        if (destination != null) {
            destination.clear();
            for (S item : source) {
                destination.add(this.map(item, sourceType, destinationType, context));
            }
        }
    }

    Mapper<Object, Object> resolveMapper(Type<?> sourceType, Type<?> destinationType) {
        MapperKey mapperKey = new MapperKey(sourceType, destinationType);
        Mapper<Object, Object> mapper = this.mapperFactory.lookupMapper(mapperKey);
        if (mapper == null) {
            throw new IllegalStateException(String.format("Cannot create a mapper for classes : %s, %s", destinationType, sourceType));
        }
        if (!mapper.getAType().equals(sourceType) && mapper.getAType().equals(destinationType) || !mapper.getAType().isAssignableFrom(sourceType) && mapper.getAType().isAssignableFrom(destinationType)) {
            mapper = ReversedMapper.reverse(mapper);
        }
        return mapper;
    }

    void mapDeclaredProperties(Object sourceObject, Object destinationObject, Type<?> sourceType, Type<?> destinationType, MappingContext context, Mapper<Object, Object> mapper, MappingStrategyRecorder strategyBuilder) {
        if (mapper.getAType().equals(sourceType)) {
            mapper.mapAtoB(sourceObject, destinationObject, context);
        } else if (mapper.getAType().equals(destinationType)) {
            mapper.mapBtoA(sourceObject, destinationObject, context);
            if (strategyBuilder != null) {
                strategyBuilder.setMapReverse(true);
            }
        } else if (mapper.getAType().isAssignableFrom(sourceType)) {
            mapper.mapAtoB(sourceObject, destinationObject, context);
        } else if (mapper.getAType().isAssignableFrom(destinationType)) {
            mapper.mapBtoA(sourceObject, destinationObject, context);
            if (strategyBuilder != null) {
                strategyBuilder.setMapReverse(true);
            }
        } else {
            throw new IllegalStateException(String.format("Source object type's must be one of '%s' or '%s'.", mapper.getAType(), mapper.getBType()));
        }
    }

    private <S, D> D newObject(S sourceObject, Type<? extends D> destinationType, MappingContext context, MappingStrategyRecorder strategyBuilder) {
        ObjectFactory<D> objectFactory = this.mapperFactory.lookupObjectFactory(destinationType);
        if (strategyBuilder != null) {
            strategyBuilder.setResolvedObjectFactory(objectFactory);
        }
        return objectFactory.create(sourceObject, context);
    }

    @Override
    public <S, D> D newObject(S sourceObject, Type<? extends D> destinationType, MappingContext context) {
        return this.newObject(sourceObject, destinationType, context, null);
    }

    <S, D> Collection<D> mapAsCollection(Iterable<S> source, Type<S> sourceType, Type<D> destinationType, Collection<D> destination, MappingContext context) {
        if (source == null) {
            return null;
        }
        MappingStrategy strategy = null;
        Class<?> sourceClass = null;
        for (S item : source) {
            Object mappedItem;
            if (item == null) continue;
            if (strategy == null || !item.getClass().equals(sourceClass)) {
                strategy = this.resolveMappingStrategy(item, sourceType, destinationType, false, context);
                sourceClass = item.getClass();
            }
            if ((mappedItem = context.getMappedObject(item, destinationType)) == null) {
                mappedItem = strategy.map(item, null, context);
            }
            destination.add(mappedItem);
        }
        return destination;
    }

    @Override
    public <S, D> D convert(S source, Type<S> sourceType, Type<D> destinationType, String converterId) {
        Converter<Object, Object> converter;
        ConverterFactory converterFactory = this.mapperFactory.getConverterFactory();
        if (converterId == null) {
            Type<S> sourceClass = this.normalizeSourceType(source, sourceType, destinationType);
            converter = converterFactory.getConverter(sourceClass, destinationType);
        } else {
            converter = converterFactory.getConverter(converterId);
        }
        return (D)converter.convert(source, destinationType);
    }

    private <S, D> boolean canConvert(Type<S> sourceType, Type<D> destinationType) {
        return this.mapperFactory.getConverterFactory().canConvert(sourceType, destinationType);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <S, D> D map(S sourceObject, Class<D> destinationClass) {
        MappingContext context = this.contextFactory.getContext();
        try {
            D d = this.map(sourceObject, destinationClass, context);
            return d;
        }
        finally {
            this.contextFactory.release(context);
        }
    }

    @Override
    public <S, D> D map(S sourceObject, Class<D> destinationClass, MappingContext context) {
        try {
            if (destinationClass == null) {
                throw new MappingException("Can not map to a null class.");
            }
            if (sourceObject == null) {
                return null;
            }
            Object result = context.getMappedObject(sourceObject, destinationClass);
            if (result == null) {
                MappingStrategy strategy = this.resolveMappingStrategy(sourceObject, null, destinationClass, false, context);
                result = strategy.map(sourceObject, null, context);
            }
            return result;
        }
        catch (MappingException e) {
            throw e;
        }
        catch (RuntimeException e) {
            if (!ExceptionUtility.originatedByOrika(e)) {
                throw e;
            }
            throw new MappingException("Error encountered while mapping for the following inputs: \nrawSource=" + sourceObject + "\nsourceClass=" + (sourceObject != null ? sourceObject.getClass() : null) + "\ndestinationClass=" + destinationClass, e);
        }
    }

    @Override
    public <S, D> Set<D> mapAsSet(Iterable<S> source, Class<D> destinationClass) {
        return this.mapAsSet(source, TypeFactory.elementTypeOf(source), TypeFactory.valueOf(destinationClass));
    }

    @Override
    public <S, D> Set<D> mapAsSet(Iterable<S> source, Class<D> destinationClass, MappingContext context) {
        return this.mapAsSet(source, TypeFactory.elementTypeOf(source), TypeFactory.valueOf(destinationClass), context);
    }

    @Override
    public <S, D> Set<D> mapAsSet(S[] source, Class<D> destinationClass) {
        return this.mapAsSet(source, TypeFactory.componentTypeOf(source), TypeFactory.valueOf(destinationClass));
    }

    @Override
    public <S, D> Set<D> mapAsSet(S[] source, Class<D> destinationClass, MappingContext context) {
        return this.mapAsSet(source, TypeFactory.componentTypeOf(source), TypeFactory.valueOf(destinationClass), context);
    }

    @Override
    public <S, D> List<D> mapAsList(Iterable<S> source, Class<D> destinationClass) {
        return this.mapAsList(source, TypeFactory.elementTypeOf(source), TypeFactory.valueOf(destinationClass));
    }

    @Override
    public <S, D> List<D> mapAsList(Iterable<S> source, Class<D> destinationClass, MappingContext context) {
        return this.mapAsList(source, TypeFactory.elementTypeOf(source), TypeFactory.valueOf(destinationClass), context);
    }

    @Override
    public <S, D> List<D> mapAsList(S[] source, Class<D> destinationClass) {
        return this.mapAsList(source, TypeFactory.componentTypeOf(source), TypeFactory.valueOf(destinationClass));
    }

    @Override
    public <S, D> List<D> mapAsList(S[] source, Class<D> destinationClass, MappingContext context) {
        return this.mapAsList(source, TypeFactory.componentTypeOf(source), TypeFactory.valueOf(destinationClass), context);
    }

    @Override
    public <S, D> D[] mapAsArray(D[] destination, Iterable<S> source, Class<D> destinationClass) {
        return this.mapAsArray(destination, source, TypeFactory.elementTypeOf(source), TypeFactory.valueOf(destinationClass));
    }

    @Override
    public <S, D> D[] mapAsArray(D[] destination, S[] source, Class<D> destinationClass) {
        return this.mapAsArray(destination, source, TypeFactory.componentTypeOf(source), TypeFactory.valueOf(destinationClass));
    }

    @Override
    public <S, D> D[] mapAsArray(D[] destination, Iterable<S> source, Class<D> destinationClass, MappingContext context) {
        return this.mapAsArray(destination, source, TypeFactory.elementTypeOf(source), TypeFactory.valueOf(destinationClass), context);
    }

    @Override
    public <S, D> D[] mapAsArray(D[] destination, S[] source, Class<D> destinationClass, MappingContext context) {
        return this.mapAsArray(destination, source, TypeFactory.componentTypeOf(source), TypeFactory.valueOf(destinationClass), context);
    }

    @Override
    public <S, D> D convert(S source, Class<D> destinationClass, String converterId) {
        return this.convert(source, TypeFactory.typeOf(source), TypeFactory.valueOf(destinationClass), converterId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <Sk, Sv, Dk, Dv> Map<Dk, Dv> mapAsMap(Map<Sk, Sv> source, Type<? extends Map<Sk, Sv>> sourceType, Type<? extends Map<Dk, Dv>> destinationType) {
        MappingContext context = this.contextFactory.getContext();
        try {
            Map<Dk, Dv> map = this.mapAsMap(source, sourceType, destinationType, context);
            return map;
        }
        finally {
            this.contextFactory.release(context);
        }
    }

    @Override
    public <Sk, Sv, Dk, Dv> Map<Dk, Dv> mapAsMap(Map<Sk, Sv> source, Type<? extends Map<Sk, Sv>> sourceType, Type<? extends Map<Dk, Dv>> destinationType, MappingContext context) {
        HashMap<Object, Object> destination = new HashMap<Object, Object>(source.size());
        MappingStrategy keyStrategy = null;
        MappingStrategy valueStrategy = null;
        Class<?> keyClass = null;
        Class<?> valueClass = null;
        for (Map.Entry<Sk, Sv> entry : source.entrySet()) {
            Object value;
            Object key;
            if (entry.getKey() == null) {
                key = null;
            } else {
                Object mappedKey;
                if (keyStrategy == null || !entry.getKey().getClass().equals(keyClass)) {
                    keyStrategy = this.resolveMappingStrategy(entry.getKey(), sourceType.getNestedType(0), destinationType.getNestedType(0), false, context);
                    keyClass = entry.getKey().getClass();
                }
                if ((mappedKey = context.getMappedObject(entry.getKey(), destinationType.getNestedType(0))) == null) {
                    mappedKey = keyStrategy.map(entry.getKey(), null, context);
                }
                key = mappedKey;
            }
            if (entry.getValue() == null) {
                value = null;
            } else {
                Object mappedValue;
                if (valueStrategy == null || !entry.getValue().getClass().equals(valueClass)) {
                    valueStrategy = this.resolveMappingStrategy(entry.getValue(), sourceType.getNestedType(1), destinationType.getNestedType(1), false, context);
                    valueClass = entry.getValue().getClass();
                }
                if ((mappedValue = context.getMappedObject(entry.getValue(), destinationType.getNestedType(1))) == null) {
                    mappedValue = valueStrategy.map(entry.getValue(), null, context);
                }
                value = mappedValue;
            }
            destination.put(key, value);
        }
        return destination;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <S, Dk, Dv> Map<Dk, Dv> mapAsMap(Iterable<S> source, Type<S> sourceType, Type<? extends Map<Dk, Dv>> destinationType) {
        MappingContext context = this.contextFactory.getContext();
        try {
            Map<Dk, Dv> map = this.mapAsMap(source, sourceType, destinationType, context);
            return map;
        }
        finally {
            this.contextFactory.release(context);
        }
    }

    @Override
    public <S, Dk, Dv> Map<Dk, Dv> mapAsMap(Iterable<S> source, Type<S> sourceType, Type<? extends Map<Dk, Dv>> destinationType, MappingContext context) {
        HashMap destination = new HashMap();
        MappingStrategy strategy = null;
        Class<?> entryClass = null;
        Type<Map.Entry> entryType = TypeFactory.valueOf(Map.Entry.class, destinationType.getNestedType(0), destinationType.getNestedType(1));
        for (S element : source) {
            Map.Entry entry;
            if (strategy == null || !element.getClass().equals(entryClass)) {
                strategy = this.resolveMappingStrategy(element, sourceType, entryType, false, context);
                entryClass = element.getClass();
            }
            if ((entry = (Map.Entry)context.getMappedObject(element, entryType)) == null) {
                entry = (Map.Entry)strategy.map(element, null, context);
            }
            destination.put(entry.getKey(), entry.getValue());
        }
        return destination;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <S, Dk, Dv> Map<Dk, Dv> mapAsMap(S[] source, Type<S> sourceType, Type<? extends Map<Dk, Dv>> destinationType) {
        MappingContext context = this.contextFactory.getContext();
        try {
            Map<Dk, Dv> map = this.mapAsMap(source, sourceType, destinationType, context);
            return map;
        }
        finally {
            this.contextFactory.release(context);
        }
    }

    @Override
    public <S, Dk, Dv> Map<Dk, Dv> mapAsMap(S[] source, Type<S> sourceType, Type<? extends Map<Dk, Dv>> destinationType, MappingContext context) {
        HashMap destination = new HashMap();
        Type entryType = MapEntry.concreteEntryType(destinationType);
        MappingStrategy strategy = null;
        Class<?> entryClass = null;
        for (S element : source) {
            MapEntry entry;
            if (strategy == null || !element.getClass().equals(entryClass)) {
                strategy = this.resolveMappingStrategy(element, sourceType, entryType, false, context);
                entryClass = element.getClass();
            }
            if ((entry = (MapEntry)context.getMappedObject(element, entryType)) == null) {
                entry = (MapEntry)strategy.map(element, null, context);
            }
            destination.put(entry.getKey(), entry.getValue());
        }
        return destination;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <Sk, Sv, D> List<D> mapAsList(Map<Sk, Sv> source, Type<? extends Map<Sk, Sv>> sourceType, Type<D> destinationType) {
        MappingContext context = this.contextFactory.getContext();
        try {
            List<D> list = this.mapAsList(source, sourceType, destinationType, context);
            return list;
        }
        finally {
            this.contextFactory.release(context);
        }
    }

    @Override
    public <Sk, Sv, D> List<D> mapAsList(Map<Sk, Sv> source, Type<? extends Map<Sk, Sv>> sourceType, Type<D> destinationType, MappingContext context) {
        ArrayList destination = new ArrayList(source.size());
        Type entryType = MapEntry.concreteEntryType(sourceType);
        return (List)this.mapAsCollection(MapEntry.entrySet(source), entryType, destinationType, destination, context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <Sk, Sv, D> Set<D> mapAsSet(Map<Sk, Sv> source, Type<? extends Map<Sk, Sv>> sourceType, Type<D> destinationType) {
        MappingContext context = this.contextFactory.getContext();
        try {
            Set<D> set = this.mapAsSet(source, sourceType, destinationType, context);
            return set;
        }
        finally {
            this.contextFactory.release(context);
        }
    }

    @Override
    public <Sk, Sv, D> Set<D> mapAsSet(Map<Sk, Sv> source, Type<? extends Map<Sk, Sv>> sourceType, Type<D> destinationType, MappingContext context) {
        HashSet destination = new HashSet(source.size());
        Type entryType = TypeFactory.resolveTypeOf(source.entrySet(), sourceType).getNestedType(0);
        return (Set)this.mapAsCollection(source.entrySet(), entryType, destinationType, destination, context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <Sk, Sv, D> D[] mapAsArray(D[] destination, Map<Sk, Sv> source, Type<? extends Map<Sk, Sv>> sourceType, Type<D> destinationType) {
        MappingContext context = this.contextFactory.getContext();
        try {
            D[] DArray = this.mapAsArray(destination, source, sourceType, destinationType, context);
            return DArray;
        }
        finally {
            this.contextFactory.release(context);
        }
    }

    @Override
    public <Sk, Sv, D> D[] mapAsArray(D[] destination, Map<Sk, Sv> source, Type<? extends Map<Sk, Sv>> sourceType, Type<D> destinationType, MappingContext context) {
        Type entryType = MapEntry.concreteEntryType(sourceType);
        return this.mapAsArray(destination, MapEntry.entrySet(source), entryType, destinationType, context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <S, D> void mapAsCollection(Iterable<S> source, Collection<D> destination, Class<D> destinationClass) {
        MappingContext context = this.contextFactory.getContext();
        try {
            this.mapAsCollection(source, destination, destinationClass, context);
        }
        finally {
            this.contextFactory.release(context);
        }
    }

    @Override
    public <S, D> void mapAsCollection(Iterable<S> source, Collection<D> destination, Class<D> destinationClass, MappingContext context) {
        this.mapAsCollection(source, destination, null, TypeFactory.valueOf(destinationClass), context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <S, D> void mapAsCollection(S[] source, Collection<D> destination, Class<D> destinationClass) {
        MappingContext context = this.contextFactory.getContext();
        try {
            this.mapAsCollection(source, destination, destinationClass, context);
        }
        finally {
            this.contextFactory.release(context);
        }
    }

    @Override
    public <S, D> void mapAsCollection(S[] source, Collection<D> destination, Class<D> destinationClass, MappingContext context) {
        this.mapAsCollection(source, destination, TypeFactory.valueOf(source.getClass().getComponentType()), TypeFactory.valueOf(destinationClass), context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <S, D> void mapAsCollection(Iterable<S> source, Collection<D> destination, Type<S> sourceType, Type<D> destinationType) {
        MappingContext context = this.contextFactory.getContext();
        try {
            this.mapAsCollection(source, destination, sourceType, destinationType, context);
        }
        finally {
            this.contextFactory.release(context);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <S, D> void mapAsCollection(S[] source, Collection<D> destination, Type<S> sourceType, Type<D> destinationType) {
        MappingContext context = this.contextFactory.getContext();
        try {
            this.mapAsCollection(source, destination, sourceType, destinationType, context);
        }
        finally {
            this.contextFactory.release(context);
        }
    }
}

