/*
 * Decompiled with CFR 0.152.
 */
package ma.glasnost.orika.impl;

import ma.glasnost.orika.constructor.ConstructorResolverStrategy;
import ma.glasnost.orika.constructor.SimpleConstructorResolverStrategy;
import ma.glasnost.orika.converter.ConverterFactory;
import ma.glasnost.orika.converter.DefaultConverterFactory;
import ma.glasnost.orika.impl.generator.CompilerStrategy;
import ma.glasnost.orika.impl.generator.JavassistCompilerStrategy;
import ma.glasnost.orika.metadata.ClassMapBuilder;
import ma.glasnost.orika.metadata.ClassMapBuilderFactory;
import ma.glasnost.orika.property.IntrospectorPropertyResolver;
import ma.glasnost.orika.property.PropertyResolverStrategy;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class UtilityResolver {
    public static CompilerStrategy getDefaultCompilerStrategy() {
        return UtilityResolver.resolveUtility("ma.glasnost.orika.compilerStrategy", JavassistCompilerStrategy.class);
    }

    public static ConverterFactory getDefaultConverterFactory() {
        return UtilityResolver.resolveUtility("ma.glasnost.orika.converterFactory", DefaultConverterFactory.class);
    }

    public static ConstructorResolverStrategy getDefaultConstructorResolverStrategy() {
        return UtilityResolver.resolveUtility("ma.glasnost.orika.constructorResolverStrategy", SimpleConstructorResolverStrategy.class);
    }

    public static PropertyResolverStrategy getDefaultPropertyResolverStrategy() {
        return UtilityResolver.resolveUtility("ma.glasnost.orika.propertyResolverStrategy", IntrospectorPropertyResolver.class);
    }

    public static ClassMapBuilderFactory getDefaultClassMapBuilderFactory() {
        return UtilityResolver.resolveUtility("ma.glasnost.orika.classMapBuilderFactory", ClassMapBuilder.Factory.class);
    }

    private static <U> U resolveUtility(String systemProperty, Class<? extends U> defaultImplementation) {
        U utility = null;
        String utilityClassName = System.getProperty(systemProperty);
        if (utilityClassName != null) {
            try {
                Class<?> utilityClass = Class.forName(utilityClassName, true, Thread.currentThread().getContextClassLoader());
                utility = (U)utilityClass.newInstance();
            }
            catch (Exception e) {
                throw new IllegalArgumentException("utility implementation specified for " + systemProperty + " was invalid", e);
            }
        }
        try {
            utility = defaultImplementation.newInstance();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return utility;
    }
}

