/*
 * Decompiled with CFR 0.152.
 */
package ma.glasnost.orika.impl.generator;

import java.io.File;
import java.io.IOException;
import ma.glasnost.orika.impl.generator.SourceCodeContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class CompilerStrategy {
    protected final boolean writeSourceFiles;
    protected final boolean writeClassFiles;
    protected final String pathToWriteSourceFiles;
    protected final String pathToWriteClassFiles;
    protected static final String WRITE_RELATIVE_TO_CLASSPATH = "classpath:";

    public abstract Class<?> compileClass(SourceCodeContext var1) throws SourceCodeGenerationException;

    public abstract void assureTypeIsAccessible(Class<?> var1) throws SourceCodeGenerationException;

    protected CompilerStrategy(String writeSourceByDefault, String writeClassByDefault) {
        this.writeSourceFiles = Boolean.valueOf(System.getProperty("ma.glasnost.orika.writeSourceFiles", System.getProperty("ma.glasnost.orika.GeneratedSourceCode.writeSourceFiles", writeSourceByDefault)));
        this.writeClassFiles = Boolean.valueOf(System.getProperty("ma.glasnost.orika.writeClassFiles", System.getProperty("ma.glasnost.orika.GeneratedSourceCode.writeClassFiles", writeClassByDefault)));
        this.pathToWriteSourceFiles = System.getProperty("ma.glasnost.orika.writeSourceFilesToPath", "classpath:/");
        this.pathToWriteClassFiles = System.getProperty("ma.glasnost.orika.writeClassFilesToPath", "classpath:/");
    }

    protected File preparePackageOutputPath(String basePath, String packageName) throws IOException {
        String packagePath = packageName.replaceAll("\\.", "/");
        String path = null;
        if (basePath.startsWith(WRITE_RELATIVE_TO_CLASSPATH)) {
            path = this.getClass().getResource(basePath.substring(WRITE_RELATIVE_TO_CLASSPATH.length())).getFile().toString();
        } else {
            path = basePath;
            if (!path.endsWith("/")) {
                path = path + "/";
            }
        }
        File parentDir = new File(path + packagePath);
        if (!parentDir.exists() && !parentDir.mkdirs()) {
            throw new IOException("Could not create package directory for " + packageName);
        }
        return parentDir;
    }

    public static class SourceCodeGenerationException
    extends Exception {
        private static final long serialVersionUID = 1L;

        public SourceCodeGenerationException(String message, Throwable cause) {
            super(message, cause);
        }

        public SourceCodeGenerationException(Throwable cause) {
            super(cause);
        }

        public SourceCodeGenerationException(String message) {
            super(message);
        }
    }
}

