/*
 * Decompiled with CFR 0.152.
 */
package ma.glasnost.orika.impl.generator;

import java.util.Set;
import ma.glasnost.orika.MapEntry;
import ma.glasnost.orika.impl.generator.VariableRef;
import ma.glasnost.orika.impl.util.ClassUtil;
import ma.glasnost.orika.metadata.Property;
import ma.glasnost.orika.metadata.Type;
import ma.glasnost.orika.metadata.TypeFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MultiOccurrenceVariableRef
extends VariableRef {
    private String iteratorName;
    private boolean iteratorDeclared;

    public static MultiOccurrenceVariableRef from(VariableRef r) {
        if (r.property() != null) {
            return new MultiOccurrenceVariableRef(r.property(), r.name);
        }
        return new MultiOccurrenceVariableRef(r.type(), r.name);
    }

    public MultiOccurrenceVariableRef(Property property, String name) {
        super(property, name);
    }

    public MultiOccurrenceVariableRef(Property property, MultiOccurrenceVariableRef anchor) {
        super(property, anchor);
    }

    public MultiOccurrenceVariableRef(Type<?> type, String name) {
        super(type, name);
    }

    private String getIteratorName() {
        if (this.iteratorName == null) {
            String prefix = this.name();
            if (this.property() != null && this.property().getName().matches("[\\w$]+")) {
                prefix = this.property().getName();
            }
            if ("".equals(prefix) && !"".equals(this.name)) {
                prefix = this.name;
            }
            this.iteratorName = this.isArray() ? prefix + "_$_index" : prefix + "_$_iter";
        }
        return this.iteratorName;
    }

    public String declareIteratorIfNotDeclared() {
        if (!this.iteratorDeclared) {
            return this.declareIterator();
        }
        return "";
    }

    public String declareIterator() {
        if (this.iteratorDeclared) {
            throw new IllegalStateException("Iterator has already been declared");
        }
        String iterator = this.isArray() ? "int " + this.getIteratorName() + " = -1" : (this.isMap() ? new EntrySetRef(this, this.name()).declareIterator() : "java.util.Iterator " + this.getIteratorName() + " = " + this.getter() + ".iterator()");
        this.iteratorDeclared = true;
        return iterator;
    }

    public String nextElement() {
        if (!this.iteratorDeclared) {
            throw new IllegalStateException("Iterator has not been declared");
        }
        String next = this.isArray() ? this.getter() + "[++" + this.getIteratorName() + "]" : this.getIteratorName() + ".next()";
        return next;
    }

    public String iteratorHasNext() {
        if (!this.iteratorDeclared) {
            throw new IllegalStateException("Iterator has not been declared");
        }
        String hasNext = this.isArray() ? this.getIteratorName() + " < (" + this.getter() + ".length - 1)" : this.getIteratorName() + ".hasNext()";
        return hasNext;
    }

    public String notEmpty() {
        if (this.isArray()) {
            return this.getter() + ".length > 0";
        }
        return "!" + this.getter() + ".isEmpty()";
    }

    public String addAll(VariableRef value) {
        if (this.isArray() && value.isCollection()) {
            if (this.type().getComponentType().isPrimitive()) {
                return this.assign("%sArray(%s)", this.type().getComponentType().getCanonicalName(), value);
            }
            return this.assign("listToArray(%s, %s.class)", value, this.type().getCanonicalName());
        }
        if (this.isMap() && value.isList()) {
            return this.assign("listToMap(%s, java.util.LinkedHashMap.class)", value);
        }
        if (this.isCollection() && value.isArray()) {
            if (value.type().getComponentType().isPrimitive()) {
                return this.getter() + ".addAll(asList(" + value + "))";
            }
            return this.getter() + ".addAll(java.util.Arrays.asList(" + value + ")";
        }
        if (this.isMap() && value.isMap()) {
            return this.getter() + ".putAll(" + value + ")";
        }
        return this.getter() + ".addAll(" + value + ")";
    }

    public String add(VariableRef value) {
        if (this.isArray()) {
            if (!this.iteratorDeclared) {
                throw new IllegalStateException("Iterator must be declared in order to add elements to destination array");
            }
            return this.getter() + "[++" + this.getIteratorName() + "] = " + value;
        }
        if (this.isMap() && value.isMapEntry()) {
            return this.getter() + ".put(" + value + ".getKey(), " + value + ".getValue())";
        }
        if (this.isCollection()) {
            return this.getter() + ".add(" + MultiOccurrenceVariableRef.cast(value, this.type().getNestedType(0)) + ")";
        }
        throw new IllegalArgumentException(this.type() + " does not support adding elements of type " + value.type());
    }

    public String add(String value) {
        if (this.isArray()) {
            if (!this.iteratorDeclared) {
                throw new IllegalStateException("Iterator must be declared in order to add elements to destination array");
            }
            return this.getter() + "[++" + this.getIteratorName() + "] = " + value;
        }
        if (this.isMap()) {
            return this.getter() + ".put(" + value + ".getKey(), " + value + ".getValue())";
        }
        if (this.isCollection()) {
            return this.getter() + ".add(" + MultiOccurrenceVariableRef.cast(value, this.type().getNestedType(0)) + ")";
        }
        throw new IllegalArgumentException(this.type() + " does not support adding of elements");
    }

    public String collectionType() {
        String collection;
        if (this.isList()) {
            collection = "List";
        } else if (this.isSet()) {
            collection = "Set";
        } else if (this.isCollection()) {
            collection = "List";
        } else {
            throw new IllegalStateException(this.type() + " is not a collection type");
        }
        return collection;
    }

    public String newCollection() {
        return this.newInstance("");
    }

    public String newInstance(String sizeExpr) {
        if (this.isArray()) {
            return "new " + this.rawType().getComponentType().getCanonicalName() + "[" + sizeExpr + "]";
        }
        if (this.isMap()) {
            return "new java.util.LinkedHashMap(" + sizeExpr + ")";
        }
        if ("Set".equals(this.collectionType())) {
            if (ClassUtil.isConcrete(this.type())) {
                try {
                    if (((Class)this.type().getRawType()).getConstructor(new Class[0]) != null) {
                        return "new " + this.type().getCanonicalName() + "()";
                    }
                }
                catch (NoSuchMethodException e) {
                }
                catch (SecurityException e) {
                    // empty catch block
                }
            }
            return "new java.util.LinkedHashSet(" + sizeExpr + ")";
        }
        if (ClassUtil.isConcrete(this.type())) {
            try {
                if (((Class)this.type().getRawType()).getConstructor(new Class[0]) != null) {
                    return "new " + this.type().getCanonicalName() + "()";
                }
            }
            catch (NoSuchMethodException e) {
            }
            catch (SecurityException securityException) {
                // empty catch block
            }
        }
        return "new java.util.ArrayList(" + sizeExpr + ")";
    }

    public String newMap(String sizeExpr) {
        return "new java.util.LinkedHashMap(" + sizeExpr + ")";
    }

    public String newMap() {
        return this.newMap("");
    }

    @Override
    public String size() {
        return this.getter() + "." + (this.rawType().isArray() ? "length" : "size()");
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class EntrySetRef
    extends MultiOccurrenceVariableRef {
        private String name;

        public EntrySetRef(VariableRef sourceMap) {
            this(sourceMap, null);
        }

        public EntrySetRef(VariableRef sourceMap, String variableName) {
            super(EntrySetRef.getSourceEntryType(sourceMap), sourceMap + ".entrySet()");
            this.name = variableName;
        }

        private static Type<?> getSourceEntryType(VariableRef sourceMap) {
            return TypeFactory.valueOf(Set.class, MapEntry.entryType(sourceMap.type()));
        }

        @Override
        public String name() {
            if (this.name != null) {
                return this.name;
            }
            return super.name();
        }
    }
}

