/*
 * Decompiled with CFR 0.152.
 */
package ma.glasnost.orika.impl.generator;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Set;
import java.util.TreeMap;
import ma.glasnost.orika.MapEntry;
import ma.glasnost.orika.impl.generator.MultiOccurrenceVariableRef;
import ma.glasnost.orika.impl.generator.VariableRef;
import ma.glasnost.orika.impl.util.StringUtil;
import ma.glasnost.orika.metadata.FieldMap;
import ma.glasnost.orika.metadata.Property;
import ma.glasnost.orika.metadata.Type;
import ma.glasnost.orika.metadata.TypeFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Node {
    public Property property;
    public MultiOccurrenceVariableRef multiOccurrenceVar;
    public MultiOccurrenceVariableRef newDestination;
    public VariableRef elementRef;
    public VariableRef nullCheckFlag;
    public VariableRef shouldAddToCollectorFlag;
    public FieldMap value;
    public NodeList children;
    public Node parent;
    public Set<Node> mapped = new HashSet<Node>();
    public boolean addedToCollector;
    private boolean isSource;

    private Node(Property property, FieldMap fieldMap, Node parent, NodeList nodes, boolean isSource, int uniqueIndex) {
        this.isSource = isSource;
        String name = isSource ? "source" : "destination";
        String propertySuffix = StringUtil.capitalize(property.getName());
        this.value = fieldMap;
        this.parent = parent;
        this.property = property;
        if (property.isMultiOccurrence()) {
            Type<Object> elementType = null;
            if (property.isMap()) {
                Type entryType;
                if (isSource) {
                    entryType = MapEntry.entryType(property.getType());
                    elementType = entryType;
                } else {
                    entryType = MapEntry.concreteEntryType(property.getType());
                    elementType = entryType;
                }
            } else if (property.isCollection()) {
                elementType = property.getElementType();
            } else if (property.isArray()) {
                elementType = property.getType().getComponentType();
            }
            Type<Object> destinationType = property.getType().isArray() ? TypeFactory.valueOf(ArrayList.class, this.primitiveSafeListType(property.getType().getComponentType())) : (property.getType().isMap() ? TypeFactory.valueOf(ArrayList.class, elementType) : property.getType());
            this.newDestination = new MultiOccurrenceVariableRef(destinationType, "new_" + name + propertySuffix + uniqueIndex);
            String multiOccurrenceName = parent != null ? this.name(parent.elementRef.name(), name + propertySuffix) : name;
            this.multiOccurrenceVar = new MultiOccurrenceVariableRef(property, multiOccurrenceName);
            this.elementRef = new VariableRef(elementType, property.getName() + "_" + name + uniqueIndex + "Element");
            if (elementType != null && elementType.isPrimitive()) {
                this.nullCheckFlag = new VariableRef(TypeFactory.valueOf(Boolean.TYPE), property.getName() + "_" + name + uniqueIndex + "ElementIsNull");
            }
            this.shouldAddToCollectorFlag = new VariableRef(TypeFactory.valueOf(Boolean.TYPE), property.getName() + "_" + name + uniqueIndex + "ElementShouldBeAddedToCollector");
        }
        if (nodes != null) {
            nodes.add(this);
            this.children = new NodeList(nodes);
        } else if (parent != null) {
            parent.children.add(this);
            this.children = new NodeList(parent.children);
        } else {
            this.children = new NodeList();
        }
    }

    private Type<?> primitiveSafeListType(Type<?> type) {
        if (type.isPrimitive()) {
            return type.getWrapperType();
        }
        return type;
    }

    private Node(Property property, Node parent, boolean isSource, int uniqueIndex) {
        this(property, null, parent, null, isSource, uniqueIndex);
    }

    private Node(Property property, FieldMap fieldMap, Node parent, boolean isSource, int uniqueIndex) {
        this(property, fieldMap, parent, null, isSource, uniqueIndex);
    }

    private Node(Property property, FieldMap fieldMap, NodeList nodes, boolean isSource, int uniqueIndex) {
        this(property, fieldMap, null, nodes, isSource, uniqueIndex);
    }

    private String name(String value1, String defaultValue) {
        if (value1 != null && !"".equals(value1)) {
            return value1;
        }
        return defaultValue;
    }

    public boolean isLeaf() {
        return this.children.isEmpty();
    }

    public boolean isRoot() {
        return this.parent == null;
    }

    public FieldMap getMap() {
        TreeMap<Integer, FieldMap> nodes = new TreeMap<Integer, FieldMap>();
        for (Node child : this.children) {
            Property prop;
            if (child.value == null) continue;
            int depth = 0;
            FieldMap value = child.value;
            Property property = prop = this.isSource ? value.getSource() : value.getDestination();
            while (prop.getContainer() != null) {
                ++depth;
                prop = prop.getContainer();
            }
            if (nodes.containsKey(depth)) continue;
            nodes.put(depth, value);
        }
        if (!nodes.isEmpty()) {
            return (FieldMap)nodes.get(nodes.firstKey());
        }
        return null;
    }

    public boolean isMapped(Node node) {
        return this.mapped.contains(node);
    }

    public void mapped(Node node) {
        this.mapped.add(node);
    }

    public String toString() {
        return this.toString("");
    }

    private String toString(String indent) {
        StringBuilder out = new StringBuilder();
        out.append(indent + this.property.toString());
        if (!this.children.isEmpty()) {
            out.append(" {");
            for (Node child : this.children) {
                out.append("\n" + child.toString("  " + indent));
            }
            out.append("\n" + indent + "}");
        }
        return out.toString();
    }

    public static Node findFieldMap(FieldMap map, NodeList nodes, boolean useSource) {
        Property root;
        LinkedList<Property> path = new LinkedList<Property>();
        Property container = root = useSource ? map.getSource() : map.getDestination();
        while (container.getContainer() != null) {
            path.addFirst(container.getContainer());
            container = container.getContainer();
        }
        Node currentNode = null;
        NodeList children = nodes;
        int len = path.size();
        for (int p = 0; p < len; ++p) {
            Property pathElement = (Property)path.get(p);
            currentNode = null;
            for (Node node : children) {
                if (!node.property.equals(pathElement)) continue;
                currentNode = node;
                children = currentNode.children;
                break;
            }
            if (currentNode != null) continue;
            return null;
        }
        for (Node node : children) {
            if (!map.equals(node.value)) continue;
            return node;
        }
        return null;
    }

    public static Node addFieldMap(FieldMap map, NodeList nodes, boolean useSource) {
        Property root;
        LinkedList<Property> path = new LinkedList<Property>();
        Property container = root = useSource ? map.getSource() : map.getDestination();
        while (container.getContainer() != null) {
            path.addFirst(container.getContainer());
            container = container.getContainer();
        }
        Node currentNode = null;
        Node parentNode = null;
        NodeList children = nodes;
        int len = path.size();
        for (int p = 0; p < len; ++p) {
            Property pathElement = (Property)path.get(p);
            for (Node node : children) {
                if (!node.property.equals(pathElement)) continue;
                currentNode = node;
                children = currentNode.children;
                break;
            }
            if (currentNode == null) {
                currentNode = new Node(pathElement, parentNode, useSource, nodes.getTotalNodeCount());
                if (parentNode == null) {
                    children.add(currentNode);
                }
                parentNode = currentNode;
                ++p;
                while (p < len) {
                    parentNode = currentNode = new Node((Property)path.get(p), parentNode, useSource, nodes.getTotalNodeCount());
                    ++p;
                }
                continue;
            }
            parentNode = currentNode;
            currentNode = null;
        }
        if (parentNode == null) {
            root = Node.innermostElement(root);
            currentNode = new Node(root, map, nodes, useSource, nodes.getTotalNodeCount());
        } else {
            root = Node.innermostElement(root);
            currentNode = new Node(root, map, parentNode, useSource, nodes.getTotalNodeCount());
        }
        return currentNode;
    }

    private static Property innermostElement(Property p) {
        Property result = p;
        while (result.getElement() != null) {
            result = result.getElement();
        }
        return result;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class NodeList
    extends ArrayList<Node> {
        private static final long serialVersionUID = 1L;
        private int totalNodes = 0;
        private final NodeList parent;

        public NodeList() {
            this.parent = null;
        }

        private NodeList(NodeList parent) {
            this.parent = parent;
        }

        @Override
        public String toString() {
            StringBuilder out = new StringBuilder();
            out.append("{");
            if (!this.isEmpty()) {
                for (Node node : this) {
                    out.append("\n" + node.toString("  "));
                }
                out.append("\n}");
            } else {
                out.append("}");
            }
            return out.toString();
        }

        public int getTotalNodeCount() {
            return this.totalNodes;
        }

        private void incrementTotalNodes() {
            if (this.parent != null) {
                this.parent.incrementTotalNodes();
            }
            ++this.totalNodes;
        }

        @Override
        public boolean add(Node node) {
            this.incrementTotalNodes();
            return super.add(node);
        }
    }
}

