/*
 * Decompiled with CFR 0.152.
 */
package ma.glasnost.orika.impl.generator;

import java.lang.reflect.Constructor;
import java.lang.reflect.Modifier;
import java.util.List;
import java.util.Set;
import javassist.CannotCompileException;
import ma.glasnost.orika.MapperFactory;
import ma.glasnost.orika.MappingContext;
import ma.glasnost.orika.MappingException;
import ma.glasnost.orika.constructor.ConstructorResolverStrategy;
import ma.glasnost.orika.impl.GeneratedObjectFactory;
import ma.glasnost.orika.impl.generator.CompilerStrategy;
import ma.glasnost.orika.impl.generator.SourceCodeContext;
import ma.glasnost.orika.impl.generator.UsedConvertersContext;
import ma.glasnost.orika.impl.generator.UsedMapperFacadesContext;
import ma.glasnost.orika.impl.generator.UsedTypesContext;
import ma.glasnost.orika.impl.generator.VariableRef;
import ma.glasnost.orika.metadata.ClassMap;
import ma.glasnost.orika.metadata.FieldMap;
import ma.glasnost.orika.metadata.MapperKey;
import ma.glasnost.orika.metadata.Type;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ObjectFactoryGenerator {
    private static final Logger LOGGER = LoggerFactory.getLogger(ObjectFactoryGenerator.class);
    private final ConstructorResolverStrategy constructorResolverStrategy;
    private final MapperFactory mapperFactory;
    private final String nameSuffix;

    public ObjectFactoryGenerator(MapperFactory mapperFactory, ConstructorResolverStrategy constructorResolverStrategy, CompilerStrategy compilerStrategy) {
        this.mapperFactory = mapperFactory;
        this.nameSuffix = String.valueOf(System.nanoTime());
        this.constructorResolverStrategy = constructorResolverStrategy;
    }

    public GeneratedObjectFactory build(Type<?> type, MappingContext context) {
        String className = type.getSimpleName() + "_ObjectFactory" + this.nameSuffix;
        try {
            StringBuilder logDetails;
            if (LOGGER.isDebugEnabled()) {
                logDetails = new StringBuilder();
                logDetails.append("Generating new object factory for (" + type + ")");
            } else {
                logDetails = null;
            }
            SourceCodeContext factoryCode = new SourceCodeContext(className, GeneratedObjectFactory.class, context, logDetails);
            UsedTypesContext usedTypes = new UsedTypesContext();
            UsedConvertersContext usedConverters = new UsedConvertersContext();
            UsedMapperFacadesContext usedMapperFacades = new UsedMapperFacadesContext();
            this.addCreateMethod(factoryCode, usedTypes, usedConverters, usedMapperFacades, type, context, logDetails);
            GeneratedObjectFactory objectFactory = (GeneratedObjectFactory)factoryCode.getInstance();
            objectFactory.setMapperFacade(this.mapperFactory.getMapperFacade());
            if (logDetails != null) {
                LOGGER.debug(logDetails.toString());
            }
            return objectFactory;
        }
        catch (Exception e) {
            throw new MappingException("exception while creating object factory for " + type.getName(), e);
        }
    }

    private void addCreateMethod(SourceCodeContext code, UsedTypesContext usedTypes, UsedConvertersContext usedConverters, UsedMapperFacadesContext usedMappers, Type<?> type, MappingContext mappingContext, StringBuilder logDetails) throws CannotCompileException {
        StringBuilder out = new StringBuilder();
        out.append("public Object create(Object s, " + MappingContext.class.getCanonicalName() + " mappingContext) {");
        out.append(String.format("if(s == null) throw new %s(\"source object must be not null\");", IllegalArgumentException.class.getCanonicalName()));
        Set<Type<? extends Object>> sourceClasses = this.mapperFactory.lookupMappedClasses(type);
        if (sourceClasses != null && !sourceClasses.isEmpty()) {
            for (Type<? extends Object> sourceType : sourceClasses) {
                out.append(this.addSourceClassConstructor(code, type, sourceType, mappingContext, logDetails));
            }
        } else {
            throw new MappingException("Cannot generate ObjectFactory for " + type);
        }
        out.append(this.addUnmatchedSourceHandler(code, type, mappingContext, logDetails));
        out.append("\n}");
        code.addMethod(out.toString());
    }

    private String addSourceClassConstructor(SourceCodeContext code, Type<?> type, Type<?> sourceType, MappingContext mappingContext, StringBuilder logDetails) {
        MapperKey mapperKey = new MapperKey(type, sourceType);
        ClassMap classMap = this.mapperFactory.getClassMap(mapperKey);
        if (classMap == null) {
            classMap = this.mapperFactory.getClassMap(new MapperKey(sourceType, type));
        }
        StringBuilder out = new StringBuilder();
        if (type.isArray()) {
            out.append(this.addArrayClassConstructor(code, type, sourceType, classMap.getFieldsMapping().size()));
        } else {
            ConstructorResolverStrategy.ConstructorMapping<?> constructorMapping = this.constructorResolverStrategy.resolve(classMap, type);
            Constructor<?> constructor = constructorMapping.getConstructor();
            if (constructor == null) {
                throw new IllegalArgumentException("no constructors found for " + type);
            }
            if (logDetails != null) {
                logDetails.append("\n\tUsing constructor: " + constructor);
            }
            List<FieldMap> properties = constructorMapping.getMappedFields();
            Type<?>[] constructorArguments = constructorMapping.getParameterTypes();
            int argIndex = 0;
            out.append(String.format("if (s instanceof %s) {", sourceType.getCanonicalName()));
            out.append(String.format("%s source = (%s) s;", sourceType.getCanonicalName(), sourceType.getCanonicalName()));
            out.append("\ntry {\n");
            argIndex = 0;
            for (FieldMap fieldMap : properties) {
                VariableRef v = new VariableRef(constructorArguments[argIndex], "arg" + argIndex++);
                VariableRef s = new VariableRef(fieldMap.getSource(), "source");
                VariableRef destOwner = new VariableRef(fieldMap.getDestination(), "");
                v.setOwner(destOwner);
                out.append(SourceCodeContext.statement(v.declare(), new Object[0]));
                out.append(code.mapFields(fieldMap, s, v, type, logDetails));
            }
            out.append(String.format("return new %s(", type.getCanonicalName()));
            for (int i = 0; i < properties.size(); ++i) {
                out.append(String.format("arg%d", i));
                if (i >= properties.size() - 1) continue;
                out.append(",");
            }
            out.append(");");
            SourceCodeContext.append(out, "\n} catch (java.lang.Exception e) {\n", "if (e instanceof RuntimeException) {\n", "throw (RuntimeException)e;\n", "} else {", "throw new java.lang.RuntimeException(\"Error while constructing new " + type.getSimpleName() + " instance\", e);", "\n}\n}\n}");
        }
        return out.toString();
    }

    private String addUnmatchedSourceHandler(SourceCodeContext code, Type<?> type, MappingContext mappingContext, StringBuilder logDetails) {
        StringBuilder out = new StringBuilder();
        for (Constructor<?> constructor : ((Class)type.getRawType()).getConstructors()) {
            if (constructor.getParameterTypes().length != 0 || !Modifier.isPublic(constructor.getModifiers())) continue;
            out.append(String.format("return new %s();", type.getCanonicalName()));
            break;
        }
        if (out.length() == 0) {
            out.append(String.format("throw new %s(s.getClass().getCanonicalName() + \" is an unsupported source class : \"+s.getClass().getCanonicalName());", IllegalArgumentException.class.getCanonicalName()));
        }
        return out.toString();
    }

    private String addArrayClassConstructor(SourceCodeContext code, Type<?> type, Type<?> sourceType, int size) {
        return String.format("if (s instanceof %s) {", sourceType.getCanonicalName()) + "return new " + ((Class)type.getRawType()).getComponentType().getCanonicalName() + "[" + size + "];" + "\n}";
    }
}

