/*
 * Decompiled with CFR 0.152.
 */
package ma.glasnost.orika.impl.generator;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import ma.glasnost.orika.BoundMapperFacade;
import ma.glasnost.orika.Converter;
import ma.glasnost.orika.DefaultFieldMapper;
import ma.glasnost.orika.MapEntry;
import ma.glasnost.orika.MapperFactory;
import ma.glasnost.orika.MappingContext;
import ma.glasnost.orika.MappingException;
import ma.glasnost.orika.Properties;
import ma.glasnost.orika.converter.ConverterFactory;
import ma.glasnost.orika.impl.GeneratedObjectBase;
import ma.glasnost.orika.impl.Specifications;
import ma.glasnost.orika.impl.generator.AggregateSpecification;
import ma.glasnost.orika.impl.generator.CodeGenerationStrategy;
import ma.glasnost.orika.impl.generator.CompilerStrategy;
import ma.glasnost.orika.impl.generator.Node;
import ma.glasnost.orika.impl.generator.Specification;
import ma.glasnost.orika.impl.generator.UsedConvertersContext;
import ma.glasnost.orika.impl.generator.UsedMapperFacadesContext;
import ma.glasnost.orika.impl.generator.UsedTypesContext;
import ma.glasnost.orika.impl.generator.VariableRef;
import ma.glasnost.orika.impl.generator.specification.AbstractSpecification;
import ma.glasnost.orika.impl.util.ClassUtil;
import ma.glasnost.orika.metadata.ClassMap;
import ma.glasnost.orika.metadata.FieldMap;
import ma.glasnost.orika.metadata.MapperKey;
import ma.glasnost.orika.metadata.Property;
import ma.glasnost.orika.metadata.Type;
import ma.glasnost.orika.metadata.TypeFactory;
import ma.glasnost.orika.property.PropertyResolverStrategy;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SourceCodeContext {
    private static final AtomicInteger UNIQUE_CLASS_INDEX = new AtomicInteger();
    private StringBuilder sourceBuilder;
    private String classSimpleName;
    private String packageName;
    private String className;
    private CompilerStrategy compilerStrategy;
    private List<String> methods;
    private List<String> fields;
    private Class<?> superClass;
    private final UsedTypesContext usedTypes;
    private final UsedConvertersContext usedConverters;
    private final UsedMapperFacadesContext usedMapperFacades;
    private final MapperFactory mapperFactory;
    private final CodeGenerationStrategy codeGenerationStrategy;
    private final StringBuilder logDetails;
    private final PropertyResolverStrategy propertyResolver;
    private final Map<AggregateSpecification, List<FieldMap>> aggregateFieldMaps;
    private final MappingContext mappingContext;

    public SourceCodeContext(String baseClassName, Class<?> superClass, MappingContext mappingContext, StringBuilder logDetails) {
        this.mapperFactory = (MapperFactory)mappingContext.getProperty((Object)Properties.MAPPER_FACTORY);
        this.codeGenerationStrategy = (CodeGenerationStrategy)mappingContext.getProperty((Object)Properties.CODE_GENERATION_STRATEGY);
        this.compilerStrategy = (CompilerStrategy)mappingContext.getProperty((Object)Properties.COMPILER_STRATEGY);
        this.propertyResolver = (PropertyResolverStrategy)mappingContext.getProperty((Object)Properties.PROPERTY_RESOLVER_STRATEGY);
        String safeBaseClassName = baseClassName.replace("[]", "$Array");
        this.sourceBuilder = new StringBuilder();
        this.superClass = superClass;
        int namePos = safeBaseClassName.lastIndexOf(".");
        if (namePos > 0) {
            this.packageName = safeBaseClassName.substring(0, namePos - 1);
            this.classSimpleName = safeBaseClassName.substring(namePos + 1);
        } else {
            this.packageName = "ma.glasnost.orika.generated";
            this.classSimpleName = safeBaseClassName;
        }
        this.classSimpleName = this.makeUniqueClassName(this.classSimpleName);
        this.className = this.packageName + "." + this.classSimpleName;
        this.methods = new ArrayList<String>();
        this.fields = new ArrayList<String>();
        this.sourceBuilder.append("package " + this.packageName + ";\n\n");
        this.sourceBuilder.append("public class " + this.classSimpleName + " extends " + superClass.getCanonicalName() + " {\n");
        this.usedTypes = new UsedTypesContext();
        this.usedConverters = new UsedConvertersContext();
        this.mappingContext = mappingContext;
        this.usedMapperFacades = new UsedMapperFacadesContext();
        this.logDetails = logDetails;
        this.aggregateFieldMaps = new LinkedHashMap<AggregateSpecification, List<FieldMap>>();
    }

    private String makeUniqueClassName(String name) {
        return name + System.nanoTime() + "$" + UNIQUE_CLASS_INDEX.getAndIncrement();
    }

    public boolean isDebugEnabled() {
        return this.logDetails != null;
    }

    public void debug(String msg) {
        if (this.isDebugEnabled()) {
            this.logDetails.append(msg);
        }
    }

    protected StringBuilder getSourceBuilder() {
        return this.sourceBuilder;
    }

    public Class<?> getSuperClass() {
        return this.superClass;
    }

    public String getClassSimpleName() {
        return this.classSimpleName;
    }

    public String getPackageName() {
        return this.packageName;
    }

    public String getClassName() {
        return this.className;
    }

    List<String> getFields() {
        return this.fields;
    }

    List<String> getMethods() {
        return this.methods;
    }

    public boolean shouldMapNulls() {
        return (Boolean)this.mappingContext.getProperty((Object)Properties.SHOULD_MAP_NULLS);
    }

    public MappingContext getMappingContext() {
        return this.mappingContext;
    }

    public void addMethod(String methodSource) {
        this.sourceBuilder.append("\n" + methodSource + "\n");
        this.methods.add(methodSource);
    }

    public void addField(String fieldSource) {
        this.sourceBuilder.append("\n" + fieldSource + "\n");
        this.fields.add(fieldSource);
    }

    public String toSourceFile() {
        return this.sourceBuilder.toString() + "\n}";
    }

    protected Class<?> compileClass() throws CompilerStrategy.SourceCodeGenerationException {
        return this.compilerStrategy.compileClass(this);
    }

    public <T extends GeneratedObjectBase> T getInstance() throws CompilerStrategy.SourceCodeGenerationException, InstantiationException, IllegalAccessException {
        GeneratedObjectBase instance = (GeneratedObjectBase)this.compileClass().newInstance();
        Object[] usedTypesArray = this.usedTypes.toArray();
        Object[] usedConvertersArray = this.usedConverters.toArray();
        Object[] usedMapperFacadesArray = this.usedMapperFacades.toArray();
        if (this.logDetails != null) {
            if (usedTypesArray.length > 0) {
                this.logDetails.append("\n\t" + Type.class.getSimpleName() + "s used: " + Arrays.toString(usedTypesArray));
            }
            if (usedConvertersArray.length > 0) {
                this.logDetails.append("\n\t" + Converter.class.getSimpleName() + "s used: " + Arrays.toString(usedConvertersArray));
            }
            if (usedMapperFacadesArray.length > 0) {
                this.logDetails.append("\n\t" + BoundMapperFacade.class.getSimpleName() + "s used: " + Arrays.toString(usedMapperFacadesArray));
            }
        }
        instance.setUsedTypes((Type<Object>[])usedTypesArray);
        instance.setUsedConverters((Converter<Object, Object>[])usedConvertersArray);
        instance.setUsedMapperFacades((BoundMapperFacade<Object, Object>[])usedMapperFacadesArray);
        return (T)instance;
    }

    public String usedConverter(Converter<?, ?> converter) {
        int index = this.usedConverters.getIndex(converter);
        return "((" + Converter.class.getCanonicalName() + ")usedConverters[" + index + "])";
    }

    public String usedType(Type<?> type) {
        int index = this.usedTypes.getIndex(type);
        return "((" + Type.class.getCanonicalName() + ")usedTypes[" + index + "])";
    }

    private String usedMapperFacadeCall(Type<?> sourceType, Type<?> destinationType) {
        UsedMapperFacadesContext.UsedMapperFacadesIndex usedFacade = this.usedMapperFacades.getIndex(sourceType, destinationType, this.mapperFactory);
        String mapInDirection = usedFacade.isReversed ? "mapReverse" : "map";
        return "((" + BoundMapperFacade.class.getCanonicalName() + ")usedMapperFacades[" + usedFacade.index + "])." + mapInDirection + "";
    }

    public String callMapper(Type<?> sourceType, Type<?> destinationType, String sourceExpression, String destExpression) {
        return this.usedMapperFacadeCall(sourceType, destinationType) + "(" + sourceExpression + ", " + destExpression + ", mappingContext)";
    }

    public String callMapper(Type<?> sourceType, Type<?> destinationType, String sourceExpression) {
        return this.usedMapperFacadeCall(sourceType, destinationType) + "(" + sourceExpression + ", mappingContext)";
    }

    public String callMapper(VariableRef source, VariableRef destination) {
        return this.callMapper(source.type(), destination.type(), "" + source, "" + destination);
    }

    public String callMapper(VariableRef source, Type<?> destination) {
        return this.callMapper(source.type(), destination, "" + source);
    }

    public String usedMapperFacadeNewObjectCall(VariableRef source, VariableRef destination) {
        return this.newObjectFromMapper(source.type(), destination.type());
    }

    public String newObjectFromMapper(Type<?> sourceType, Type<?> destinationType) {
        UsedMapperFacadesContext.UsedMapperFacadesIndex usedFacade = this.usedMapperFacades.getIndex(sourceType, destinationType, this.mapperFactory);
        String instantiateMethod = usedFacade.isReversed ? "newObjectReverse" : "newObject";
        return "((" + BoundMapperFacade.class.getCanonicalName() + ")usedMapperFacades[" + usedFacade.index + "])." + instantiateMethod + "";
    }

    public String newObjectFromMapper(VariableRef source, Type<?> destinationType) {
        return this.newObjectFromMapper(source.type(), destinationType) + "(" + source.asWrapper() + ", mappingContext)";
    }

    public String usedType(VariableRef r) {
        return this.usedType(r.type());
    }

    public String newObject(VariableRef source, Type<?> destinationType) {
        if (destinationType.isPrimitive()) {
            return VariableRef.getDefaultValue(destinationType.getRawType());
        }
        if (destinationType.isString()) {
            return "null";
        }
        return this.newObjectFromMapper(source, destinationType);
    }

    public String assureInstanceExists(VariableRef propertyRef, VariableRef source) {
        StringBuilder out = new StringBuilder();
        for (VariableRef ref : propertyRef.getPath()) {
            if (!ClassUtil.isConcrete(ref.type()) && !ref.type().isMultiOccurrence()) {
                throw new MappingException("Abstract types are unsupported for nested properties. \n" + ref.name());
            }
            SourceCodeContext.append(out, String.format("if(%s) { \n", ref.isNull()), ref.assign(this.newObject(source, ref.type()), new Object[0]), "}");
        }
        return out.toString();
    }

    public static String statement(String str, Object ... args) {
        if (str != null && !"".equals(str.trim())) {
            String trimmed;
            String expr = String.format(str, args);
            String prefix = "";
            String suffix = "";
            if (!expr.startsWith("\n") || expr.startsWith("}")) {
                prefix = "\n";
            }
            if (!("".equals(trimmed = expr.trim()) || trimmed.endsWith(";") || trimmed.endsWith("}") || trimmed.endsWith("{") || trimmed.endsWith("("))) {
                suffix = "; ";
            }
            return prefix + expr + suffix;
        }
        if (str != null) {
            return str;
        }
        return "";
    }

    public static void append(StringBuilder out, String ... statements) {
        for (String statement : statements) {
            out.append(SourceCodeContext.statement(statement, new Object[0]));
        }
    }

    public static String join(List<?> list, String separator) {
        StringBuilder result = new StringBuilder();
        for (Object item : list) {
            result.append(item + separator);
        }
        return result.length() > 0 ? result.substring(0, result.length() - separator.length()) : "";
    }

    public static VariableRef entrySetRef(VariableRef s) {
        Type<Set> sourceEntryType = TypeFactory.valueOf(Set.class, MapEntry.entryType(s.type()));
        return new VariableRef(sourceEntryType, s + ".entrySet()");
    }

    public String currentElementComparator(Node source, Node dest, Node.NodeList srcNodes, Node.NodeList destNodes) {
        StringBuilder comparator = new StringBuilder();
        MapperKey key = new MapperKey(source.elementRef.type(), dest.elementRef.type());
        ClassMap<Object, Object> classMap = this.mapperFactory.getClassMap(key);
        if (classMap == null) {
            classMap = this.mapperFactory.classMap(key.getAType(), key.getBType()).byDefault(new DefaultFieldMapper[0]).toClassMap();
        }
        String or = "";
        HashSet<FieldMap> fieldMaps = new HashSet<FieldMap>(classMap.getFieldsMapping());
        for (Node node : source.children) {
            if (node.value == null) continue;
            fieldMaps.add(node.value);
        }
        for (Node node : dest.children) {
            if (node.value == null) continue;
            fieldMaps.add(node.value);
        }
        HashSet<String> comparisons = new HashSet<String>();
        for (FieldMap fieldMap : fieldMaps) {
            if (fieldMap.is(Specifications.aMultiOccurrenceElementMap()) && fieldMap.isByDefault() || fieldMap.isExcluded() || fieldMap.isIgnored()) continue;
            Node srcNode = Node.findFieldMap(fieldMap, srcNodes, true);
            srcNode = srcNode != null && srcNode.parent != null ? srcNode.parent : source;
            Node destNode = Node.findFieldMap(fieldMap, destNodes, false);
            destNode = destNode != null && destNode.parent != null ? destNode.parent : dest;
            Type<?> sourceType = source.elementRef.type();
            Type<?> destType = dest.elementRef.type();
            try {
                VariableRef d;
                this.propertyResolver.getProperty(sourceType, fieldMap.getSource().getName());
                this.propertyResolver.getProperty(destType, fieldMap.getDestination().getName());
                VariableRef s = new VariableRef(fieldMap.getSource(), srcNode.elementRef);
                String code = this.compareFields(fieldMap, s, d = new VariableRef(fieldMap.getDestination(), destNode.elementRef), key.getBType(), null);
                if ("".equals(code) || !comparisons.add(code)) continue;
                comparator.append(or + "!(" + code + ")");
                or = " || ";
            }
            catch (Exception e) {}
        }
        return comparator.toString();
    }

    private Property root(Property prop) {
        Property root = prop;
        while (root.getContainer() != null) {
            root = root.getContainer();
        }
        return root;
    }

    public Set<FieldMap> getAssociatedMappings(Collection<FieldMap> fieldMaps, FieldMap map) {
        LinkedHashSet<FieldMap> associated = new LinkedHashSet<FieldMap>();
        associated.add(map);
        LinkedHashSet<FieldMap> unprocessed = new LinkedHashSet<FieldMap>(fieldMaps);
        unprocessed.remove(map);
        LinkedHashSet<String> nextRoundSources = new LinkedHashSet<String>();
        LinkedHashSet<String> nextRoundDestinations = new LinkedHashSet<String>();
        Set<String> thisRoundSources = Collections.singleton(this.root(map.getSource()).getExpression());
        Set<String> thisRoundDestinations = Collections.singleton(this.root(map.getDestination()).getExpression());
        while (!(unprocessed.isEmpty() || thisRoundSources.isEmpty() && thisRoundDestinations.isEmpty())) {
            Iterator iter = unprocessed.iterator();
            while (iter.hasNext()) {
                FieldMap f = (FieldMap)iter.next();
                boolean containsSource = thisRoundSources.contains(this.root(f.getSource()).getExpression());
                boolean containsDestination = thisRoundDestinations.contains(this.root(f.getDestination()).getExpression());
                if (containsSource && containsDestination) {
                    associated.add(f);
                    iter.remove();
                    continue;
                }
                if (containsSource) {
                    associated.add(f);
                    iter.remove();
                    nextRoundDestinations.add(f.getDestination().getName());
                    continue;
                }
                if (!containsDestination) continue;
                associated.add(f);
                iter.remove();
                nextRoundSources.add(f.getSource().getName());
            }
            thisRoundSources = nextRoundSources;
            thisRoundDestinations = nextRoundDestinations;
            nextRoundSources = new LinkedHashSet();
            nextRoundDestinations = new LinkedHashSet();
        }
        return associated;
    }

    public boolean aggregateSpecsApply(FieldMap fieldMap) {
        for (AggregateSpecification spec : this.codeGenerationStrategy.getAggregateSpecifications()) {
            if (!spec.appliesTo(fieldMap)) continue;
            List<FieldMap> fieldMaps = this.aggregateFieldMaps.get(spec);
            if (fieldMaps == null) {
                fieldMaps = new ArrayList<FieldMap>();
                this.aggregateFieldMaps.put(spec, fieldMaps);
            }
            fieldMaps.add(fieldMap);
            return true;
        }
        return false;
    }

    public String mapAggregateFields() {
        StringBuilder out = new StringBuilder();
        for (Map.Entry<AggregateSpecification, List<FieldMap>> entry : this.aggregateFieldMaps.entrySet()) {
            if (entry.getValue().isEmpty()) continue;
            out.append(entry.getKey().generateMappingCode(entry.getValue(), this));
        }
        this.aggregateFieldMaps.clear();
        return out.toString();
    }

    public String mapFields(FieldMap fieldMap, VariableRef sourceProperty, VariableRef destinationProperty, Type<?> destinationType, StringBuilder logDetails) {
        StringBuilder out = new StringBuilder();
        StringBuilder closing = new StringBuilder();
        if (sourceProperty.isNestedProperty()) {
            out.append(sourceProperty.ifPathNotNull());
            out.append("{ \n");
            closing.append("\n}");
        }
        if (destinationProperty.isNestedProperty()) {
            if (!sourceProperty.isPrimitive()) {
                out.append(sourceProperty.ifNotNull());
                out.append(" {\n");
                closing.append("\n}");
                if (AbstractSpecification.shouldMapNulls(fieldMap, this) && !destinationProperty.isPrimitive()) {
                    closing.append(" else {\n");
                    closing.append("\n");
                    closing.append(destinationProperty.ifPathNotNull());
                    closing.append("{\n");
                    closing.append(destinationProperty.assignIfPossible("null", new Object[0]));
                    closing.append(";\n}\n}");
                }
            }
            out.append(this.assureInstanceExists(destinationProperty, sourceProperty));
        }
        Converter<Object, Object> converter = this.getConverter(fieldMap, fieldMap.getConverterId());
        sourceProperty.setConverter(converter);
        for (Specification spec : this.codeGenerationStrategy.getSpecifications()) {
            if (!spec.appliesTo(fieldMap)) continue;
            String code = spec.generateMappingCode(fieldMap, sourceProperty, destinationProperty, this);
            if (code == null || "".equals(code)) {
                throw new IllegalStateException("empty code returned for spec " + spec + ", sourceProperty = " + sourceProperty + ", destinationProperty = " + destinationProperty);
            }
            out.append(code);
            break;
        }
        out.append(closing.toString());
        return out.toString();
    }

    public String compareFields(FieldMap fieldMap, VariableRef sourceProperty, VariableRef destinationProperty, Type<?> destinationType, StringBuilder logDetails) {
        StringBuilder out = new StringBuilder();
        out.append("(");
        if (sourceProperty.isNestedProperty()) {
            out.append(sourceProperty.ifPathNotNull());
            out.append(" && ");
        }
        if (destinationProperty.isNestedProperty()) {
            if (!sourceProperty.isPrimitive()) {
                out.append(sourceProperty.notNull());
                out.append(" && ");
            }
            out.append(this.assureInstanceExists(destinationProperty, sourceProperty));
        }
        Converter<Object, Object> converter = this.getConverter(fieldMap, fieldMap.getConverterId());
        sourceProperty.setConverter(converter);
        for (Specification spec : this.codeGenerationStrategy.getSpecifications()) {
            if (!spec.appliesTo(fieldMap)) continue;
            String code = spec.generateEqualityTestCode(fieldMap, sourceProperty, destinationProperty, this);
            if (code == null || "".equals(code)) {
                throw new IllegalStateException("empty code returned for spec " + spec + ", sourceProperty = " + sourceProperty + ", destinationProperty = " + destinationProperty);
            }
            out.append(code);
            break;
        }
        out.append(")");
        return out.toString();
    }

    private Converter<Object, Object> getConverter(FieldMap fieldMap, String converterId) {
        Converter<Object, Object> converter = null;
        ConverterFactory converterFactory = this.mapperFactory.getConverterFactory();
        converter = converterId != null ? converterFactory.getConverter(converterId) : converterFactory.getConverter(fieldMap.getSource().getType(), fieldMap.getDestination().getType());
        return converter;
    }
}

