/*
 * Decompiled with CFR 0.152.
 */
package ma.glasnost.orika.impl.generator;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import ma.glasnost.orika.Converter;
import ma.glasnost.orika.MapEntry;
import ma.glasnost.orika.impl.util.ClassUtil;
import ma.glasnost.orika.metadata.NestedProperty;
import ma.glasnost.orika.metadata.Property;
import ma.glasnost.orika.metadata.Type;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VariableRef {
    protected String name;
    private Property property;
    private VariableRef owner;
    private Type<?> type;
    private boolean declared;
    private Converter<?, ?> converter;

    public VariableRef(Property property, String name) {
        this.name = name;
        this.property = property;
        this.type = property.getType();
    }

    public VariableRef(Property property, VariableRef anchor) {
        this(property, anchor.toString());
    }

    public VariableRef(Type<?> type, String name) {
        this.name = name;
        this.type = type;
    }

    public void setConverter(Converter<?, ?> converter) {
        this.converter = converter;
    }

    public Converter<?, ?> getConverter() {
        return this.converter;
    }

    public void setOwner(VariableRef owner) {
        this.owner = owner;
    }

    public VariableRef getOwner() {
        return this.owner;
    }

    protected String getter() {
        return this.property == null ? this.name : VariableRef.getGetter(this.property, this.name);
    }

    protected String setter() {
        return this.property == null ? this.name + " = %s" : VariableRef.getSetter(this.property, this.name);
    }

    public boolean isReadable() {
        return this.getter() != null;
    }

    public boolean isAssignable() {
        return this.setter() != null;
    }

    public Class<?> rawType() {
        return this.type.getRawType();
    }

    public Property property() {
        return this.property;
    }

    public Type<?> type() {
        return this.type;
    }

    public boolean isPrimitive() {
        return this.type.isPrimitive();
    }

    public boolean isArray() {
        return this.property != null ? this.property.isArray() : ((Class)this.type.getRawType()).isArray();
    }

    public boolean isCollection() {
        return this.property != null ? this.property.isCollection() : Collection.class.isAssignableFrom(this.rawType());
    }

    public boolean isList() {
        return this.property != null ? this.property.isList() : List.class.isAssignableFrom(this.rawType());
    }

    public boolean isSet() {
        return this.property != null ? this.property.isSet() : Set.class.isAssignableFrom(this.rawType());
    }

    public boolean isMap() {
        return this.property != null ? this.property.isMap() : Map.class.isAssignableFrom(this.rawType());
    }

    public boolean isMapEntry() {
        return Map.Entry.class.isAssignableFrom(this.rawType());
    }

    public boolean isWrapper() {
        return this.type.isPrimitiveWrapper();
    }

    public String wrapperTypeName() {
        return ClassUtil.getWrapperType(this.rawType()).getCanonicalName();
    }

    public VariableRef elementRef(String name) {
        return new VariableRef(this.elementType(), name);
    }

    public String elementTypeName() {
        return this.elementType() != null ? this.elementType().getCanonicalName() : null;
    }

    public Type<?> elementValueType() {
        if (((Class)this.type.getRawType()).isArray()) {
            return this.type.getComponentType();
        }
        if (this.type.isMap()) {
            return this.type.getNestedType(1);
        }
        return this.type.getNestedType(0);
    }

    public Type<?> elementType() {
        if (((Class)this.type.getRawType()).isArray()) {
            return this.type.getComponentType();
        }
        if (this.type.isMap()) {
            return MapEntry.concreteEntryType(this.type);
        }
        return this.property != null ? this.property.getElementType() : (Type)this.type.getActualTypeArguments()[0];
    }

    public Type<?> mapKeyType() {
        if (this.isMap()) {
            return this.type().getNestedType(0);
        }
        return null;
    }

    public Type<?> mapValueType() {
        if (this.isMap()) {
            return this.type().getNestedType(1);
        }
        return null;
    }

    public String typeName() {
        return this.type.getCanonicalName();
    }

    public String asWrapper() {
        String ref = this.getter();
        if (this.isPrimitive()) {
            ref = ClassUtil.getWrapperType(this.rawType()).getCanonicalName() + ".valueOf(" + ref + ")";
        }
        return ref;
    }

    public String assign(String value, Object ... replacements) {
        if (this.setter() != null) {
            return this.assignIfPossible(value, replacements);
        }
        throw new IllegalArgumentException("Attempt was made to generate assignment/setter code for [" + this.name + "." + (this.property != null ? this.property : this.type) + "] which has no setter/assignment method");
    }

    public String assignIfPossible(String value, Object ... replacements) {
        if (this.setter() != null) {
            String expr = String.format(value, replacements);
            expr = this.cast(expr);
            return String.format(this.setter(), expr);
        }
        return "";
    }

    public String assignIfPossible(VariableRef value) {
        if (this.setter() != null) {
            return String.format(this.setter(), this.cast(value));
        }
        return "";
    }

    public String assign(VariableRef value) {
        if (this.setter() != null) {
            String expr = value.toString();
            if (value.type().isPrimitive() && this.type.isPrimitiveWrapper()) {
                String wrapperClass = ClassUtil.getWrapperType(this.rawType()).getCanonicalName();
                expr = String.format("(%s) %s.valueOf(%s)", wrapperClass, wrapperClass, expr);
            } else if (this.type.isPrimitive() && value.type().isPrimitiveWrapper()) {
                expr = String.format("((%s)%s).%sValue()", ClassUtil.getWrapperType(this.rawType()).getCanonicalName(), expr, this.primitiveType(this.rawType()));
            } else if (this.type.isArray() && value.isCollection()) {
                if (this.type.getComponentType().isPrimitive() && value.elementType().isPrimitiveWrapper()) {
                    String wrapperType = ClassUtil.getWrapperType(this.rawType().getComponentType()).getCanonicalName();
                    expr = String.format("(%s[])%s.toArray(new %s[0])", wrapperType, expr, wrapperType);
                } else {
                    expr = String.format("(%s[])%s.toArray(new %s[0])", value.elementType().getCanonicalName(), expr, value.elementType().getCanonicalName());
                }
            } else if (!this.type.isArray() && value.type().isPrimitive() && !this.type.isPrimitive()) {
                expr = String.format("%s.valueOf(%s)", value.type.getWrapperType().getCanonicalName(), expr);
            }
            return String.format(this.setter(), expr);
        }
        return "";
    }

    public String cast(VariableRef ref) {
        return VariableRef.cast(ref, this.type());
    }

    public String cast(String value) {
        return VariableRef.cast(value, this.type());
    }

    protected static String cast(String value, Type<?> type) {
        String castValue = value.trim();
        String typeName = type.getCanonicalName();
        if (!"null".equals(value)) {
            if (type.isPrimitive()) {
                if (type.getRawType() == Character.TYPE) {
                    castValue = String.format("(\"\"+%s).charAt(0)", castValue);
                } else if (!VariableRef.isPrimitiveLiteral(castValue, type)) {
                    castValue = String.format("%s.valueOf(\"\"+%s).%sValue()", type.getWrapperType().getCanonicalName(), castValue, type);
                }
            } else if (type.isPrimitiveWrapper() && VariableRef.isPrimitiveLiteral(castValue, type)) {
                castValue = String.format("%s.valueOf(%s)", type.getWrapperType().getCanonicalName(), castValue);
            } else if (type.isString()) {
                castValue = "\"\" + " + castValue;
            } else if (!value.startsWith("(" + typeName + ")")) {
                castValue = "((" + typeName + ")" + castValue + ")";
            }
        }
        return castValue;
    }

    protected static String cast(VariableRef value, Type<?> type) {
        String castValue = value.toString();
        String typeName = type.getCanonicalName();
        if (type.isPrimitive()) {
            if (value.isWrapper()) {
                castValue = String.format("%s.%sValue()", castValue, type);
            } else if (Character.TYPE == type.getRawType() && value.type().isString()) {
                castValue = String.format("%s.charAt(0)", value);
            } else if (!value.isPrimitive()) {
                castValue = String.format("%s.valueOf(\"\"+%s).%sValue()", type.getWrapperType().getCanonicalName(), castValue, typeName);
            }
        } else if (type.isPrimitiveWrapper()) {
            if (value.isPrimitive()) {
                castValue = String.format("%s.valueOf(%s)", type.getCanonicalName(), castValue);
            }
        } else {
            castValue = type.isString() ? "\"\" + " + castValue : "((" + typeName + ")" + castValue + ")";
        }
        return castValue;
    }

    public String declare() {
        this.declared = true;
        return String.format("\n%s %s = %s", this.typeName(), this.name(), VariableRef.getDefaultValue(this.rawType()));
    }

    public String declare(String value, Object ... args) {
        String valueExpr = String.format(value, args);
        valueExpr = this.cast(valueExpr);
        this.declared = true;
        return String.format("\n%s %s = %s", this.typeName(), this.name(), valueExpr);
    }

    public String declare(VariableRef ref) {
        return this.declare(this.cast(ref), new Object[0]);
    }

    public boolean isDeclared() {
        return this.declared;
    }

    public static String getDefaultValue(Class<?> clazz) {
        if (Boolean.TYPE.equals(clazz)) {
            return "false";
        }
        if (Character.TYPE.equals(clazz)) {
            return "'\\u0000'";
        }
        if (clazz.isPrimitive()) {
            return "0";
        }
        return "null";
    }

    public String primitiveType() {
        return this.primitiveType(this.rawType());
    }

    public String primitiveType(Class<?> clazz) {
        String type = clazz.getSimpleName().toLowerCase();
        if ("integer".equals(type)) {
            type = "int";
        } else if ("character".equals(type)) {
            type = "char";
        }
        return type;
    }

    public String owner() {
        return this.name;
    }

    public String name() {
        return this.property != null ? this.property.getName() : this.name;
    }

    public String isNull() {
        return this.property != null ? VariableRef.isNull(this.property, this.name) : this.getter() + " == null";
    }

    private static String unwrap(String expression) {
        if (expression.startsWith("((")) {
            expression = (expression = expression.substring(expression.indexOf(")") + 1, expression.length() - 1)).endsWith("]") ? expression.substring(0, expression.lastIndexOf("[")) : expression.substring(0, expression.lastIndexOf("."));
        }
        return expression;
    }

    private static String isNull(Property property, String name) {
        if (property == null) {
            return name + " == null";
        }
        String getterNull = VariableRef.getGetter(property, name) + " == null";
        if (property.isListElement()) {
            return "(" + VariableRef.unwrap(VariableRef.getGetter(property, name)) + ".size() <= " + property.getName().replaceAll("[\\[\\]]", "") + " || " + getterNull + ")";
        }
        if (property.isArrayElement()) {
            return "(" + VariableRef.unwrap(VariableRef.getGetter(property, name)) + ".length <= " + property.getName().replaceAll("[\\[\\]]", "") + " || " + getterNull + ")";
        }
        return getterNull;
    }

    public String notNull() {
        StringBuilder path = new StringBuilder();
        path.append("(");
        if (this.property() != null && this.property().hasPath()) {
            boolean first = true;
            String expression = this.name;
            for (Property p : this.property().getPath()) {
                if (!first) {
                    path.append(" && ");
                } else {
                    first = false;
                }
                path.append(String.format("!(%s)", VariableRef.isNull(p, expression)));
                expression = VariableRef.getGetter(p, expression);
            }
        }
        if (path.length() > 1) {
            path.append(" && ");
        }
        path.append(String.format("!(%s)", VariableRef.isNull(this.property, this.name)));
        path.append(")");
        return path.toString();
    }

    public String ifNotNull() {
        return "if ( " + this.notNull() + ") ";
    }

    public String ifNull() {
        return "if ( " + this.isNull() + ") ";
    }

    public String toString() {
        return this.getter();
    }

    public boolean isNestedProperty() {
        return this.property != null && this.property.hasPath();
    }

    public List<VariableRef> getPath() {
        if (this.property != null && this.property.hasPath()) {
            ArrayList<VariableRef> path;
            Property[] propPath = this.property.getPath();
            if (propPath.length > 1) {
                path = new ArrayList<VariableRef>(propPath.length);
                path.add(new VariableRef(propPath[0], this.name));
                for (int i = 1; i < propPath.length; ++i) {
                    Property[] nestedPath = new Property[i];
                    System.arraycopy(propPath, 0, nestedPath, 0, i);
                    path.add(new VariableRef((Property)new NestedProperty(VariableRef.join(propPath, ".", 0, i + 1), propPath[i], nestedPath), this.name));
                }
            } else {
                path = Collections.singletonList(new VariableRef(propPath[0], this.name));
            }
            return path;
        }
        return Collections.emptyList();
    }

    private static String join(Property[] array, String separator, int startIndex, int endIndex) {
        if (array == null) {
            return null;
        }
        int bufSize = endIndex - startIndex;
        if (bufSize <= 0) {
            return "";
        }
        StringBuilder buf = new StringBuilder(bufSize *= (array[startIndex] == null ? 16 : array[startIndex].toString().length()) + 1);
        for (int i = startIndex; i < endIndex; ++i) {
            if (i > startIndex) {
                buf.append(separator);
            }
            if (array[i] == null) continue;
            buf.append(array[i].getName());
        }
        return buf.toString();
    }

    public String assertType() {
        return "if(!(" + this.name + " instanceof " + this.typeName() + ")) throw new IllegalStateException(\"[" + this.name + "] is not an instance of " + this.typeName() + " \");";
    }

    public String size() {
        return this.getter() + "." + (this.rawType().isArray() ? "length" : "size()");
    }

    protected static String getGetter(Property property, String variableExpression) {
        if (property.getGetter() == null) {
            return null;
        }
        String var = variableExpression;
        if (property.hasPath()) {
            for (Property p : property.getPath()) {
                var = VariableRef.getGetter(p, var);
            }
        }
        String getter = "((" + property.getType().getCanonicalName() + ")" + var;
        getter = !property.isArrayElement() && !"".equals(property.getName()) && !property.getGetter().startsWith("[") ? getter + "." + property.getGetter() + ")" : getter + property.getGetter() + ")";
        return getter;
    }

    public String isInstanceOf(Type<?> type) {
        return String.format("(%s instanceof %s)", this.getter(), type.getCanonicalName());
    }

    protected static String getSetter(Property property, String variableExpression) {
        if (property.getSetter() == null) {
            return null;
        }
        String var = variableExpression;
        if (property.hasPath()) {
            for (Property p : property.getPath()) {
                var = VariableRef.getGetter(p, var);
            }
        }
        return var + (property.isArrayElement() || "".equals(property.getName()) || property.getSetter().startsWith("[") ? "" : ".") + property.getSetter();
    }

    public String ifPathNotNull() {
        StringBuilder path = new StringBuilder();
        if (this.property.hasPath()) {
            boolean first = true;
            path.append("if(");
            String expression = this.name;
            for (Property p : this.property.getPath()) {
                if (!first) {
                    path.append(" && ");
                } else {
                    first = false;
                }
                path.append(String.format("!(%s)", VariableRef.isNull(p, expression)));
                expression = VariableRef.getGetter(p, expression);
            }
            path.append(")");
        }
        return path.toString();
    }

    protected static boolean isPrimitiveLiteral(String expr, Type<?> type) {
        if (type.isPrimitive()) {
            String primitiveType = type.getCanonicalName();
            if ("boolean".equals(primitiveType)) {
                return expr.matches("(true|false)");
            }
            if ("char".equals(primitiveType)) {
                return expr.matches("^'\\w+'$");
            }
            if ("int".equals(primitiveType) || "short".equals(primitiveType)) {
                return expr.matches("\\d+");
            }
            if ("long".equals(primitiveType)) {
                return expr.matches("\\d+(l|L)?");
            }
            if ("float".equals(primitiveType)) {
                return expr.matches("\\d*(\\.\\d*)?(f|F)?");
            }
            if ("double".equals(primitiveType)) {
                return expr.matches("\\d+(\\.\\d*)?");
            }
        }
        return false;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        result = 31 * result + (this.property == null ? 0 : this.property.hashCode());
        result = 31 * result + (this.type == null ? 0 : this.type.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        VariableRef other = (VariableRef)obj;
        if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
            return false;
        }
        if (this.property == null ? other.property != null : !this.property.equals(other.property)) {
            return false;
        }
        return !(this.type == null ? other.type != null : !this.type.equals(other.type));
    }
}

