/*
 * Decompiled with CFR 0.152.
 */
package ma.glasnost.orika.impl.generator.specification;

import java.lang.reflect.Type;
import ma.glasnost.orika.MappingException;
import ma.glasnost.orika.impl.generator.MultiOccurrenceVariableRef;
import ma.glasnost.orika.impl.generator.SourceCodeContext;
import ma.glasnost.orika.impl.generator.VariableRef;
import ma.glasnost.orika.impl.generator.specification.AbstractSpecification;
import ma.glasnost.orika.metadata.FieldMap;

public class ArrayOrCollectionToCollection
extends AbstractSpecification {
    public boolean appliesTo(FieldMap fieldMap) {
        return (fieldMap.getSource().isArray() || fieldMap.getSource().isCollection()) && fieldMap.getDestination().isCollection();
    }

    public String generateEqualityTestCode(FieldMap fieldMap, VariableRef source, VariableRef destination, SourceCodeContext code) {
        return "";
    }

    public String generateMappingCode(FieldMap fieldMap, VariableRef source, VariableRef destination, SourceCodeContext code) {
        StringBuilder out = new StringBuilder();
        MultiOccurrenceVariableRef s = MultiOccurrenceVariableRef.from(source);
        MultiOccurrenceVariableRef d = MultiOccurrenceVariableRef.from(destination);
        Class<?> dc = destination.getOwner().rawType();
        Type destinationElementClass = d.elementType().getRawType();
        if (destinationElementClass == null) {
            throw new MappingException("cannot determine runtime type of destination collection " + dc.getName() + "." + d.name());
        }
        out.append(s.ifNotNull() + " {\n");
        MultiOccurrenceVariableRef newDest = new MultiOccurrenceVariableRef(d.type(), "new_" + d.name());
        if (d.isAssignable()) {
            out.append(SourceCodeContext.statement(newDest.declare(d.newInstance(source.size()), new Object[0]), new Object[0]));
        } else {
            out.append(SourceCodeContext.statement(newDest.declare("" + d, new Object[0]), new Object[0]));
            out.append(SourceCodeContext.statement("%s.clear()", newDest));
        }
        if (s.isArray()) {
            if (code.isDebugEnabled()) {
                code.debug("mapping " + s.elementTypeName() + "[] to Collection<" + d.elementTypeName() + ">");
            }
            if (s.elementType().isPrimitive()) {
                out.append("\n");
                out.append(SourceCodeContext.statement("%s.addAll(asList(%s));", newDest, s));
            } else {
                out.append("\n");
                out.append(SourceCodeContext.statement("%s.addAll(mapperFacade.mapAsList(asList(%s), %s.class, mappingContext));", newDest, s, d.elementTypeName()));
            }
        } else {
            if (code.isDebugEnabled()) {
                code.debug("mapping Collection<" + s.elementTypeName() + "> to Collection<" + d.elementTypeName() + ">");
            }
            SourceCodeContext.append(out, "\n", String.format("%s.addAll(mapperFacade.mapAs%s(%s, %s, %s, mappingContext))", newDest, d.collectionType(), s, code.usedType(s.elementType()), code.usedType(d.elementType())));
        }
        if (fieldMap.getInverse() != null) {
            MultiOccurrenceVariableRef inverse = new MultiOccurrenceVariableRef(fieldMap.getInverse(), "orikaCollectionItem");
            if (fieldMap.getInverse().isCollection()) {
                SourceCodeContext.append(out, String.format("for (java.util.Iterator orikaIterator = %s.iterator(); orikaIterator.hasNext();) { ", newDest), String.format("    %s orikaCollectionItem = (%s) orikaIterator.next();", d.elementTypeName(), d.elementTypeName()), String.format("    %s { %s; }", inverse.ifNull(), inverse.assignIfPossible(inverse.newCollection(), new Object[0])), String.format("    %s.add(%s)", inverse, d.owner()), "}");
            } else if (fieldMap.getInverse().isArray()) {
                out.append(" // TODO support array");
            } else {
                SourceCodeContext.append(out, String.format("for (java.util.Iterator orikaIterator = %s.iterator(); orikaIterator.hasNext();) { ", newDest), String.format("    %s orikaCollectionItem = (%s) orikaIterator.next();", d.elementTypeName(), d.elementTypeName()), inverse.assign(d.owner(), new Object[0]), "}");
            }
        }
        if (d.isAssignable()) {
            out.append(SourceCodeContext.statement(d.assign(newDest), new Object[0]));
        }
        String mapNull = ArrayOrCollectionToCollection.shouldMapNulls(fieldMap, code) ? String.format(" else {\n %s;\n}", d.assignIfPossible("null", new Object[0])) : "";
        SourceCodeContext.append(out, "}" + mapNull);
        return out.toString();
    }
}

