/*
 * Decompiled with CFR 0.152.
 */
package ma.glasnost.orika.impl.generator.specification;

import ma.glasnost.orika.converter.builtin.CopyByReferenceConverter;
import ma.glasnost.orika.impl.generator.SourceCodeContext;
import ma.glasnost.orika.impl.generator.VariableRef;
import ma.glasnost.orika.impl.generator.specification.AbstractSpecification;
import ma.glasnost.orika.metadata.FieldMap;

public class Convert
extends AbstractSpecification {
    public boolean appliesTo(FieldMap fieldMap) {
        return fieldMap.getConverterId() != null || this.mapperFactory.getConverterFactory().canConvert(fieldMap.getAType(), fieldMap.getBType());
    }

    public String generateEqualityTestCode(FieldMap fieldMap, VariableRef source, VariableRef destination, SourceCodeContext code) {
        if (source.getConverter() instanceof CopyByReferenceConverter) {
            if (destination.type().isPrimitive() && source.type().isPrimitive()) {
                return String.format("(%s == %s)", destination, source);
            }
            if (destination.type().isPrimitive()) {
                return String.format("(%s != null && %s == %s.%Value())", source, destination, source, source.type().getPrimitiveType().getName());
            }
            if (source.type().isPrimitive()) {
                return String.format("(%s != null && %s.%Value == %s)", destination, destination, destination.type().getPrimitiveType().getName(), source);
            }
            return String.format("(%s != null && %s.equals(%s))", source, source, destination);
        }
        if (destination.type().isPrimitive()) {
            String wrapper = source.asWrapper();
            String primitive = source.type().getPrimitiveType().getName();
            return String.format("(%s == ((%s)%s.convert(%s, %s)).%Value())", destination, wrapper, code.usedConverter(source.getConverter()), wrapper, code.usedType(destination), primitive);
        }
        if (source.type().isPrimitive()) {
            return String.format("(%s == %s.convert(%s, %s))", destination.asWrapper(), code.usedConverter(source.getConverter()), source.asWrapper(), code.usedType(destination));
        }
        return String.format("(%s != null && %s.equals(%s.convert(%s, %s)))", source, destination, code.usedConverter(source.getConverter()), source.asWrapper(), code.usedType(destination));
    }

    public String generateMappingCode(FieldMap fieldMap, VariableRef source, VariableRef destination, SourceCodeContext code) {
        boolean shouldSetNull;
        if (code.isDebugEnabled()) {
            code.debug("converting using " + source.getConverter());
        }
        if (source.getConverter() instanceof CopyByReferenceConverter) {
            boolean shouldSetNull2;
            String statement = destination.assignIfPossible(source);
            boolean bl = shouldSetNull2 = Convert.shouldMapNulls(fieldMap, code) && !destination.isPrimitive();
            if (source.isPrimitive()) {
                return SourceCodeContext.statement(statement, new Object[0]);
            }
            String elseSetNull = shouldSetNull2 ? " else { \n" + destination.assignIfPossible("null", new Object[0]) + ";\n }" : "";
            return SourceCodeContext.statement(source.ifNotNull() + "{ \n" + statement, new Object[0]) + "\n}" + elseSetNull;
        }
        String statement = destination.assignIfPossible("%s.convert(%s, %s)", code.usedConverter(source.getConverter()), source.asWrapper(), code.usedType(destination));
        boolean bl = shouldSetNull = Convert.shouldMapNulls(fieldMap, code) && !destination.isPrimitive();
        if (source.isPrimitive()) {
            return SourceCodeContext.statement(statement, new Object[0]);
        }
        String elseSetNull = shouldSetNull ? " else { \n" + destination.assignIfPossible("null", new Object[0]) + ";\n }" : "";
        return SourceCodeContext.statement(source.ifNotNull() + "{ \n" + statement, new Object[0]) + "\n}" + elseSetNull;
    }
}

