/*
 * Decompiled with CFR 0.152.
 */
package ma.glasnost.orika.impl.generator.specification;

import ma.glasnost.orika.impl.generator.SourceCodeContext;
import ma.glasnost.orika.impl.generator.VariableRef;
import ma.glasnost.orika.impl.generator.specification.AbstractSpecification;
import ma.glasnost.orika.metadata.FieldMap;

public class EnumToEnum
extends AbstractSpecification {
    public boolean appliesTo(FieldMap fieldMap) {
        return fieldMap.getBType().isEnum() && fieldMap.getAType().isEnum();
    }

    public String generateEqualityTestCode(FieldMap fieldMap, VariableRef source, VariableRef destination, SourceCodeContext code) {
        return "(Enum.valueOf(%s.class, %s.name()) == " + destination + ")";
    }

    public String generateMappingCode(FieldMap fieldMap, VariableRef source, VariableRef destination, SourceCodeContext code) {
        if (code.isDebugEnabled()) {
            code.debug("converting enum " + source.typeName() + " to enum " + destination.typeName());
        }
        String assignEnum = destination.assign("Enum.valueOf(%s.class, %s.name())", destination.typeName(), source);
        String mapNull = EnumToEnum.shouldMapNulls(fieldMap, code) ? String.format(" else {\n %s;\n}", destination.assignIfPossible("null", new Object[0])) : "";
        return SourceCodeContext.statement("%s { %s; } %s", source.ifNotNull(), assignEnum, mapNull);
    }
}

