/*
 * Decompiled with CFR 0.152.
 */
package ma.glasnost.orika.impl.generator.specification;

import java.util.Map;
import ma.glasnost.orika.impl.generator.MapEntryRef;
import ma.glasnost.orika.impl.generator.MultiOccurrenceVariableRef;
import ma.glasnost.orika.impl.generator.SourceCodeContext;
import ma.glasnost.orika.impl.generator.VariableRef;
import ma.glasnost.orika.impl.generator.specification.AbstractSpecification;
import ma.glasnost.orika.impl.util.StringUtil;
import ma.glasnost.orika.metadata.FieldMap;
import ma.glasnost.orika.metadata.FieldMapBuilder;
import ma.glasnost.orika.metadata.TypeFactory;

public class MapToMap
extends AbstractSpecification {
    public boolean appliesTo(FieldMap fieldMap) {
        return fieldMap.getSource().isMap() && fieldMap.getDestination().isMap();
    }

    public String generateEqualityTestCode(FieldMap fieldMap, VariableRef source, VariableRef destination, SourceCodeContext code) {
        return source + " == " + destination;
    }

    public String generateMappingCode(FieldMap fieldMap, VariableRef source, VariableRef destination, SourceCodeContext code) {
        MultiOccurrenceVariableRef d = MultiOccurrenceVariableRef.from(destination);
        MultiOccurrenceVariableRef s = MultiOccurrenceVariableRef.from(source);
        StringBuilder out = new StringBuilder();
        out.append(s.ifNotNull());
        out.append("{\n");
        MultiOccurrenceVariableRef newDest = new MultiOccurrenceVariableRef(destination.type(), "new_" + destination.name());
        if (d.isAssignable()) {
            out.append(SourceCodeContext.statement(newDest.declare(d.newMap(), new Object[0]), new Object[0]));
        } else {
            out.append(SourceCodeContext.statement(newDest.declare(d), new Object[0]));
            out.append(SourceCodeContext.statement("%s.clear()", newDest));
        }
        if (d.mapKeyType().equals(s.mapKeyType()) && d.mapValueType().equals(s.mapValueType())) {
            out.append(SourceCodeContext.statement("%s.putAll(mapperFacade.mapAsMap(%s, %s, %s, mappingContext));", newDest, s, code.usedType(s.type()), code.usedType(d.type())));
        } else {
            VariableRef newKey = new VariableRef(d.mapKeyType(), "new" + StringUtil.capitalize(d.name()) + "Key");
            VariableRef newVal = new VariableRef(d.mapValueType(), "new" + StringUtil.capitalize(d.name()) + "Val");
            VariableRef entry = new VariableRef(TypeFactory.valueOf(Map.Entry.class), "source" + StringUtil.capitalize(d.name()) + "Entry");
            MapEntryRef sourceKey = new MapEntryRef(s.mapKeyType(), entry.name(), MapEntryRef.EntryPart.KEY);
            MapEntryRef sourceVal = new MapEntryRef(s.mapValueType(), entry.name(), MapEntryRef.EntryPart.VALUE);
            SourceCodeContext.append(out, String.format("for( java.util.Iterator entryIter = %s.entrySet().iterator(); entryIter.hasNext(); ) {\n", s), entry.declare("entryIter.next()", new Object[0]), newKey.declare(), newVal.declare(), code.mapFields(FieldMapBuilder.mapKeys(s.mapKeyType(), d.mapKeyType()), sourceKey, newKey, null, null), code.mapFields(FieldMapBuilder.mapValues(s.mapValueType(), d.mapValueType()), sourceVal, newVal, null, null), String.format("%s.put(%s, %s)", newDest, newKey, newVal), "\n", "}");
        }
        if (d.isAssignable()) {
            out.append(SourceCodeContext.statement(d.assign(newDest), new Object[0]));
        }
        String mapNull = MapToMap.shouldMapNulls(fieldMap, code) ? String.format(" else {\n %s;\n}", d.assignIfPossible("null", new Object[0])) : "";
        SourceCodeContext.append(out, "}" + mapNull);
        return out.toString();
    }
}

