/*
 * Decompiled with CFR 0.152.
 */
package ma.glasnost.orika.impl.generator.specification;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import ma.glasnost.orika.MapperFactory;
import ma.glasnost.orika.impl.generator.AggregateSpecification;
import ma.glasnost.orika.impl.generator.Node;
import ma.glasnost.orika.impl.generator.SourceCodeContext;
import ma.glasnost.orika.impl.generator.VariableRef;
import ma.glasnost.orika.impl.util.ClassUtil;
import ma.glasnost.orika.metadata.ClassMapBuilder;
import ma.glasnost.orika.metadata.FieldMap;
import ma.glasnost.orika.metadata.MapperKey;
import ma.glasnost.orika.metadata.Property;
import ma.glasnost.orika.metadata.Type;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MultiOccurrenceToMultiOccurrence
implements AggregateSpecification {
    protected MapperFactory mapperFactory;

    public String fromMultiOccurrenceToMultiOccurrence(List<FieldMap> fieldMappings, SourceCodeContext code) {
        StringBuilder out = new StringBuilder();
        while (!fieldMappings.isEmpty()) {
            Set<FieldMap> associated = code.getAssociatedMappings(fieldMappings, fieldMappings.get(0));
            fieldMappings.removeAll(associated);
            Node.NodeList sourceNodes = new Node.NodeList();
            Node.NodeList destNodes = new Node.NodeList();
            for (FieldMap map : associated) {
                Node.addFieldMap(map, sourceNodes, true);
                Node.addFieldMap(map, destNodes, false);
            }
            this.registerClassMaps(sourceNodes, destNodes);
            out.append(this.generateMultiOccurrenceMapping(sourceNodes, destNodes, associated, code));
        }
        return out.toString();
    }

    public String generateMultiOccurrenceMapping(Node.NodeList sourceNodes, Node.NodeList destNodes, Set<FieldMap> subFields, SourceCodeContext code) {
        StringBuilder out = new StringBuilder();
        ArrayList<String> sourceSizes = new ArrayList<String>();
        for (Node ref : sourceNodes) {
            if (ref.isLeaf()) continue;
            sourceSizes.add(ref.multiOccurrenceVar.size());
        }
        String sizeExpr = SourceCodeContext.join(sourceSizes, ", ");
        if (!"".equals(sizeExpr)) {
            sizeExpr = "min(new int[]{" + sizeExpr + "})";
        }
        for (Node destRef : destNodes) {
            if (destRef.isLeaf()) continue;
            out.append(SourceCodeContext.statement(destRef.newDestination.declare(destRef.newDestination.newInstance(sizeExpr), new Object[0]), new Object[0]));
            if (destRef.newDestination.isArray()) {
                out.append(SourceCodeContext.statement(destRef.newDestination.declareIterator(), new Object[0]));
            }
            ArrayList<Node> children = new ArrayList<Node>();
            children.add(destRef);
            while (!children.isEmpty()) {
                Node child = (Node)children.remove(0);
                children.addAll(child.children);
                if (child.elementRef == null) continue;
                out.append(SourceCodeContext.statement(child.elementRef.declare(), new Object[0]));
                if (child.multiOccurrenceVar.isArray()) {
                    out.append(SourceCodeContext.statement(child.multiOccurrenceVar.declareIterator(), new Object[0]));
                }
                if (child.elementRef.isPrimitive()) {
                    out.append(SourceCodeContext.statement(child.nullCheckFlag.declare("true", new Object[0]), new Object[0]));
                }
                out.append(SourceCodeContext.statement(child.shouldAddToCollectorFlag.declare("false", new Object[0]), new Object[0]));
            }
        }
        StringBuilder endWhiles = new StringBuilder();
        StringBuilder addLastElement = new StringBuilder();
        this.iterateSources(sourceNodes, destNodes, out, endWhiles);
        LinkedList<Node> stack = new LinkedList<Node>(destNodes);
        while (!stack.isEmpty()) {
            String assignNull;
            Node currentNode = stack.removeFirst();
            stack.addAll(0, currentNode.children);
            Node srcNode = null;
            if (currentNode.value != null) {
                srcNode = Node.findFieldMap(currentNode.value, sourceNodes, true);
            } else {
                FieldMap fieldMap = currentNode.getMap();
                if (fieldMap != null) {
                    srcNode = Node.findFieldMap((FieldMap)fieldMap, (Node.NodeList)sourceNodes, (boolean)true).parent;
                }
            }
            if (!currentNode.isLeaf() && srcNode != null) {
                String or;
                String currentElementNull = currentNode.elementRef.isPrimitive() ? currentNode.nullCheckFlag.toString() : currentNode.elementRef.isNull();
                String currentElementComparator = code.currentElementComparator(srcNode, currentNode, sourceNodes, destNodes);
                String string = or = !"".equals(currentElementNull) && !"".equals(currentElementComparator) ? " || " : "";
                if (this.mapperFactory.getConverterFactory().canConvert(srcNode.elementRef.type(), currentNode.elementRef.type()) || ClassUtil.isImmutable(currentNode.elementRef.type())) {
                    SourceCodeContext.append(out, currentNode.elementRef.isPrimitive() ? currentNode.nullCheckFlag.assign("false", new Object[0]) : "", currentNode.shouldAddToCollectorFlag.assign("true", new Object[0]));
                } else {
                    SourceCodeContext.append(out, "if ( " + currentElementNull + or + currentElementComparator + ") {\n", currentNode.elementRef.assign(code.newObject(srcNode.elementRef, currentNode.elementRef.type()), new Object[0]), currentNode.shouldAddToCollectorFlag.assign("true", new Object[0]), "}");
                }
            }
            if (currentNode.value == null) continue;
            boolean wasConverted = this.mapFields(currentNode, srcNode, out, code);
            if (currentNode.parent.addedToCollector) continue;
            String string = assignNull = currentNode.parent.elementRef.isPrimitive() ? currentNode.parent.nullCheckFlag.assign("true", new Object[0]) : currentNode.parent.elementRef.assign("null", new Object[0]);
            if (this.mapperFactory.getConverterFactory().canConvert(srcNode.parent.elementRef.type(), currentNode.parent.elementRef.type())) {
                SourceCodeContext.append(out, currentNode.parent.isRoot() ? currentNode.parent.newDestination.add(currentNode.parent.elementRef) : currentNode.parent.multiOccurrenceVar.add(currentNode.parent.elementRef), assignNull);
            } else {
                SourceCodeContext.append(out, String.format("if (%s) {", currentNode.parent.shouldAddToCollectorFlag), currentNode.parent.isRoot() ? currentNode.parent.newDestination.add(currentNode.parent.elementRef) : currentNode.parent.multiOccurrenceVar.add(currentNode.parent.elementRef), currentNode.parent.shouldAddToCollectorFlag.assign("false", new Object[0]), wasConverted ? assignNull : "", "}");
            }
            currentNode.parent.addedToCollector = true;
        }
        out.append(endWhiles.toString());
        out.append(addLastElement.toString());
        for (Node destRef : destNodes) {
            if (!destRef.isRoot() || destRef.isLeaf()) continue;
            if (destRef.multiOccurrenceVar.isArray() || destRef.multiOccurrenceVar.isMap()) {
                SourceCodeContext.append(out, String.format("if (%s && %s) {", destRef.newDestination.notNull(), destRef.newDestination.notEmpty()), destRef.multiOccurrenceVar.addAll(destRef.newDestination), "}\n");
                continue;
            }
            SourceCodeContext.append(out, String.format("if (%s && %s) {", destRef.newDestination.notNull(), destRef.newDestination.notEmpty()), String.format("if (%s) {", destRef.multiOccurrenceVar.isNull()), destRef.multiOccurrenceVar.assignIfPossible(destRef.multiOccurrenceVar.newInstance(sizeExpr), new Object[0]), "} else {\n", destRef.multiOccurrenceVar + ".clear()", "}\n", destRef.multiOccurrenceVar.addAll(destRef.newDestination), "}\n");
        }
        return out.toString();
    }

    private Property innermostElement(Property p) {
        Property result = p;
        while (result.getElement() != null) {
            result = result.getElement();
        }
        return result;
    }

    private boolean mapFields(Node currentNode, Node srcNode, StringBuilder out, SourceCodeContext code) {
        String srcName = srcNode.parent != null ? srcNode.parent.elementRef.name() : "source";
        Property sp = this.innermostElement(currentNode.value.getSource());
        Property srcProp = new Property.Builder().merge(sp).expression(this.innermostElement(currentNode.value.getSource()).getExpression()).build();
        VariableRef s = new VariableRef(srcProp, srcName);
        Property dp = this.innermostElement(currentNode.value.getDestination());
        Property dstProp = new Property.Builder().merge(dp).expression(this.innermostElement(currentNode.value.getDestination()).getExpression()).build();
        String dstName = "destination";
        if (currentNode.parent != null) {
            dstName = currentNode.parent.elementRef.name();
        }
        VariableRef d = new VariableRef(dstProp, dstName);
        Type<?> destType = currentNode.parent != null ? currentNode.parent.elementRef.type() : null;
        out.append(SourceCodeContext.statement(code.mapFields(currentNode.value, s, d, destType, null), new Object[0]));
        return d.type().equals(currentNode.parent.elementRef.type()) && this.mapperFactory.getConverterFactory().canConvert(s.type(), d.type());
    }

    private void registerClassMaps(Node.NodeList sourceNodes, Node.NodeList destNodes) {
        HashMap<MapperKey, ClassMapBuilder<Object, Object>> builders = new HashMap<MapperKey, ClassMapBuilder<Object, Object>>();
        LinkedList<Node> stack = new LinkedList<Node>(destNodes);
        while (!stack.isEmpty()) {
            MapperKey key;
            Node currentNode = stack.removeFirst();
            stack.addAll(0, currentNode.children);
            Node srcNode = null;
            if (currentNode.value != null) {
                srcNode = Node.findFieldMap(currentNode.value, sourceNodes, true);
            } else {
                FieldMap fieldMap = currentNode.getMap();
                if (fieldMap != null) {
                    srcNode = Node.findFieldMap((FieldMap)fieldMap, (Node.NodeList)sourceNodes, (boolean)true).parent;
                }
            }
            if (srcNode.parent == null || srcNode.parent.elementRef == null || currentNode.parent == null || currentNode.parent.elementRef == null || ClassUtil.isImmutable((key = new MapperKey(srcNode.parent.elementRef.type(), currentNode.parent.elementRef.type())).getAType()) || ClassUtil.isImmutable(key.getBType()) || this.mapperFactory.existsRegisteredMapper(key.getAType(), key.getBType(), true)) continue;
            ClassMapBuilder<Object, Object> builder = (ClassMapBuilder<Object, Object>)builders.get(key);
            if (builder == null) {
                builder = this.mapperFactory.classMap(key.getAType(), key.getBType());
                builders.put(key, builder);
            }
            Property sp = this.innermostElement(currentNode.value.getSource());
            Property dp = this.innermostElement(currentNode.value.getDestination());
            builder.fieldMap(sp.getExpression(), dp.getExpression()).add();
        }
        for (ClassMapBuilder builder : builders.values()) {
            builder.register();
        }
    }

    private void iterateSources(Node.NodeList sourceNodes, Node.NodeList destNodes, StringBuilder out, StringBuilder endWhiles) {
        if (!sourceNodes.isEmpty()) {
            for (Node srcRef : sourceNodes) {
                if (srcRef.isLeaf()) continue;
                out.append(SourceCodeContext.statement(srcRef.multiOccurrenceVar.declareIterator(), new Object[0]));
            }
            StringBuilder loopSource = new StringBuilder();
            loopSource.append("while (");
            Iterator sourcesIter = sourceNodes.iterator();
            boolean atLeastOneIter = false;
            while (sourcesIter.hasNext()) {
                Node ref = (Node)sourcesIter.next();
                if (ref.isLeaf()) continue;
                if (atLeastOneIter) {
                    loopSource.append(" && ");
                }
                loopSource.append(ref.multiOccurrenceVar.iteratorHasNext());
                atLeastOneIter = true;
            }
            loopSource.append(") {");
            if (atLeastOneIter) {
                out.append("\n");
                out.append(loopSource.toString());
            }
            for (Node srcRef : sourceNodes) {
                if (srcRef.isLeaf()) continue;
                out.append(SourceCodeContext.statement(srcRef.elementRef.declare(srcRef.multiOccurrenceVar.nextElement(), new Object[0]), new Object[0]));
                this.iterateSources(srcRef.children, destNodes, out, endWhiles);
            }
            if (atLeastOneIter) {
                endWhiles.append("}\n");
            }
        }
    }

    @Override
    public boolean appliesTo(FieldMap fieldMap) {
        return fieldMap.getSource().getContainer() != null || fieldMap.getDestination().getContainer() != null;
    }

    @Override
    public String generateMappingCode(List<FieldMap> fieldMappings, SourceCodeContext code) {
        return this.fromMultiOccurrenceToMultiOccurrence(fieldMappings, code);
    }

    @Override
    public void setMapperFactory(MapperFactory mapperFactory) {
        this.mapperFactory = mapperFactory;
    }
}

