/*
 * Decompiled with CFR 0.152.
 */
package ma.glasnost.orika.impl.generator.specification;

import ma.glasnost.orika.impl.generator.SourceCodeContext;
import ma.glasnost.orika.impl.generator.VariableRef;
import ma.glasnost.orika.impl.generator.specification.AbstractSpecification;
import ma.glasnost.orika.impl.util.ClassUtil;
import ma.glasnost.orika.metadata.FieldMap;

public class ObjectToMultiOccurrenceElement
extends AbstractSpecification {
    public boolean appliesTo(FieldMap fieldMap) {
        return (fieldMap.getDestination().isMapKey() || fieldMap.getDestination().isArrayElement() || fieldMap.getDestination().isListElement()) && (ClassUtil.isImmutable(fieldMap.getSource().getType()) || !fieldMap.getSource().isCollection() && !fieldMap.getSource().isArray() && !fieldMap.getSource().isMap() && !fieldMap.getSource().isEnum());
    }

    public String generateEqualityTestCode(FieldMap fieldMap, VariableRef source, VariableRef destination, SourceCodeContext code) {
        return source + " == " + destination;
    }

    public String generateMappingCode(FieldMap fieldMap, VariableRef source, VariableRef destination, SourceCodeContext code) {
        StringBuilder out = new StringBuilder();
        if (!source.isPrimitive()) {
            out.append(source.ifNotNull() + "{");
        }
        out.append(SourceCodeContext.statement(destination.assign(source), new Object[0]));
        if (!source.isPrimitive()) {
            out.append("}");
            if (ObjectToMultiOccurrenceElement.shouldMapNulls(fieldMap, code) && !destination.isPrimitive()) {
                SourceCodeContext.append(out, " else {\n", destination.assignIfPossible("null", new Object[0]), "}\n");
            }
        }
        return out.toString();
    }
}

