/*
 * Decompiled with CFR 0.152.
 */
package ma.glasnost.orika.impl.mapping.strategy;

import java.lang.reflect.Type;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class MappingStrategyKey {
    private final Class<?> rawSourceType;
    private final Type sourceType;
    private final Type destinationType;
    private final boolean destinationProvided;
    private final int hashCode;

    public MappingStrategyKey(Class<?> rawSourceType, Type sourceType, Type destinationType, boolean destinationProvided) {
        this.rawSourceType = rawSourceType;
        this.sourceType = sourceType;
        this.destinationType = destinationType;
        this.destinationProvided = destinationProvided;
        this.hashCode = this.computeHashCode();
    }

    protected Class<?> getRawSourceType() {
        return this.rawSourceType;
    }

    protected Type getSourceType() {
        return this.sourceType;
    }

    protected Type getDestinationType() {
        return this.destinationType;
    }

    protected boolean isDestinationProvided() {
        return this.destinationProvided;
    }

    public int hashCode() {
        return this.hashCode;
    }

    private int computeHashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.destinationProvided ? 1231 : 1237);
        result = 31 * result + (this.destinationType == null ? 0 : this.destinationType.hashCode());
        result = 31 * result + (this.rawSourceType == null ? 0 : this.rawSourceType.hashCode());
        result = 31 * result + (this.sourceType == null ? 0 : this.sourceType.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        MappingStrategyKey other = (MappingStrategyKey)obj;
        if (this.destinationProvided != other.destinationProvided) {
            return false;
        }
        if (this.getDestinationType() == null ? other.destinationType != null : !this.destinationType.equals(other.destinationType)) {
            return false;
        }
        if (this.getRawSourceType() == null ? other.rawSourceType != null : !this.rawSourceType.equals(other.rawSourceType)) {
            return false;
        }
        return !(this.getSourceType() == null ? other.sourceType != null : !this.sourceType.equals(other.sourceType));
    }

    public String toString() {
        return "[" + this.rawSourceType.getSimpleName() + ", " + this.sourceType + ", " + this.destinationType + "]";
    }
}

