/*
 * Decompiled with CFR 0.152.
 */
package ma.glasnost.orika.impl.mapping.strategy;

import ma.glasnost.orika.Converter;
import ma.glasnost.orika.Mapper;
import ma.glasnost.orika.ObjectFactory;
import ma.glasnost.orika.impl.ReversedMapper;
import ma.glasnost.orika.impl.mapping.strategy.CopyByReferenceStrategy;
import ma.glasnost.orika.impl.mapping.strategy.InstantiateAndUseCustomMapperStrategy;
import ma.glasnost.orika.impl.mapping.strategy.MapExistingAndUseCustomMapperStrategy;
import ma.glasnost.orika.impl.mapping.strategy.MappingStrategy;
import ma.glasnost.orika.impl.mapping.strategy.MappingStrategyKey;
import ma.glasnost.orika.impl.mapping.strategy.UseConverterStrategy;
import ma.glasnost.orika.metadata.Type;
import ma.glasnost.orika.unenhance.UnenhanceStrategy;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MappingStrategyRecorder {
    private boolean copyByReference;
    private boolean mapReverse;
    private boolean unenhance;
    private boolean instantiate;
    private Mapper<Object, Object> resolvedMapper;
    private ObjectFactory<Object> resolvedObjectFactory;
    private Converter<Object, Object> resolvedConverter;
    private Type<Object> resolvedSourceType;
    private Type<Object> resolvedDestinationType;
    private MappingStrategy resolvedStrategy;
    private final UnenhanceStrategy unenhanceStrategy;
    private final MappingStrategyKey key;

    public MappingStrategyRecorder(MappingStrategyKey key, UnenhanceStrategy unenhanceStrategy) {
        this.unenhanceStrategy = unenhanceStrategy;
        this.key = key;
    }

    public boolean isUnenhance() {
        return this.unenhance;
    }

    public boolean isInstantiate() {
        return this.instantiate;
    }

    public void setInstantiate(boolean instantiate) {
        this.instantiate = instantiate;
    }

    public void setUnenhance(boolean unenhance) {
        this.unenhance = unenhance;
    }

    public Converter<Object, Object> getResolvedConverter() {
        return this.resolvedConverter;
    }

    public void setResolvedConverter(Converter<Object, Object> resolvedConverter) {
        this.resolvedConverter = resolvedConverter;
    }

    public Type<?> getResolvedSourceType() {
        return this.resolvedSourceType;
    }

    public void setResolvedSourceType(Type<?> resolvedSourceType) {
        this.resolvedSourceType = resolvedSourceType;
    }

    public Type<?> getResolvedDestinationType() {
        return this.resolvedDestinationType;
    }

    public void setResolvedDestinationType(Type<?> resolvedDestinationType) {
        this.resolvedDestinationType = resolvedDestinationType;
    }

    public boolean isCopyByReference() {
        return this.copyByReference;
    }

    public void setCopyByReference(boolean copyByReference) {
        this.copyByReference = copyByReference;
    }

    public boolean isMapReverse() {
        return this.mapReverse;
    }

    public void setMapReverse(boolean mapReverse) {
        this.mapReverse = mapReverse;
    }

    public Mapper<Object, Object> getResolvedMapper() {
        return this.resolvedMapper;
    }

    public void setResolvedMapper(Mapper<Object, Object> resolvedMapper) {
        this.resolvedMapper = resolvedMapper;
    }

    public ObjectFactory<Object> getResolvedObjectFactory() {
        return this.resolvedObjectFactory;
    }

    public void setResolvedObjectFactory(ObjectFactory<?> resolvedObjectFactory) {
        this.resolvedObjectFactory = resolvedObjectFactory;
    }

    public MappingStrategy playback() {
        UnenhanceStrategy unenhanceStrategy = this.unenhance ? this.unenhanceStrategy : NoOpUnenhancer.getInstance();
        if (this.copyByReference) {
            this.resolvedStrategy = CopyByReferenceStrategy.getInstance();
        } else if (this.resolvedConverter != null) {
            this.resolvedStrategy = new UseConverterStrategy(this.resolvedSourceType, this.resolvedDestinationType, this.resolvedConverter, unenhanceStrategy);
        } else {
            if (this.mapReverse) {
                this.resolvedMapper = ReversedMapper.reverse(this.resolvedMapper);
            }
            this.resolvedStrategy = this.resolvedObjectFactory != null ? new InstantiateAndUseCustomMapperStrategy(this.resolvedSourceType, this.resolvedDestinationType, this.resolvedMapper, this.resolvedObjectFactory, unenhanceStrategy) : new MapExistingAndUseCustomMapperStrategy(this.resolvedSourceType, this.resolvedDestinationType, this.resolvedMapper, unenhanceStrategy);
        }
        return this.resolvedStrategy;
    }

    public String describeDetails() {
        if (this.resolvedStrategy == null) {
            throw new IllegalStateException("Strategy recording not complete");
        }
        StringBuilder details = new StringBuilder();
        details.append("MappingStrategy resolved and cached:").append("\n\tInputs:[ sourceClass: " + this.key.getRawSourceType().getCanonicalName()).append(", sourceType: " + this.key.getSourceType()).append(", destinationType: " + this.key.getDestinationType()).append("]\n\tResolved:[ strategy: " + this.resolvedStrategy.getClass().getSimpleName()).append(", sourceType: " + this.getResolvedSourceType()).append(", destinationType: " + this.getResolvedDestinationType());
        if (this.isCopyByReference()) {
            details.append(", copyByReference?: true");
        }
        if (this.getResolvedConverter() != null) {
            details.append(", converter: " + this.getResolvedConverter());
        }
        if (this.getResolvedMapper() != null) {
            details.append(", mapper: " + this.getResolvedMapper());
            details.append(", mapReverse?: " + this.mapReverse);
        }
        details.append("]");
        return details.toString();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class NoOpUnenhancer
    implements UnenhanceStrategy {
        private static final NoOpUnenhancer INSTANCE = new NoOpUnenhancer();

        NoOpUnenhancer() {
        }

        public static UnenhanceStrategy getInstance() {
            return INSTANCE;
        }

        @Override
        public <T> Type<T> unenhanceType(T object, Type<T> type) {
            throw new UnsupportedOperationException();
        }

        @Override
        public <T> T unenhanceObject(T object, Type<T> type) {
            return object;
        }
    }
}

