/*
 * Decompiled with CFR 0.152.
 */
package ma.glasnost.orika.impl.util;

import java.lang.reflect.Modifier;
import java.math.BigDecimal;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import ma.glasnost.orika.metadata.Type;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ClassUtil {
    private static final String CGLIB_ID = "$$EnhancerByCGLIB$$";
    private static final String JAVASSIST_PACKAGE = "org.javassist.tmp.";
    private static final String JAVASSIST_NAME = "_$$_javassist_";
    private static final Set<Class<?>> IMMUTABLES_TYPES = ClassUtil.getImmutablesTypes();
    private static final Set<Class<?>> PRIMITIVE_WRAPPER_TYPES = ClassUtil.getWrapperTypes();

    private ClassUtil() {
    }

    private static Set<Class<?>> getWrapperTypes() {
        return new HashSet(Arrays.asList(Byte.class, Short.class, Integer.class, Long.class, Boolean.class, Character.class, Float.class, Double.class));
    }

    private static Set<Class<?>> getImmutablesTypes() {
        HashSet immutables = new HashSet(Arrays.asList(String.class, BigDecimal.class, Byte.TYPE, Short.TYPE, Integer.TYPE, Long.TYPE, Boolean.TYPE, Character.TYPE, Float.TYPE, Double.TYPE));
        immutables.addAll(ClassUtil.getWrapperTypes());
        return immutables;
    }

    public static boolean isImmutable(Class<?> clazz) {
        return clazz.isPrimitive() || IMMUTABLES_TYPES.contains(clazz) || clazz.isEnum();
    }

    public static boolean isImmutable(Type<?> type) {
        return ClassUtil.isImmutable(type.getRawType());
    }

    public static boolean isConcrete(Class<?> type) {
        return !type.isInterface() && (type.isPrimitive() || type.isArray() || !Modifier.isAbstract(type.getModifiers()));
    }

    public static boolean isConcrete(Type<?> type) {
        return ClassUtil.isConcrete(type.getRawType());
    }

    public static boolean isPrimitiveWrapper(Class<?> type) {
        return PRIMITIVE_WRAPPER_TYPES.contains(type);
    }

    public static boolean isConvertibleFromString(Class<?> type) {
        if (type.isPrimitive()) {
            type = ClassUtil.getWrapperType(type);
        }
        try {
            type.getMethod("valueOf", String.class);
            return true;
        }
        catch (NoSuchMethodException e) {
            return false;
        }
        catch (SecurityException e) {
            return false;
        }
    }

    public static Class<?> getWrapperType(Class<?> primitiveType) {
        if (Boolean.TYPE.equals(primitiveType)) {
            return Boolean.class;
        }
        if (Byte.TYPE.equals(primitiveType)) {
            return Byte.class;
        }
        if (Character.TYPE.equals(primitiveType)) {
            return Character.class;
        }
        if (Short.TYPE.equals(primitiveType)) {
            return Short.class;
        }
        if (Integer.TYPE.equals(primitiveType)) {
            return Integer.class;
        }
        if (Long.TYPE.equals(primitiveType)) {
            return Long.class;
        }
        if (Float.TYPE.equals(primitiveType)) {
            return Float.class;
        }
        if (Double.TYPE.equals(primitiveType)) {
            return Double.class;
        }
        return null;
    }

    public static Class<?> getPrimitiveType(Class<?> wrapperType) {
        if (Boolean.class.equals(wrapperType)) {
            return Boolean.TYPE;
        }
        if (Byte.class.equals(wrapperType)) {
            return Byte.TYPE;
        }
        if (Character.class.equals(wrapperType)) {
            return Character.TYPE;
        }
        if (Short.class.equals(wrapperType)) {
            return Short.TYPE;
        }
        if (Integer.class.equals(wrapperType)) {
            return Integer.TYPE;
        }
        if (Long.class.equals(wrapperType)) {
            return Long.TYPE;
        }
        if (Float.class.equals(wrapperType)) {
            return Float.TYPE;
        }
        if (Double.class.equals(wrapperType)) {
            return Double.TYPE;
        }
        return null;
    }

    public static boolean isProxy(Class<?> clazz) {
        if (clazz.isInterface()) {
            return false;
        }
        String className = clazz.getName();
        return className.contains(CGLIB_ID) || className.startsWith(JAVASSIST_PACKAGE) || className.contains(JAVASSIST_NAME);
    }
}

