/*
 * Decompiled with CFR 0.152.
 */
package ma.glasnost.orika.inheritance;

import ma.glasnost.orika.inheritance.SuperTypeResolverStrategy;
import ma.glasnost.orika.metadata.Type;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class SuperTypeResolver {
    public static <T> Type<T> getSuperType(Type<?> enhancedClass, SuperTypeResolverStrategy strategy) {
        Type<?> mappedType = enhancedClass;
        if (strategy.shouldLookupSuperType(mappedType)) {
            Type<?> mappedSuper = SuperTypeResolver.tryFirstLookupOption(mappedType, strategy);
            if (mappedSuper != null) {
                mappedType = mappedSuper;
            } else {
                mappedSuper = SuperTypeResolver.trySecondLookupOption(mappedType, strategy);
                if (mappedSuper != null) {
                    mappedType = mappedSuper;
                }
            }
        }
        return mappedType;
    }

    private static Type<?> tryFirstLookupOption(Type<?> theClass, SuperTypeResolverStrategy strategy) {
        if (strategy.shouldPreferClassOverInterface()) {
            return SuperTypeResolver.lookupMappedSuperType(theClass, strategy);
        }
        return SuperTypeResolver.lookupMappedInterface(theClass, strategy);
    }

    private static Type<?> trySecondLookupOption(Type<?> theClass, SuperTypeResolverStrategy strategy) {
        if (strategy.shouldPreferClassOverInterface()) {
            return SuperTypeResolver.lookupMappedInterface(theClass, strategy);
        }
        return SuperTypeResolver.lookupMappedSuperType(theClass, strategy);
    }

    private static Type<?> lookupMappedSuperType(Type<?> type, SuperTypeResolverStrategy strategy) {
        Type<?> mappedType = null;
        for (Type<?> targetType = type.getSuperType(); mappedType == null && targetType != null && !targetType.getRawType().equals(Object.class); targetType = targetType.getSuperType()) {
            if (!strategy.accept(targetType)) continue;
            mappedType = targetType;
            break;
        }
        return mappedType;
    }

    private static Type<?> lookupMappedInterface(Type<?> type, SuperTypeResolverStrategy strategy) {
        Type<?> mappedType = null;
        block0: for (Type<?> targetType = type; mappedType == null && targetType != null && !targetType.getRawType().equals(Object.class); targetType = targetType.getSuperType()) {
            for (Type<?> theInterface : targetType.getInterfaces()) {
                if (!strategy.accept(theInterface)) continue;
                mappedType = theInterface;
                continue block0;
            }
        }
        return mappedType;
    }
}

