/*
 * Decompiled with CFR 0.152.
 */
package ma.glasnost.orika.metadata;

import java.util.HashMap;
import java.util.Map;
import ma.glasnost.orika.DefaultFieldMapper;
import ma.glasnost.orika.MapperFactory;
import ma.glasnost.orika.metadata.ClassMapBuilder;
import ma.glasnost.orika.metadata.ClassMapBuilderFactory;
import ma.glasnost.orika.metadata.Property;
import ma.glasnost.orika.metadata.Type;
import ma.glasnost.orika.property.PropertyResolverStrategy;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CaseInsensitiveClassMapBuilder<A, B>
extends ClassMapBuilder<A, B> {
    protected CaseInsensitiveClassMapBuilder(Type<A> aType, Type<B> bType, MapperFactory mapperFactory, PropertyResolverStrategy propertyResolver, DefaultFieldMapper[] defaults) {
        super(aType, bType, mapperFactory, propertyResolver, defaults);
    }

    @Override
    public ClassMapBuilder<A, B> byDefault(DefaultFieldMapper ... withDefaults) {
        super.byDefault(withDefaults);
        DefaultFieldMapper[] defaults = withDefaults.length == 0 ? this.getDefaultFieldMappers() : withDefaults;
        HashMap<String, String> propertiesForA = new HashMap<String, String>();
        for (String prop : this.getPropertiesForTypeA()) {
            propertiesForA.put(prop.toLowerCase(), prop);
        }
        HashMap<String, String> propertiesForB = new HashMap<String, String>();
        for (String string : this.getPropertiesForTypeB()) {
            propertiesForB.put(string.toLowerCase(), string);
        }
        for (Map.Entry entry : propertiesForA.entrySet()) {
            String propertyNameA = (String)entry.getValue();
            String lowercaseName = (String)entry.getKey();
            if (this.getMappedPropertiesForTypeA().contains(propertyNameA)) continue;
            if (propertiesForB.containsKey(lowercaseName)) {
                String propertyNameB = (String)propertiesForB.get(lowercaseName);
                if (this.getMappedPropertiesForTypeB().contains(propertyNameB) || propertyNameA.equals("class")) continue;
                this.fieldMap(propertyNameA, propertyNameB, true).add();
                continue;
            }
            Property prop = this.resolvePropertyForA(propertyNameA);
            for (DefaultFieldMapper defaulter : defaults) {
                String suggestion = defaulter.suggestMappedField(propertyNameA, prop.getType());
                if (suggestion == null || !this.getPropertiesForTypeB().contains(suggestion) || this.getMappedPropertiesForTypeB().contains(suggestion)) continue;
                this.fieldMap(propertyNameA, suggestion, true).add();
            }
        }
        return this;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Factory
    extends ClassMapBuilderFactory {
        @Override
        protected <A, B> ClassMapBuilder<A, B> newClassMapBuilder(Type<A> aType, Type<B> bType, MapperFactory mapperFactory, PropertyResolverStrategy propertyResolver, DefaultFieldMapper[] defaults) {
            return new CaseInsensitiveClassMapBuilder<A, B>(aType, bType, mapperFactory, propertyResolver, defaults);
        }
    }
}

