/*
 * Decompiled with CFR 0.152.
 */
package ma.glasnost.orika.metadata;

import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;
import ma.glasnost.orika.MappedTypePair;
import ma.glasnost.orika.Mapper;
import ma.glasnost.orika.metadata.FieldMap;
import ma.glasnost.orika.metadata.MapperKey;
import ma.glasnost.orika.metadata.Type;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClassMap<A, B>
implements MappedTypePair<A, B> {
    private final Type<A> aType;
    private final Type<B> bType;
    private final Set<FieldMap> fieldsMapping;
    private final Set<MapperKey> usedMappers;
    private final Mapper<A, B> customizedMapper;
    private final String[] constructorA;
    private final String[] constructorB;
    private final MapperKey mapperKey;
    private final Boolean sourcesMappedOnNull;
    private final Boolean destinationsMappedOnNull;

    public ClassMap(Type<A> aType, Type<B> bType, Set<FieldMap> fieldsMapping, Mapper<A, B> customizedMapper, Set<MapperKey> usedMappers, String[] constructorA, String[] constructorB, Boolean sourcesMappedOnNull, Boolean destinationsMappedOnNull) {
        this.aType = aType;
        this.bType = bType;
        this.customizedMapper = customizedMapper;
        this.fieldsMapping = Collections.unmodifiableSet(fieldsMapping);
        this.usedMappers = Collections.unmodifiableSet(usedMappers);
        this.mapperKey = new MapperKey(aType, bType);
        this.sourcesMappedOnNull = sourcesMappedOnNull;
        this.destinationsMappedOnNull = destinationsMappedOnNull;
        this.constructorA = constructorA != null ? (String[])constructorA.clone() : null;
        this.constructorB = constructorB != null ? (String[])constructorB.clone() : null;
    }

    public ClassMap<A, B> copy(Set<FieldMap> fieldsMapping) {
        LinkedHashSet<MapperKey> usedMappers = new LinkedHashSet<MapperKey>();
        usedMappers.addAll(this.usedMappers);
        String[] constructorA = this.constructorA == null ? null : (String[])this.constructorA.clone();
        String[] constructorB = this.constructorB == null ? null : (String[])this.constructorB.clone();
        return new ClassMap<A, B>(this.aType, this.bType, fieldsMapping, this.customizedMapper, usedMappers, constructorA, constructorB, this.sourcesMappedOnNull, this.destinationsMappedOnNull);
    }

    public MapperKey getMapperKey() {
        return this.mapperKey;
    }

    public void addFieldMap(FieldMap fieldMap) {
        this.fieldsMapping.add(fieldMap);
    }

    @Override
    public Type<A> getAType() {
        return this.aType;
    }

    @Override
    public Type<B> getBType() {
        return this.bType;
    }

    public Set<FieldMap> getFieldsMapping() {
        return this.fieldsMapping;
    }

    public String getATypeName() {
        return this.aType.getSimpleName();
    }

    public String getBTypeName() {
        return this.bType.getSimpleName();
    }

    public Mapper<A, B> getCustomizedMapper() {
        return this.customizedMapper;
    }

    public String getMapperClassName() {
        return "Orika_" + this.getBTypeName() + "_" + this.getATypeName() + "_Mapper";
    }

    public String[] getConstructorA() {
        return this.constructorA;
    }

    public String[] getConstructorB() {
        return this.constructorB;
    }

    public Boolean areSourcesMappedOnNull() {
        return this.sourcesMappedOnNull;
    }

    public Boolean areDestinationsMappedOnNull() {
        return this.destinationsMappedOnNull;
    }

    public int hashCode() {
        int result = 31;
        result += this.aType == null ? 0 : this.aType.hashCode();
        return result += this.bType == null ? 0 : this.bType.hashCode();
    }

    public Set<MapperKey> getUsedMappers() {
        return this.usedMappers;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "([A]:" + this.aType + ", [B]:" + this.bType + ")";
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ClassMap other = (ClassMap)obj;
        if (this.aType == null ? other.aType != null : !this.aType.equals(other.aType)) {
            return false;
        }
        return !(this.bType == null ? other.bType != null : !this.bType.equals(other.bType));
    }
}

