/*
 * Decompiled with CFR 0.152.
 */
package ma.glasnost.orika.metadata;

import ma.glasnost.orika.DefaultFieldMapper;
import ma.glasnost.orika.MapperFactory;
import ma.glasnost.orika.metadata.ClassMapBuilder;
import ma.glasnost.orika.metadata.ClassMapBuilderFactory;
import ma.glasnost.orika.metadata.ClassMapBuilderForMaps;
import ma.glasnost.orika.metadata.FieldMapBuilder;
import ma.glasnost.orika.metadata.ListElementProperty;
import ma.glasnost.orika.metadata.Property;
import ma.glasnost.orika.metadata.Type;
import ma.glasnost.orika.property.PropertyResolverStrategy;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClassMapBuilderForLists<A, B>
extends ClassMapBuilderForMaps<A, B> {
    private int currentIndex = 0;

    protected ClassMapBuilderForLists(Type<A> aType, Type<B> bType, MapperFactory mapperFactory, PropertyResolverStrategy propertyResolver, DefaultFieldMapper ... defaults) {
        super(aType, bType, mapperFactory, propertyResolver, defaults);
    }

    @Override
    protected ClassMapBuilderForLists<A, B> self() {
        return this;
    }

    @Override
    protected boolean isATypeBean() {
        return !this.getAType().isList();
    }

    @Override
    protected boolean isSpecialCaseType(Type<?> type) {
        return type.isList();
    }

    protected int resolveAndIncrementIndex(String expr) {
        int nextIndex;
        try {
            nextIndex = Integer.valueOf(expr.replaceAll("[\\[\\]]", ""));
        }
        catch (NumberFormatException e) {
            nextIndex = this.currentIndex + 1;
        }
        this.currentIndex = nextIndex;
        return nextIndex;
    }

    @Override
    public FieldMapBuilder<A, B> fieldMap(String fieldNameA, String fieldNameB, boolean byDefault) {
        if (this.isATypeBean()) {
            fieldNameB = "" + this.resolveAndIncrementIndex(fieldNameB);
        } else {
            fieldNameA = "" + this.resolveAndIncrementIndex(fieldNameA);
        }
        return super.fieldMap(fieldNameA, fieldNameB, byDefault);
    }

    @Override
    protected Property resolveCustomProperty(String expr, Type<?> propertyType) {
        int index = Integer.valueOf(expr.replaceAll("[\\[\\]]", ""));
        return new ListElementProperty(index, propertyType.getNestedType(0), null);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Factory
    extends ClassMapBuilderFactory {
        @Override
        protected <A, B> boolean applied(Type<A> aType, Type<B> bType) {
            return aType.isList() && !bType.isList() || bType.isList() && !aType.isList();
        }

        @Override
        protected <A, B> ClassMapBuilder<A, B> newClassMapBuilder(Type<A> aType, Type<B> bType, MapperFactory mapperFactory, PropertyResolverStrategy propertyResolver, DefaultFieldMapper[] defaults) {
            return new ClassMapBuilderForLists<A, B>(aType, bType, mapperFactory, propertyResolver, defaults);
        }
    }
}

