/*
 * Decompiled with CFR 0.152.
 */
package ma.glasnost.orika.metadata;

import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Set;
import ma.glasnost.orika.DefaultFieldMapper;
import ma.glasnost.orika.MapperFactory;
import ma.glasnost.orika.metadata.ClassMapBuilder;
import ma.glasnost.orika.metadata.ClassMapBuilderFactory;
import ma.glasnost.orika.metadata.FieldMapBuilder;
import ma.glasnost.orika.metadata.MapKeyProperty;
import ma.glasnost.orika.metadata.Property;
import ma.glasnost.orika.metadata.Type;
import ma.glasnost.orika.metadata.TypeFactory;
import ma.glasnost.orika.property.PropertyResolverStrategy;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClassMapBuilderForMaps<A, B>
extends ClassMapBuilder<A, B> {
    private final Set<String> nestedTypesUsed = new HashSet<String>();

    protected ClassMapBuilderForMaps(Type<A> aType, Type<B> bType, MapperFactory mapperFactory, PropertyResolverStrategy propertyResolver, DefaultFieldMapper ... defaults) {
        super(aType, bType, mapperFactory, propertyResolver, defaults);
    }

    protected ClassMapBuilderForMaps<A, B> self() {
        return this;
    }

    protected boolean isATypeBean() {
        return !this.getAType().isMap();
    }

    protected boolean isSpecialCaseType(Type<?> type) {
        return type.isMap();
    }

    @Override
    public ClassMapBuilderForMaps<A, B> byDefault(DefaultFieldMapper ... withDefaults) {
        LinkedHashSet<String> remainingProperties;
        if (this.isATypeBean()) {
            remainingProperties = new LinkedHashSet<String>(this.getPropertiesForTypeA());
            remainingProperties.removeAll(this.getMappedPropertiesForTypeA());
        } else {
            remainingProperties = new LinkedHashSet<String>(this.getPropertiesForTypeB());
            remainingProperties.removeAll(this.getMappedPropertiesForTypeB());
        }
        remainingProperties.remove("class");
        for (String propertyName : remainingProperties) {
            if (this.nestedTypesUsed.contains(propertyName)) continue;
            this.fieldMap(propertyName, propertyName, true).add();
        }
        return this.self();
    }

    protected String getParentExpression(String epxression) {
        String[] parts = epxression.split("[.]");
        StringBuilder name = new StringBuilder();
        for (int i = 0; i < parts.length - 1; ++i) {
            name.append(parts[i] + ".");
        }
        return name.substring(0, name.length() - 1);
    }

    @Override
    public FieldMapBuilder<A, B> fieldMap(String fieldNameA, String fieldNameB, boolean byDefault) {
        if (this.isATypeBean() && this.isNestedPropertyExpression(fieldNameA)) {
            this.nestedTypesUsed.add(this.getParentExpression(fieldNameA));
        } else if (!this.isATypeBean() && this.isNestedPropertyExpression(fieldNameB)) {
            this.nestedTypesUsed.add(this.getParentExpression(fieldNameB));
        }
        return super.fieldMap(fieldNameA, fieldNameB, byDefault);
    }

    @Override
    protected Property resolveProperty(java.lang.reflect.Type rawType, String expr) {
        Type type = TypeFactory.valueOf(rawType);
        if (this.isSpecialCaseType(type)) {
            Type<Object> propertyType = this.isSpecialCaseType(this.getBType()) ? this.getBType() : this.getAType();
            return this.resolveCustomProperty(expr, propertyType);
        }
        return super.resolveProperty(type, expr);
    }

    protected Property resolveCustomProperty(String expr, Type<?> propertyType) {
        return new MapKeyProperty(expr, propertyType.getNestedType(1), null);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Factory
    extends ClassMapBuilderFactory {
        @Override
        protected <A, B> boolean applied(Type<A> aType, Type<B> bType) {
            return aType.isMap() && !bType.isMap() || bType.isMap() && !aType.isMap();
        }

        @Override
        protected <A, B> ClassMapBuilder<A, B> newClassMapBuilder(Type<A> aType, Type<B> bType, MapperFactory mapperFactory, PropertyResolverStrategy propertyResolver, DefaultFieldMapper[] defaults) {
            return new ClassMapBuilderForMaps<A, B>(aType, bType, mapperFactory, propertyResolver, defaults);
        }
    }
}

