/*
 * Decompiled with CFR 0.152.
 */
package ma.glasnost.orika.metadata;

import ma.glasnost.orika.MappedTypePair;
import ma.glasnost.orika.impl.Specifications;
import ma.glasnost.orika.metadata.MappingDirection;
import ma.glasnost.orika.metadata.Property;
import ma.glasnost.orika.metadata.Type;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FieldMap
implements MappedTypePair<Object, Object> {
    private final Property source;
    private final Property destination;
    private final Property aInverse;
    private final Property bInverse;
    private final MappingDirection mappingDirection;
    private final boolean excluded;
    private final String converterId;
    private final boolean byDefault;
    private final String sourceExpression;
    private final String destinationExpression;
    private final Boolean sourceMappedOnNull;
    private final Boolean destinationMappedOnNull;

    public FieldMap(Property a, Property b, Property aInverse, Property bInverse, MappingDirection mappingDirection, boolean excluded, String converterId, boolean byDefault, Boolean sourceMappedOnNull, Boolean destinationMappedOnNull) {
        this.source = a;
        this.destination = b;
        this.aInverse = aInverse;
        this.bInverse = bInverse;
        this.mappingDirection = mappingDirection;
        this.converterId = converterId;
        this.excluded = excluded;
        this.byDefault = byDefault;
        this.sourceMappedOnNull = sourceMappedOnNull;
        this.destinationMappedOnNull = destinationMappedOnNull;
        this.sourceExpression = this.source.getExpression();
        this.destinationExpression = this.destination.getExpression();
    }

    public FieldMap copy() {
        return new FieldMap(this.copy(this.source), this.copy(this.destination), this.copy(this.aInverse), this.copy(this.bInverse), this.mappingDirection, this.excluded, this.converterId, this.byDefault, this.sourceMappedOnNull, this.destinationMappedOnNull);
    }

    private Property copy(Property property) {
        return property != null ? property.copy() : null;
    }

    public Property getSource() {
        return this.source;
    }

    public Property getDestination() {
        return this.destination;
    }

    @Override
    public Type<Object> getAType() {
        return this.getSource().getType();
    }

    @Override
    public Type<Object> getBType() {
        return this.getDestination().getType();
    }

    String getSourceName() {
        return this.source.getExpression();
    }

    String getDestinationName() {
        return this.destination.getExpression();
    }

    public String getSourceExpression() {
        return this.sourceExpression;
    }

    public String getDestinationExpression() {
        return this.destinationExpression;
    }

    public Boolean isSourceMappedOnNull() {
        return this.sourceMappedOnNull;
    }

    public Boolean isDestinationMappedOnNull() {
        return this.destinationMappedOnNull;
    }

    public Property getInverse() {
        return this.bInverse;
    }

    public boolean isIgnored() {
        return MappingDirection.B_TO_A == this.mappingDirection;
    }

    public FieldMap flip() {
        return new FieldMap(this.destination, this.source, this.bInverse, this.aInverse, this.mappingDirection.flip(), this.excluded, this.converterId, this.byDefault, this.destinationMappedOnNull, this.sourceMappedOnNull);
    }

    public boolean is(Specifications.Specification specification) {
        return specification.apply(this);
    }

    public boolean have(Specifications.Specification specification) {
        return specification.apply(this);
    }

    public String getConverterId() {
        return this.converterId;
    }

    public boolean isByDefault() {
        return this.byDefault;
    }

    public boolean isExcluded() {
        return this.excluded;
    }

    public String toString() {
        return "FieldMap [destination=" + this.getDestinationExpression() + ", source=" + this.getSourceExpression() + "]";
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.aInverse == null ? 0 : this.aInverse.hashCode());
        result = 31 * result + (this.bInverse == null ? 0 : this.bInverse.hashCode());
        result = 31 * result + (this.converterId == null ? 0 : this.converterId.hashCode());
        result = 31 * result + (this.destination == null ? 0 : this.destination.hashCode());
        result = 31 * result + (this.excluded ? 1231 : 1237);
        result = 31 * result + (this.mappingDirection == null ? 0 : this.mappingDirection.hashCode());
        result = 31 * result + (this.source == null ? 0 : this.source.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        FieldMap other = (FieldMap)obj;
        if (this.aInverse == null ? other.aInverse != null : !this.aInverse.equals(other.aInverse)) {
            return false;
        }
        if (this.bInverse == null ? other.bInverse != null : !this.bInverse.equals(other.bInverse)) {
            return false;
        }
        if (this.converterId == null ? other.converterId != null : !this.converterId.equals(other.converterId)) {
            return false;
        }
        if (this.destination == null ? other.destination != null : !this.destination.equals(other.destination)) {
            return false;
        }
        if (this.excluded != other.excluded) {
            return false;
        }
        if (this.mappingDirection != other.mappingDirection) {
            return false;
        }
        return !(this.source == null ? other.source != null : !this.source.equals(other.source));
    }
}

