/*
 * Decompiled with CFR 0.152.
 */
package ma.glasnost.orika.metadata;

import ma.glasnost.orika.metadata.ClassMapBuilder;
import ma.glasnost.orika.metadata.FieldMap;
import ma.glasnost.orika.metadata.MappingDirection;
import ma.glasnost.orika.metadata.Property;
import ma.glasnost.orika.metadata.Type;
import ma.glasnost.orika.metadata.TypeFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FieldMapBuilder<A, B> {
    private final ClassMapBuilder<A, B> classMapBuilder;
    private Property aProperty;
    private Property bProperty;
    private Property aInverseProperty;
    private Property bInverseProperty;
    private String converterId;
    private MappingDirection mappingDirection = MappingDirection.BIDIRECTIONAL;
    private boolean excluded;
    private boolean byDefault;
    private Boolean sourceMappedOnNull;
    private Boolean destinationMappedOnNull;

    FieldMapBuilder(ClassMapBuilder<A, B> classMapBuilder, String a, String b, boolean byDefault, Boolean sourceMappedOnNull, Boolean destinationMappedOnNull) {
        this(classMapBuilder, a, b, classMapBuilder.getAType(), classMapBuilder.getBType(), byDefault, sourceMappedOnNull, destinationMappedOnNull);
    }

    FieldMapBuilder(ClassMapBuilder<A, B> classMapBuilder, String a, String b, Type<?> aType, Type<?> bType, boolean byDefault, Boolean sourceMappedOnNull, Boolean destinationMappedOnNull) {
        this(classMapBuilder, classMapBuilder.resolveProperty(aType, a), classMapBuilder.resolveProperty(bType, b), byDefault, sourceMappedOnNull, destinationMappedOnNull);
    }

    FieldMapBuilder(ClassMapBuilder<A, B> classMapBuilder, Property a, Property b, boolean byDefault, Boolean sourceMappedOnNull, Boolean destinationMappedOnNull) {
        this.classMapBuilder = classMapBuilder;
        this.byDefault = byDefault;
        this.aProperty = a;
        this.bProperty = b;
        this.sourceMappedOnNull = sourceMappedOnNull;
        this.destinationMappedOnNull = destinationMappedOnNull;
    }

    String[] splitAtRootProperty(String propertyName) {
        String[] parts = propertyName.split("\\[", 2);
        if (parts.length > 1) {
            if (!parts[1].endsWith("]")) {
                throw new IllegalArgumentException("Property name '" + propertyName + "' is invalid");
            }
            parts[1] = parts[1].substring(0, parts[1].length() - 1);
        }
        return parts;
    }

    public ClassMapBuilder<A, B> add() {
        this.classMapBuilder.addFieldMap(this.toFieldMap());
        return this.classMapBuilder;
    }

    public FieldMapBuilder<A, B> aInverse(String aInverse) {
        Type<?> type = this.aProperty.isCollection() ? this.aProperty.getElementType() : this.aProperty.getType();
        this.aInverseProperty = this.classMapBuilder.resolveProperty(type, aInverse);
        return this;
    }

    public FieldMapBuilder<A, B> bInverse(String bInverse) {
        Type<?> type = this.bProperty.isCollection() ? this.bProperty.getElementType() : this.bProperty.getType();
        this.bInverseProperty = this.classMapBuilder.resolveProperty(type, bInverse);
        return this;
    }

    public FieldMapBuilder<A, B> mapNullsInReverse(boolean sourceMappedOnNull) {
        this.sourceMappedOnNull = sourceMappedOnNull;
        return this;
    }

    public FieldMapBuilder<A, B> mapNulls(boolean destinationMappedOnNull) {
        this.destinationMappedOnNull = destinationMappedOnNull;
        return this;
    }

    private FieldMap toFieldMap() {
        return new FieldMap(this.aProperty, this.bProperty, this.aInverseProperty, this.bInverseProperty, this.mappingDirection, this.excluded, this.converterId, this.byDefault, this.sourceMappedOnNull, this.destinationMappedOnNull);
    }

    public FieldMapBuilder<A, B> aToB() {
        this.mappingDirection = MappingDirection.A_TO_B;
        return this;
    }

    public FieldMapBuilder<A, B> bToA() {
        this.mappingDirection = MappingDirection.B_TO_A;
        return this;
    }

    public FieldMapBuilder<A, B> converter(String id) {
        this.converterId = id;
        return this;
    }

    public FieldMapBuilder<A, B> exclude() {
        this.excluded = true;
        return this;
    }

    public FieldMapBuilder<A, B> aElementType(Class<?> rawType) {
        return this.aElementType(TypeFactory.valueOf(rawType));
    }

    public FieldMapBuilder<A, B> aElementType(Type<?> elementType) {
        this.aProperty = new Property.Builder().merge(this.aProperty).elementType(elementType).build();
        return this;
    }

    public FieldMapBuilder<A, B> bElementType(Class<?> rawType) {
        return this.bElementType(TypeFactory.valueOf(rawType));
    }

    public FieldMapBuilder<A, B> bElementType(Type<?> elementType) {
        this.bProperty = new Property.Builder().merge(this.bProperty).elementType(elementType).build();
        return this;
    }

    public static FieldMap mapKeys(Type<?> aType, Type<?> bType) {
        Property aProperty = new Property.Builder().name("key").getter("getKey()").setter("setKey(%s)").type(aType).build(null);
        Property bProperty = aProperty.copy(bType);
        return new FieldMap(aProperty, bProperty, null, null, MappingDirection.A_TO_B, false, null, false, null, null);
    }

    public static FieldMap mapValues(Type<?> aType, Type<?> bType) {
        Property aProperty = new Property.Builder().name("value").getter("getValue()").setter("setValue(%s)").type(aType).build(null);
        Property bProperty = aProperty.copy(bType);
        return new FieldMap(aProperty, bProperty, null, null, MappingDirection.A_TO_B, false, null, false, null, null);
    }
}

