/*
 * Decompiled with CFR 0.152.
 */
package ma.glasnost.orika.util;

import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Map;
import jsr166x.ConcurrentSkipListMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SortedCollection<V>
implements Collection<V> {
    protected final Comparator<V> comparator;
    protected final ConcurrentSkipListMap<Double, V> sortedItems;

    public SortedCollection() {
        this((Comparator)null);
    }

    public SortedCollection(Comparator<V> comparator) {
        this.comparator = comparator;
        this.sortedItems = new ConcurrentSkipListMap();
    }

    public SortedCollection(Collection<? extends V> c) {
        this();
        this.addAll(c);
    }

    public SortedCollection(Collection<? extends V> c, Comparator<V> comparator) {
        this(comparator);
        this.addAll(c);
    }

    public SortedCollection<V> threadsafeCopy() {
        return new SortedCollection<V>(this);
    }

    @Override
    public boolean add(V value) {
        double index = 0.0;
        double nextIndex = 0.0;
        boolean insert = false;
        Object current = null;
        for (Map.Entry<Double, V> item : this.sortedItems.entrySet()) {
            int comparison;
            current = item.getValue();
            int n = comparison = this.comparator == null ? SortedCollection.toComparable(current).compareTo(value) : this.comparator.compare(current, value);
            if (comparison > 0) {
                insert = true;
                nextIndex = item.getKey();
                break;
            }
            index = item.getKey();
        }
        if (!insert) {
            nextIndex = index + 2.0;
        }
        return this.insertBetween(index, nextIndex, value, true);
    }

    protected boolean insertBetween(Double min, Double max, V value, boolean allowDuplicates) {
        double key = min + (max - min) / 2.0;
        V existing = this.sortedItems.putIfAbsent(key, value);
        while (existing != null) {
            int comparison;
            int n = comparison = this.comparator == null ? SortedCollection.toComparable(existing).compareTo(value) : this.comparator.compare(existing, value);
            if (comparison > 0) {
                key = min + (key - min) / 2.0;
            } else if (comparison < 0 || allowDuplicates || !existing.equals(value)) {
                key += (max - key) / 2.0;
            } else {
                return false;
            }
            existing = this.sortedItems.putIfAbsent(key, value);
        }
        return true;
    }

    @Override
    public int size() {
        return this.sortedItems.size();
    }

    @Override
    public boolean isEmpty() {
        return this.sortedItems.isEmpty();
    }

    protected static <V> Comparable<V> toComparable(V item) {
        return (Comparable)item;
    }

    @Override
    public Iterator<V> iterator() {
        return this.sortedItems.values().iterator();
    }

    @Override
    public boolean contains(Object o) {
        return this.sortedItems.containsValue(o);
    }

    @Override
    public Object[] toArray() {
        return this.sortedItems.values().toArray();
    }

    @Override
    public <T> T[] toArray(T[] a) {
        return this.sortedItems.values().toArray(a);
    }

    @Override
    public boolean remove(Object o) {
        return this.sortedItems.values().remove(o);
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        return this.sortedItems.values().containsAll(c);
    }

    @Override
    public boolean addAll(Collection<? extends V> c) {
        for (V value : c) {
            this.add(value);
        }
        return true;
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        return this.sortedItems.values().removeAll(c);
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        return this.sortedItems.values().retainAll(c);
    }

    @Override
    public void clear() {
        this.sortedItems.clear();
    }

    public V first() {
        Map.Entry<Double, V> entry = this.sortedItems.firstEntry();
        return entry != null ? (V)entry.getValue() : null;
    }

    public V last() {
        Map.Entry<Double, V> entry = this.sortedItems.lastEntry();
        return entry != null ? (V)entry.getValue() : null;
    }
}

