/*
 * Decompiled with CFR 0.152.
 */
package ma.glasnost.orika.constructor;

import com.thoughtworks.paranamer.AdaptiveParanamer;
import com.thoughtworks.paranamer.AnnotationParanamer;
import com.thoughtworks.paranamer.BytecodeReadingParanamer;
import com.thoughtworks.paranamer.CachingParanamer;
import com.thoughtworks.paranamer.ParameterNamesNotFoundException;
import com.thoughtworks.paranamer.Paranamer;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.TreeMap;
import ma.glasnost.orika.constructor.ConstructorResolverStrategy;
import ma.glasnost.orika.impl.Specifications;
import ma.glasnost.orika.metadata.ClassMap;
import ma.glasnost.orika.metadata.FieldMap;
import ma.glasnost.orika.metadata.MappingDirection;
import ma.glasnost.orika.metadata.Property;
import ma.glasnost.orika.metadata.Type;
import ma.glasnost.orika.metadata.TypeFactory;

public class SimpleConstructorResolverStrategy
implements ConstructorResolverStrategy {
    private Paranamer paranamer = new CachingParanamer((Paranamer)new AdaptiveParanamer(new Paranamer[]{new BytecodeReadingParanamer(), new AnnotationParanamer()}));

    @Override
    public <T, A, B> ConstructorResolverStrategy.ConstructorMapping<T> resolve(ClassMap<A, B> classMap, Type<T> sourceType) {
        boolean aToB = classMap.getBType().equals(sourceType);
        Type<Object> targetClass = aToB ? classMap.getBType() : classMap.getAType();
        Type<Object> sourceClass = aToB ? classMap.getAType() : classMap.getBType();
        Object[] declaredParameterNames = aToB ? classMap.getConstructorB() : classMap.getConstructorA();
        LinkedHashMap<String, FieldMap> targetParameters = new LinkedHashMap<String, FieldMap>();
        if (declaredParameterNames != null) {
            HashSet<FieldMap> fields = new HashSet<FieldMap>(classMap.getFieldsMapping());
            for (String string : declaredParameterNames) {
                Iterator iter = fields.iterator();
                while (iter.hasNext()) {
                    FieldMap fieldMap = (FieldMap)iter.next();
                    if (fieldMap.is(Specifications.aMappingOfTheRequiredClassProperty())) continue;
                    if (!aToB) {
                        fieldMap = fieldMap.flip();
                    }
                    if (!fieldMap.getDestination().getName().equals(string)) continue;
                    targetParameters.put(string, fieldMap);
                    iter.remove();
                }
            }
        } else {
            for (FieldMap fieldMap : classMap.getFieldsMapping()) {
                if (fieldMap.is(Specifications.aMappingOfTheRequiredClassProperty())) continue;
                if (!aToB) {
                    fieldMap = fieldMap.flip();
                }
                targetParameters.put(fieldMap.getDestination().getName(), fieldMap);
            }
        }
        boolean foundDeclaredConstructor = false;
        Constructor<?>[] constructors = ((Class)targetClass.getRawType()).getDeclaredConstructors();
        TreeMap constructorsByMatchedParams = new TreeMap();
        for (Constructor<?> constructor : constructors) {
            ConstructorResolverStrategy.ConstructorMapping constructorMapping = new ConstructorResolverStrategy.ConstructorMapping();
            constructorMapping.setDeclaredParameters((String[])declaredParameterNames);
            boolean byDefault = declaredParameterNames == null;
            try {
                Object[] parameterNames = this.paranamer.lookupParameterNames(constructor);
                if (Arrays.equals(parameterNames, declaredParameterNames)) {
                    foundDeclaredConstructor = true;
                }
                java.lang.reflect.Type[] genericParameterTypes = constructor.getGenericParameterTypes();
                Type[] parameterTypes = new Type[genericParameterTypes.length];
                constructorMapping.setParameterNameInfoAvailable(true);
                if (!targetParameters.keySet().containsAll(Arrays.asList(parameterNames))) continue;
                constructorMapping.setConstructor(constructor);
                for (int i = 0; i < parameterNames.length; ++i) {
                    Object parameterName = parameterNames[i];
                    parameterTypes[i] = TypeFactory.valueOf(genericParameterTypes[i]);
                    FieldMap existingField = (FieldMap)targetParameters.get(parameterName);
                    FieldMap argumentMap = this.mapConstructorArgument(existingField, parameterTypes[i], byDefault);
                    constructorMapping.getMappedFields().add(argumentMap);
                }
                constructorMapping.setParameterTypes(parameterTypes);
                constructorsByMatchedParams.put(parameterNames.length * 1000, constructorMapping);
            }
            catch (ParameterNamesNotFoundException e) {
                ArrayList targetTypes = new ArrayList(targetParameters.values());
                int matchScore = 0;
                int exactMatches = 0;
                java.lang.reflect.Type[] params = constructor.getGenericParameterTypes();
                Type[] parameterTypes = new Type[params.length];
                if (targetTypes.size() < parameterTypes.length) continue;
                block7: for (int i = 0; i < params.length; ++i) {
                    java.lang.reflect.Type param = params[i];
                    parameterTypes[i] = TypeFactory.valueOf(param);
                    Iterator iter = targetTypes.iterator();
                    while (iter.hasNext()) {
                        FieldMap fieldMap = (FieldMap)iter.next();
                        Type<?> targetType = fieldMap.getDestination().getType();
                        if ((!parameterTypes[i].equals(targetType) || ++exactMatches == 0) && !parameterTypes[i].isAssignableFrom(targetType)) continue;
                        ++matchScore;
                        String parameterName = fieldMap.getDestination().getName();
                        FieldMap existingField = (FieldMap)targetParameters.get(parameterName);
                        FieldMap argumentMap = this.mapConstructorArgument(existingField, parameterTypes[i], byDefault);
                        constructorMapping.getMappedFields().add(argumentMap);
                        iter.remove();
                        continue block7;
                    }
                }
                constructorMapping.setParameterTypes(parameterTypes);
                constructorMapping.setConstructor(constructor);
                constructorMapping.setDeclaredParameters((String[])declaredParameterNames);
                constructorsByMatchedParams.put(matchScore * 1000 + exactMatches, constructorMapping);
            }
        }
        if (constructorsByMatchedParams.size() > 0) {
            return (ConstructorResolverStrategy.ConstructorMapping)constructorsByMatchedParams.get(constructorsByMatchedParams.lastKey());
        }
        if (declaredParameterNames != null) {
            StringBuilder msg;
            if (foundDeclaredConstructor) {
                msg = new StringBuilder();
                msg.append("Declared constructor for ").append(targetClass).append("(");
                for (Object param : declaredParameterNames) {
                    msg.append('\"').append((String)param).append('\"').append(", ");
                }
                msg.setLength(msg.length() - 2);
                msg.append(")").append(" could not be matched to the source fields of ").append(sourceClass);
                throw new IllegalStateException(msg.toString());
            }
            msg = new StringBuilder();
            msg.append("No constructors found for ").append(targetClass).append(" matching the specified constructor parameters (");
            if (declaredParameterNames.length == 0) {
                for (Object param : declaredParameterNames) {
                    msg.append('\"').append((String)param).append('\"').append(", ");
                }
                msg.setLength(msg.length() - 1);
            } else {
                msg.append("<default constructor>");
            }
            msg.append(")").append(" could not be matched to the source fields of ").append(sourceClass);
            throw new IllegalArgumentException("No constructors found for " + targetClass + " matching the specified constructor parameters " + Arrays.toString(declaredParameterNames) + (declaredParameterNames.length == 0 ? " (no-arg constructor)" : ""));
        }
        ConstructorResolverStrategy.ConstructorMapping defaultMapping = new ConstructorResolverStrategy.ConstructorMapping();
        defaultMapping.setConstructor(constructors.length == 0 ? null : constructors[0]);
        return defaultMapping;
    }

    private FieldMap mapConstructorArgument(FieldMap existing, Type<?> argumentType, boolean byDefault) {
        Property destProp = new Property.Builder().name(existing.getDestination().getName()).getter(existing.getDestination().getName()).type(argumentType).build();
        FieldMap fieldMap = new FieldMap(existing.getSource(), destProp, null, null, MappingDirection.A_TO_B, false, existing.getConverterId(), byDefault, null, null);
        return fieldMap;
    }
}

