/*
 * Decompiled with CFR 0.152.
 */
package ma.glasnost.orika.impl.generator;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Map;
import java.util.Random;
import java.util.WeakHashMap;
import java.util.concurrent.ConcurrentHashMap;
import javassist.CannotCompileException;
import javassist.ClassClassPath;
import javassist.ClassPath;
import javassist.ClassPool;
import javassist.CtClass;
import javassist.CtField;
import javassist.CtNewMethod;
import javassist.LoaderClassPath;
import javassist.NotFoundException;
import ma.glasnost.orika.impl.generator.Analysis;
import ma.glasnost.orika.impl.generator.CompilerStrategy;
import ma.glasnost.orika.impl.generator.SourceCodeContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JavassistCompilerStrategy
extends CompilerStrategy {
    private static final Random RANDOM = new Random();
    private static final String WRITE_SOURCE_FILES_BY_DEFAULT = "false";
    private static final String WRITE_CLASS_FILES_BY_DEFAULT = "false";
    private static final Logger LOG = LoggerFactory.getLogger(JavassistCompilerStrategy.class);
    private static final Map<Class<?>, Boolean> superClasses = new ConcurrentHashMap(3);
    private ClassPool classPool;
    private WeakHashMap<ClassLoader, Boolean> referencedLoaders = new WeakHashMap(8);

    public JavassistCompilerStrategy() {
        super("false", "false");
        this.classPool = new ClassPool();
        this.classPool.appendSystemPath();
        this.classPool.insertClassPath((ClassPath)new ClassClassPath(this.getClass()));
    }

    protected void writeClassFile(SourceCodeContext sourceCode, CtClass byteCodeClass) throws IOException {
        if (this.writeClassFiles) {
            try {
                File parentDir = this.preparePackageOutputPath(this.pathToWriteClassFiles, "");
                byteCodeClass.writeFile(parentDir.getAbsolutePath());
            }
            catch (CannotCompileException e) {
                throw new IllegalArgumentException(e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void writeSourceFile(SourceCodeContext sourceCode) throws IOException {
        if (this.writeSourceFiles) {
            File parentDir = this.preparePackageOutputPath(this.pathToWriteSourceFiles, sourceCode.getPackageName());
            File sourceFile = new File(parentDir, sourceCode.getClassSimpleName() + ".java");
            if (!sourceFile.exists() && !sourceFile.createNewFile()) {
                throw new IOException("Could not write source file for " + sourceCode.getClassName());
            }
            FileWriter fw = null;
            try {
                fw = new FileWriter(sourceFile);
                fw.append(sourceCode.toSourceFile());
            }
            finally {
                if (fw != null) {
                    fw.close();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean registerClassLoader(ClassLoader cl) {
        Boolean found = this.referencedLoaders.get(cl);
        if (found == null) {
            ClassLoader classLoader = cl;
            synchronized (classLoader) {
                found = this.referencedLoaders.get(cl);
                if (found == null) {
                    this.referencedLoaders.put(cl, Boolean.TRUE);
                    this.classPool.insertClassPath((ClassPath)new LoaderClassPath(cl));
                }
            }
        }
        return found == null || found == false;
    }

    @Override
    public void assureTypeIsAccessible(Class<?> type) throws CompilerStrategy.SourceCodeGenerationException {
        if (!type.isPrimitive()) {
            Analysis.Visibility visibility = Analysis.getMostRestrictiveVisibility(type);
            if (visibility == Analysis.Visibility.PRIVATE) {
                throw new CompilerStrategy.SourceCodeGenerationException(type + " is not accessible");
            }
            String className = type.getName();
            if (type.isArray()) {
                className = type.getComponentType().getName();
            }
            if (type.getClassLoader() != null) {
                try {
                    this.classPool.get(className);
                }
                catch (NotFoundException e) {
                    if (this.registerClassLoader(type.getClassLoader())) {
                        try {
                            this.classPool.get(className);
                        }
                        catch (NotFoundException e2) {
                            throw new CompilerStrategy.SourceCodeGenerationException(type + " is not accessible", e2);
                        }
                    }
                    throw new CompilerStrategy.SourceCodeGenerationException(type + " is not accessible", e);
                }
            }
        }
    }

    @Override
    public Class<?> compileClass(SourceCodeContext sourceCode) throws CompilerStrategy.SourceCodeGenerationException {
        Class compiledClass;
        StringBuilder className = new StringBuilder(sourceCode.getClassName());
        CtClass byteCodeClass = null;
        int attempts = 0;
        Random rand = RANDOM;
        while (byteCodeClass == null) {
            try {
                byteCodeClass = this.classPool.makeClass(className.toString());
            }
            catch (RuntimeException e) {
                if (attempts < 5) {
                    className.append(Integer.toHexString(rand.nextInt()));
                    continue;
                }
                throw e;
            }
        }
        try {
            this.writeSourceFile(sourceCode);
            Boolean existing = superClasses.put(sourceCode.getSuperClass(), true);
            if (existing == null || !existing.booleanValue()) {
                this.classPool.insertClassPath((ClassPath)new ClassClassPath(sourceCode.getSuperClass()));
            }
            if (this.registerClassLoader(Thread.currentThread().getContextClassLoader())) {
                this.classPool.insertClassPath((ClassPath)new LoaderClassPath(Thread.currentThread().getContextClassLoader()));
            }
            CtClass abstractMapperClass = this.classPool.get(sourceCode.getSuperClass().getCanonicalName());
            byteCodeClass.setSuperclass(abstractMapperClass);
            for (String fieldDef : sourceCode.getFields()) {
                try {
                    byteCodeClass.addField(CtField.make((String)fieldDef, (CtClass)byteCodeClass));
                }
                catch (CannotCompileException e) {
                    LOG.error("An exception occured while compiling: " + fieldDef + " for " + sourceCode.getClassName(), (Throwable)e);
                    throw e;
                }
            }
            for (String methodDef : sourceCode.getMethods()) {
                try {
                    byteCodeClass.addMethod(CtNewMethod.make((String)methodDef, (CtClass)byteCodeClass));
                }
                catch (CannotCompileException e) {
                    LOG.error("An exception occured while compiling the following method:\n\n " + methodDef + "\n\n for " + sourceCode.getClassName() + "\n", (Throwable)e);
                    throw e;
                }
            }
            compiledClass = byteCodeClass.toClass(Thread.currentThread().getContextClassLoader(), this.getClass().getProtectionDomain());
            this.writeClassFile(sourceCode, byteCodeClass);
        }
        catch (NotFoundException e) {
            throw new CompilerStrategy.SourceCodeGenerationException(e);
        }
        catch (CannotCompileException e) {
            throw new CompilerStrategy.SourceCodeGenerationException("Error compiling " + sourceCode.getClassName(), e);
        }
        catch (IOException e) {
            throw new CompilerStrategy.SourceCodeGenerationException("Could not write files for " + sourceCode.getClassName(), e);
        }
        return compiledClass;
    }
}

