/*
 * Decompiled with CFR 0.152.
 */
package net.bytebuddy.implementation;

import java.lang.reflect.Field;
import net.bytebuddy.description.field.FieldDescription;
import net.bytebuddy.description.method.MethodDescription;
import net.bytebuddy.description.method.ParameterDescription;
import net.bytebuddy.description.type.TypeDescription;
import net.bytebuddy.dynamic.scaffold.FieldLocator;
import net.bytebuddy.dynamic.scaffold.InstrumentedType;
import net.bytebuddy.implementation.Implementation;
import net.bytebuddy.implementation.bytecode.ByteCodeAppender;
import net.bytebuddy.implementation.bytecode.StackManipulation;
import net.bytebuddy.implementation.bytecode.assign.Assigner;
import net.bytebuddy.implementation.bytecode.member.FieldAccess;
import net.bytebuddy.implementation.bytecode.member.MethodReturn;
import net.bytebuddy.implementation.bytecode.member.MethodVariableAccess;
import net.bytebuddy.jar.asm.MethodVisitor;

public abstract class FieldAccessor
implements Implementation {
    protected final FieldLocation fieldLocation;
    protected final Assigner assigner;
    protected final Assigner.Typing typing;

    protected FieldAccessor(FieldLocation fieldLocation, Assigner assigner, Assigner.Typing typing) {
        this.fieldLocation = fieldLocation;
        this.assigner = assigner;
        this.typing = typing;
    }

    public static OwnerTypeLocatable ofField(String name) {
        return FieldAccessor.of(new FieldNameExtractor.ForFixedValue(name));
    }

    public static OwnerTypeLocatable ofBeanProperty() {
        return FieldAccessor.of(FieldNameExtractor.ForBeanProperty.INSTANCE);
    }

    public static OwnerTypeLocatable of(FieldNameExtractor fieldNameExtractor) {
        return new ForImplicitProperty(new FieldLocation.Relative(fieldNameExtractor));
    }

    public static AssignerConfigurable of(Field field) {
        return FieldAccessor.of(new FieldDescription.ForLoadedField(field));
    }

    public static AssignerConfigurable of(FieldDescription fieldDescription) {
        return new ForImplicitProperty(new FieldLocation.Absolute(fieldDescription));
    }

    protected StackManipulation getter(FieldDescription fieldDescription, MethodDescription instrumentedMethod) {
        return this.access(fieldDescription, instrumentedMethod, new StackManipulation.Compound(FieldAccess.forField(fieldDescription).read(), this.assigner.assign(fieldDescription.getType(), instrumentedMethod.getReturnType(), this.typing)));
    }

    protected StackManipulation setter(FieldDescription fieldDescription, ParameterDescription parameterDescription) {
        if (fieldDescription.isFinal() && parameterDescription.getDeclaringMethod().isMethod()) {
            throw new IllegalArgumentException("Cannot set final field " + fieldDescription + " from " + parameterDescription.getDeclaringMethod());
        }
        return this.access(fieldDescription, parameterDescription.getDeclaringMethod(), new StackManipulation.Compound(MethodVariableAccess.load(parameterDescription), this.assigner.assign(parameterDescription.getType(), fieldDescription.getType(), this.typing), FieldAccess.forField(fieldDescription).write()));
    }

    private StackManipulation access(FieldDescription fieldDescription, MethodDescription instrumentedMethod, StackManipulation fieldAccess) {
        if (!fieldAccess.isValid()) {
            throw new IllegalStateException("Incompatible type of " + fieldDescription + " and " + instrumentedMethod);
        }
        if (instrumentedMethod.isStatic() && !fieldDescription.isStatic()) {
            throw new IllegalArgumentException("Cannot call instance field " + fieldDescription + " from static method " + instrumentedMethod);
        }
        return new StackManipulation.Compound(fieldDescription.isStatic() ? StackManipulation.Trivial.INSTANCE : MethodVariableAccess.loadThis(), fieldAccess);
    }

    @Override
    public InstrumentedType prepare(InstrumentedType instrumentedType) {
        return instrumentedType;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        FieldAccessor that = (FieldAccessor)object;
        return this.fieldLocation.equals(that.fieldLocation) && this.assigner.equals(that.assigner) && this.typing == that.typing;
    }

    public int hashCode() {
        int result = this.fieldLocation.hashCode();
        result = 31 * result + this.assigner.hashCode();
        result = 31 * result + this.typing.hashCode();
        return result;
    }

    protected static class ForParameterSetter
    extends FieldAccessor
    implements Implementation.Composable {
        private final int index;
        private final TerminationHandler terminationHandler;

        protected ForParameterSetter(FieldLocation fieldLocation, Assigner assigner, Assigner.Typing typing, int index) {
            this(fieldLocation, assigner, typing, index, TerminationHandler.RETURNING);
        }

        private ForParameterSetter(FieldLocation fieldLocation, Assigner assigner, Assigner.Typing typing, int index, TerminationHandler terminationHandler) {
            super(fieldLocation, assigner, typing);
            this.index = index;
            this.terminationHandler = terminationHandler;
        }

        @Override
        public ByteCodeAppender appender(Implementation.Target implementationTarget) {
            return new Appender(this.fieldLocation.prepare(implementationTarget.getInstrumentedType()));
        }

        @Override
        public Implementation andThen(Implementation implementation) {
            return new Implementation.Compound(new ForParameterSetter(this.fieldLocation, this.assigner, this.typing, this.index, TerminationHandler.NON_OPERATIONAL), implementation);
        }

        @Override
        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null || this.getClass() != object.getClass()) {
                return false;
            }
            if (!super.equals(object)) {
                return false;
            }
            ForParameterSetter that = (ForParameterSetter)object;
            return this.index == that.index && this.terminationHandler == that.terminationHandler;
        }

        @Override
        public int hashCode() {
            int result = super.hashCode();
            result = 31 * result + this.index;
            result = 31 * result + this.terminationHandler.hashCode();
            return result;
        }

        public String toString() {
            return "FieldAccessor.ForParameterSetter{fieldLocation=" + this.fieldLocation + ", assigner=" + this.assigner + ", typing=" + (Object)((Object)this.typing) + ", index=" + this.index + ", terminationHandler=" + (Object)((Object)this.terminationHandler) + "}";
        }

        protected class Appender
        implements ByteCodeAppender {
            private final FieldLocation.Prepared fieldLocation;

            protected Appender(FieldLocation.Prepared fieldLocation) {
                this.fieldLocation = fieldLocation;
            }

            @Override
            public ByteCodeAppender.Size apply(MethodVisitor methodVisitor, Implementation.Context implementationContext, MethodDescription instrumentedMethod) {
                if (instrumentedMethod.getParameters().size() <= ForParameterSetter.this.index) {
                    throw new IllegalStateException(instrumentedMethod + " does not define a parameter with index " + ForParameterSetter.this.index);
                }
                return new ByteCodeAppender.Size(new StackManipulation.Compound(ForParameterSetter.this.setter(this.fieldLocation.resolve(instrumentedMethod), (ParameterDescription)instrumentedMethod.getParameters().get(ForParameterSetter.this.index)), ForParameterSetter.this.terminationHandler.resolve(instrumentedMethod)).apply(methodVisitor, implementationContext).getMaximalSize(), instrumentedMethod.getStackSize());
            }

            private ForParameterSetter getOuter() {
                return ForParameterSetter.this;
            }

            public boolean equals(Object object) {
                if (this == object) {
                    return true;
                }
                if (object == null || this.getClass() != object.getClass()) {
                    return false;
                }
                Appender appender = (Appender)object;
                return this.fieldLocation.equals(appender.fieldLocation) && ForParameterSetter.this.equals(appender.getOuter());
            }

            public int hashCode() {
                return this.fieldLocation.hashCode() + 31 * ForParameterSetter.this.hashCode();
            }

            public String toString() {
                return "FieldAccessor.ForParameterSetter.Appender{outer=" + ForParameterSetter.this + ", fieldLocation=" + this.fieldLocation + '}';
            }
        }

        protected static enum TerminationHandler {
            RETURNING{

                @Override
                protected StackManipulation resolve(MethodDescription instrumentedMethod) {
                    if (!instrumentedMethod.getReturnType().represents(Void.TYPE)) {
                        throw new IllegalStateException("Cannot implement setter with return value for " + instrumentedMethod);
                    }
                    return MethodReturn.VOID;
                }
            }
            ,
            NON_OPERATIONAL{

                @Override
                protected StackManipulation resolve(MethodDescription instrumentedMethod) {
                    return StackManipulation.Trivial.INSTANCE;
                }
            };


            protected abstract StackManipulation resolve(MethodDescription var1);

            public String toString() {
                return "FieldAccessor.ForParameterSetter.TerminationHandler." + this.name();
            }
        }
    }

    protected static class ForImplicitProperty
    extends FieldAccessor
    implements OwnerTypeLocatable {
        protected ForImplicitProperty(FieldLocation fieldLocation) {
            this(fieldLocation, Assigner.DEFAULT, Assigner.Typing.STATIC);
        }

        private ForImplicitProperty(FieldLocation fieldLocation, Assigner assigner, Assigner.Typing typing) {
            super(fieldLocation, assigner, typing);
        }

        @Override
        public ByteCodeAppender appender(Implementation.Target implementationTarget) {
            return new Appender(this.fieldLocation.prepare(implementationTarget.getInstrumentedType()));
        }

        @Override
        public Implementation.Composable setsArgumentAt(int index) {
            if (index < 0) {
                throw new IllegalArgumentException("A parameter index cannot be negative: " + index);
            }
            return new ForParameterSetter(this.fieldLocation, this.assigner, this.typing, index);
        }

        @Override
        public PropertyConfigurable withAssigner(Assigner assigner, Assigner.Typing typing) {
            return new ForImplicitProperty(this.fieldLocation, assigner, typing);
        }

        @Override
        public AssignerConfigurable in(Class<?> type) {
            return this.in(new TypeDescription.ForLoadedType(type));
        }

        @Override
        public AssignerConfigurable in(TypeDescription typeDescription) {
            return this.in(new FieldLocator.ForExactType.Factory(typeDescription));
        }

        @Override
        public AssignerConfigurable in(FieldLocator.Factory fieldLocatorFactory) {
            return new ForImplicitProperty(this.fieldLocation.with(fieldLocatorFactory), this.assigner, this.typing);
        }

        public String toString() {
            return "FieldAccessor.ForImplicitProperty{fieldLocation=" + this.fieldLocation + ", assigner=" + this.assigner + ", typing=" + (Object)((Object)this.typing) + "}";
        }

        protected class Appender
        implements ByteCodeAppender {
            private final FieldLocation.Prepared fieldLocation;

            protected Appender(FieldLocation.Prepared fieldLocation) {
                this.fieldLocation = fieldLocation;
            }

            @Override
            public ByteCodeAppender.Size apply(MethodVisitor methodVisitor, Implementation.Context implementationContext, MethodDescription instrumentedMethod) {
                StackManipulation.Compound implementation;
                if (!instrumentedMethod.isMethod()) {
                    throw new IllegalArgumentException(instrumentedMethod + " does not describe a field getter or setter");
                }
                FieldDescription fieldDescription = this.fieldLocation.resolve(instrumentedMethod);
                if (!instrumentedMethod.getReturnType().represents(Void.TYPE)) {
                    implementation = new StackManipulation.Compound(ForImplicitProperty.this.getter(fieldDescription, instrumentedMethod), MethodReturn.of(instrumentedMethod.getReturnType()));
                } else if (instrumentedMethod.getReturnType().represents(Void.TYPE) && instrumentedMethod.getParameters().size() == 1) {
                    implementation = new StackManipulation.Compound(ForImplicitProperty.this.setter(fieldDescription, (ParameterDescription)instrumentedMethod.getParameters().get(0)), MethodReturn.VOID);
                } else {
                    throw new IllegalArgumentException("Method " + implementationContext + " is no bean property");
                }
                return new ByteCodeAppender.Size(implementation.apply(methodVisitor, implementationContext).getMaximalSize(), instrumentedMethod.getStackSize());
            }

            private ForImplicitProperty getOuter() {
                return ForImplicitProperty.this;
            }

            public boolean equals(Object object) {
                if (this == object) {
                    return true;
                }
                if (object == null || this.getClass() != object.getClass()) {
                    return false;
                }
                Appender appender = (Appender)object;
                return this.fieldLocation.equals(appender.fieldLocation) && ForImplicitProperty.this.equals(appender.getOuter());
            }

            public int hashCode() {
                return this.fieldLocation.hashCode() + 31 * ForImplicitProperty.this.hashCode();
            }

            public String toString() {
                return "FieldAccessor.ForImplicitProperty.Appender{outer=" + ForImplicitProperty.this + ", fieldLocation=" + this.fieldLocation + '}';
            }
        }
    }

    public static interface OwnerTypeLocatable
    extends AssignerConfigurable {
        public AssignerConfigurable in(Class<?> var1);

        public AssignerConfigurable in(TypeDescription var1);

        public AssignerConfigurable in(FieldLocator.Factory var1);
    }

    public static interface AssignerConfigurable
    extends PropertyConfigurable {
        public PropertyConfigurable withAssigner(Assigner var1, Assigner.Typing var2);
    }

    public static interface PropertyConfigurable
    extends Implementation {
        public Implementation.Composable setsArgumentAt(int var1);
    }

    public static interface FieldNameExtractor {
        public String resolve(MethodDescription var1);

        public static class ForFixedValue
        implements FieldNameExtractor {
            private final String name;

            protected ForFixedValue(String name) {
                this.name = name;
            }

            @Override
            public String resolve(MethodDescription methodDescription) {
                return this.name;
            }

            public boolean equals(Object object) {
                if (this == object) {
                    return true;
                }
                if (object == null || this.getClass() != object.getClass()) {
                    return false;
                }
                ForFixedValue that = (ForFixedValue)object;
                return this.name.equals(that.name);
            }

            public int hashCode() {
                return this.name.hashCode();
            }

            public String toString() {
                return "FieldAccessor.FieldNameExtractor.ForFixedValue{name='" + this.name + '\'' + '}';
            }
        }

        public static enum ForBeanProperty implements FieldNameExtractor
        {
            INSTANCE;


            @Override
            public String resolve(MethodDescription methodDescription) {
                int crop;
                String name = methodDescription.getInternalName();
                if (name.startsWith("get") || name.startsWith("set")) {
                    crop = 3;
                } else if (name.startsWith("is")) {
                    crop = 2;
                } else {
                    throw new IllegalArgumentException(methodDescription + " does not follow Java bean naming conventions");
                }
                name = name.substring(crop);
                if (name.length() == 0) {
                    throw new IllegalArgumentException(methodDescription + " does not specify a bean name");
                }
                return Character.toLowerCase(name.charAt(0)) + name.substring(1);
            }

            public String toString() {
                return "FieldAccessor.FieldNameExtractor.ForBeanProperty." + this.name();
            }
        }
    }

    protected static interface FieldLocation {
        public FieldLocation with(FieldLocator.Factory var1);

        public Prepared prepare(TypeDescription var1);

        public static class Relative
        implements FieldLocation {
            private final FieldNameExtractor fieldNameExtractor;
            private final FieldLocator.Factory fieldLocatorFactory;

            protected Relative(FieldNameExtractor fieldNameExtractor) {
                this(fieldNameExtractor, FieldLocator.ForClassHierarchy.Factory.INSTANCE);
            }

            private Relative(FieldNameExtractor fieldNameExtractor, FieldLocator.Factory fieldLocatorFactory) {
                this.fieldNameExtractor = fieldNameExtractor;
                this.fieldLocatorFactory = fieldLocatorFactory;
            }

            @Override
            public FieldLocation with(FieldLocator.Factory fieldLocatorFactory) {
                return new Relative(this.fieldNameExtractor, fieldLocatorFactory);
            }

            @Override
            public net.bytebuddy.implementation.FieldAccessor$FieldLocation$Prepared prepare(TypeDescription instrumentedType) {
                return new Prepared(this.fieldNameExtractor, this.fieldLocatorFactory.make(instrumentedType));
            }

            public boolean equals(Object object) {
                if (this == object) {
                    return true;
                }
                if (object == null || this.getClass() != object.getClass()) {
                    return false;
                }
                Relative relative = (Relative)object;
                return this.fieldNameExtractor.equals(relative.fieldNameExtractor) && this.fieldLocatorFactory.equals(relative.fieldLocatorFactory);
            }

            public int hashCode() {
                int result = this.fieldNameExtractor.hashCode();
                result = 31 * result + this.fieldLocatorFactory.hashCode();
                return result;
            }

            public String toString() {
                return "FieldAccessor.FieldLocation.Relative{fieldNameExtractor=" + this.fieldNameExtractor + ", fieldLocatorFactory=" + this.fieldLocatorFactory + '}';
            }

            protected static class Prepared
            implements net.bytebuddy.implementation.FieldAccessor$FieldLocation$Prepared {
                private final FieldNameExtractor fieldNameExtractor;
                private final FieldLocator fieldLocator;

                protected Prepared(FieldNameExtractor fieldNameExtractor, FieldLocator fieldLocator) {
                    this.fieldNameExtractor = fieldNameExtractor;
                    this.fieldLocator = fieldLocator;
                }

                @Override
                public FieldDescription resolve(MethodDescription instrumentedMethod) {
                    FieldLocator.Resolution resolution = this.fieldLocator.locate(this.fieldNameExtractor.resolve(instrumentedMethod));
                    if (!resolution.isResolved()) {
                        throw new IllegalStateException("Cannot resolve field for " + instrumentedMethod + " using " + this.fieldLocator);
                    }
                    return resolution.getField();
                }

                public boolean equals(Object object) {
                    if (this == object) {
                        return true;
                    }
                    if (object == null || this.getClass() != object.getClass()) {
                        return false;
                    }
                    Prepared prepared = (Prepared)object;
                    return this.fieldNameExtractor.equals(prepared.fieldNameExtractor) && this.fieldLocator.equals(prepared.fieldLocator);
                }

                public int hashCode() {
                    int result = this.fieldNameExtractor.hashCode();
                    result = 31 * result + this.fieldLocator.hashCode();
                    return result;
                }

                public String toString() {
                    return "FieldAccessor.FieldLocation.Relative.Prepared{fieldNameExtractor=" + this.fieldNameExtractor + ", fieldLocator=" + this.fieldLocator + '}';
                }
            }
        }

        public static class Absolute
        implements FieldLocation,
        Prepared {
            private final FieldDescription fieldDescription;

            protected Absolute(FieldDescription fieldDescription) {
                this.fieldDescription = fieldDescription;
            }

            @Override
            public FieldLocation with(FieldLocator.Factory fieldLocatorFactory) {
                throw new IllegalStateException("Cannot specify a field locator factory for an absolute field location");
            }

            @Override
            public Prepared prepare(TypeDescription instrumentedType) {
                if (!instrumentedType.isAssignableTo(this.fieldDescription.getDeclaringType().asErasure())) {
                    throw new IllegalStateException(this.fieldDescription + " is not declared by " + instrumentedType);
                }
                if (!this.fieldDescription.isVisibleTo(instrumentedType)) {
                    throw new IllegalStateException("Cannot access " + this.fieldDescription + " from " + instrumentedType);
                }
                return this;
            }

            @Override
            public FieldDescription resolve(MethodDescription instrumentedMethod) {
                return this.fieldDescription;
            }

            public boolean equals(Object object) {
                if (this == object) {
                    return true;
                }
                if (object == null || this.getClass() != object.getClass()) {
                    return false;
                }
                Absolute absolute = (Absolute)object;
                return this.fieldDescription.equals(absolute.fieldDescription);
            }

            public int hashCode() {
                return this.fieldDescription.hashCode();
            }

            public String toString() {
                return "FieldAccessor.FieldLocation.Absolute{fieldDescription=" + this.fieldDescription + '}';
            }
        }

        public static interface Prepared {
            public FieldDescription resolve(MethodDescription var1);
        }
    }
}

