/*
 * Decompiled with CFR 0.152.
 */
package com.gitee.fastmybatis.core.ext;

import com.gitee.fastmybatis.core.FastmybatisConfig;
import com.gitee.fastmybatis.core.FastmybatisContext;
import com.gitee.fastmybatis.core.ext.HotDeploy;
import com.gitee.fastmybatis.core.ext.MapperLocationsBuilder;
import com.gitee.fastmybatis.core.ext.MyBatisResource;
import com.gitee.fastmybatis.core.util.DbUtil;
import com.gitee.fastmybatis.core.util.IOUtil;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Objects;
import javax.sql.DataSource;
import org.apache.ibatis.session.SqlSessionFactory;
import org.mybatis.spring.SqlSessionFactoryBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.core.io.ByteArrayResource;
import org.springframework.core.io.InputStreamResource;
import org.springframework.core.io.Resource;
import org.springframework.util.Assert;

public class SqlSessionFactoryBeanExt
extends SqlSessionFactoryBean {
    private final MapperLocationsBuilder mapperLocationsBuilder = new MapperLocationsBuilder();
    private Resource[] mapperLocations;
    private Resource[] finalMapperLocations;
    private volatile SqlSessionFactory sqlSessionFactory;
    private String basePackage;
    private String dialect;

    @Autowired
    public void setApplicationContext(ApplicationContext applicationContext) {
        FastmybatisContext.setApplicationContext((Object)applicationContext);
    }

    public void setDataSource(DataSource dataSource) {
        super.setDataSource(dataSource);
        this.dialect = DbUtil.getDialect((DataSource)dataSource);
    }

    public void setMapperLocations(Resource[] mapperLocations) {
        this.mapperLocations = mapperLocations;
    }

    protected SqlSessionFactory buildSqlSessionFactory() throws Exception {
        ArrayList<MyBatisResource> myBatisResources;
        Assert.notNull((Object)this.basePackage, (String)"\u5c5e\u6027 'basePackage' \u5fc5\u586b");
        if (this.mapperLocations != null) {
            myBatisResources = new ArrayList(this.mapperLocations.length);
            for (Resource mapperLocation : this.mapperLocations) {
                MyBatisResource myBatisResource = new MyBatisResource();
                myBatisResource.setFilename(mapperLocation.getFilename());
                myBatisResource.setContent(IOUtil.toString((InputStream)mapperLocation.getInputStream(), (Charset)StandardCharsets.UTF_8));
                myBatisResources.add(myBatisResource);
            }
        } else {
            myBatisResources = new ArrayList<MyBatisResource>();
        }
        MyBatisResource[] allMyBatisResource = this.mapperLocationsBuilder.build(this.basePackage, myBatisResources, this.dialect);
        this.finalMapperLocations = this.convertResources(allMyBatisResource);
        super.setMapperLocations(this.finalMapperLocations);
        this.sqlSessionFactory = super.buildSqlSessionFactory();
        return this.sqlSessionFactory;
    }

    private Resource[] convertResources(MyBatisResource[] allMyBatisResource) {
        Resource[] resources = new Resource[allMyBatisResource.length];
        for (int i = 0; i < allMyBatisResource.length; ++i) {
            MyBatisResource myBatisResource = allMyBatisResource[i];
            InputStreamResource inputStreamResource = new InputStreamResource(myBatisResource.getInputStream(), myBatisResource.toString());
            resources[i] = inputStreamResource;
        }
        return resources;
    }

    public void afterPropertiesSet() throws Exception {
        super.afterPropertiesSet();
        new HotDeploy(this).start();
    }

    public void setBasePackage(String basePackage) {
        this.basePackage = basePackage;
    }

    public void setConfig(FastmybatisConfig config) {
        this.mapperLocationsBuilder.setConfig(config);
    }

    public FastmybatisConfig getConfig() {
        return this.mapperLocationsBuilder.getConfig();
    }

    public Resource[] getMapperLocations() {
        return this.mapperLocations;
    }

    public Resource[] getFinalMapperLocations() {
        return this.finalMapperLocations;
    }

    public SqlSessionFactory getSqlSessionFactory() {
        return this.sqlSessionFactory;
    }

    private static class MapperResource
    extends ByteArrayResource {
        private final String filename;

        public MapperResource(String xml, String filename) {
            super(xml.getBytes(StandardCharsets.UTF_8), filename);
            this.filename = filename;
        }

        public String getFilename() {
            return this.filename;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            MapperResource that = (MapperResource)((Object)o);
            return Objects.equals(this.filename, that.filename);
        }

        public int hashCode() {
            return Objects.hash(super.hashCode(), this.filename);
        }
    }
}

