/*
 * Decompiled with CFR 0.152.
 */
package com.gitee.fastmybatis.core.ext.spi.impl;

import com.gitee.fastmybatis.core.ext.spi.ClassSearch;
import com.gitee.fastmybatis.core.mapper.Mapper;
import java.io.IOException;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceLoader;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;
import org.springframework.core.io.support.ResourcePatternResolver;
import org.springframework.core.type.classreading.CachingMetadataReaderFactory;
import org.springframework.core.type.classreading.MetadataReader;
import org.springframework.core.type.classreading.MetadataReaderFactory;
import org.springframework.core.type.filter.AnnotationTypeFilter;
import org.springframework.core.type.filter.AssignableTypeFilter;
import org.springframework.core.type.filter.TypeFilter;
import org.springframework.util.ClassUtils;

public class SpringClassSearch
implements ClassSearch {
    private static final String RESOURCE_PATTERN = "/**/*.class";
    private final ResourcePatternResolver resourcePatternResolver = new PathMatchingResourcePatternResolver();

    public Set<Class<?>> search(Class<?> targetClass, String ... packageName) throws Exception {
        LinkedList<TypeFilter> typeIncludes = new LinkedList<TypeFilter>();
        typeIncludes.add((TypeFilter)new AnnotationTypeFilter(org.apache.ibatis.annotations.Mapper.class, false));
        typeIncludes.add((TypeFilter)new AssignableTypeFilter(Mapper.class));
        HashSet classSet = new HashSet();
        if (packageName != null) {
            for (String pkg : packageName) {
                String pattern = "classpath*:" + ClassUtils.convertClassNameToResourcePath((String)pkg) + RESOURCE_PATTERN;
                Resource[] resources = this.resourcePatternResolver.getResources(pattern);
                CachingMetadataReaderFactory readerFactory = new CachingMetadataReaderFactory((ResourceLoader)this.resourcePatternResolver);
                for (Resource resource : resources) {
                    MetadataReader reader;
                    if (!resource.isReadable() || !this.matchesEntityTypeFilter(reader = readerFactory.getMetadataReader(resource), (MetadataReaderFactory)readerFactory, typeIncludes)) continue;
                    String className = reader.getClassMetadata().getClassName();
                    classSet.add(Class.forName(className));
                }
            }
        }
        return classSet;
    }

    private boolean matchesEntityTypeFilter(MetadataReader reader, MetadataReaderFactory readerFactory, List<TypeFilter> typeIncludes) throws IOException {
        for (TypeFilter filter : typeIncludes) {
            if (!filter.match(reader, readerFactory)) continue;
            return true;
        }
        return false;
    }
}

