/*
 * Decompiled with CFR 0.152.
 */
package net.sf.json;

import java.io.IOException;
import java.io.Writer;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.sf.json.JSON;
import net.sf.json.JSONException;
import net.sf.json.JSONFunction;
import net.sf.json.JSONNull;
import net.sf.json.JSONObject;
import net.sf.json.JSONSerializer;
import net.sf.json.JSONString;
import net.sf.json.util.JSONTokener;
import net.sf.json.util.JSONUtils;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;

public final class JSONArray
implements JSON {
    private List elements = new ArrayList();
    private boolean expandElements;
    static /* synthetic */ Class class$java$lang$Object;
    static /* synthetic */ Class class$net$sf$json$JSONArray;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$lang$Boolean;
    static /* synthetic */ Class class$java$lang$Character;
    static /* synthetic */ Class class$net$sf$json$JSONFunction;
    static /* synthetic */ Class class$java$lang$Class;

    public static JSONArray fromArray(Object[] array) {
        return JSONArray.fromArray(array, null, false);
    }

    public static JSONArray fromArray(Object[] array, String[] excludes) {
        return JSONArray.fromArray(array, excludes, false);
    }

    public static JSONArray fromArray(Object[] array, String[] excludes, boolean ignoreDefaultExcludes) {
        return new JSONArray(array, excludes, ignoreDefaultExcludes);
    }

    public static JSONArray fromCollection(Collection collection) {
        return JSONArray.fromCollection(collection, null, false);
    }

    public static JSONArray fromCollection(Collection collection, String[] excludes) {
        return JSONArray.fromCollection(collection, excludes, false);
    }

    public static JSONArray fromCollection(Collection collection, String[] excludes, boolean ignoreDefaultExcludes) {
        return new JSONArray(collection, excludes, ignoreDefaultExcludes);
    }

    public static JSONArray fromJSONString(JSONString string) {
        return JSONArray.fromJSONString(string, null, false);
    }

    public static JSONArray fromJSONString(JSONString string, String[] excludes) {
        return JSONArray.fromJSONString(string, excludes, false);
    }

    public static JSONArray fromJSONString(JSONString string, String[] excludes, boolean ignoreDefaultExcludes) {
        return JSONArray.fromJSONTokener(new JSONTokener(string.toJSONString()), excludes, ignoreDefaultExcludes);
    }

    public static JSONArray fromObject(Object object) {
        return JSONArray.fromObject(object, null, false);
    }

    public static JSONArray fromObject(Object object, String[] excludes) {
        return JSONArray.fromObject(object, excludes, false);
    }

    public static JSONArray fromObject(Object object, String[] excludes, boolean ignoreDefaultExcludes) {
        if (object instanceof JSONString) {
            return JSONArray.fromJSONString((JSONString)object, excludes, ignoreDefaultExcludes);
        }
        if (object instanceof Collection) {
            return JSONArray.fromCollection((Collection)object, excludes, ignoreDefaultExcludes);
        }
        if (object instanceof JSONArray) {
            return new JSONArray((JSONArray)object);
        }
        if (object instanceof JSONTokener) {
            return JSONArray.fromJSONTokener((JSONTokener)object, excludes, ignoreDefaultExcludes);
        }
        if (object instanceof String) {
            return JSONArray.fromString((String)object, excludes, ignoreDefaultExcludes);
        }
        if (object != null && object.getClass().isArray()) {
            Class<?> type = object.getClass().getComponentType();
            if (!type.isPrimitive()) {
                return JSONArray.fromArray((Object[])object, excludes, ignoreDefaultExcludes);
            }
            if (type == Boolean.TYPE) {
                return new JSONArray((boolean[])object);
            }
            if (type == Byte.TYPE) {
                return new JSONArray((byte[])object);
            }
            if (type == Short.TYPE) {
                return new JSONArray((short[])object);
            }
            if (type == Integer.TYPE) {
                return new JSONArray((int[])object);
            }
            if (type == Long.TYPE) {
                return new JSONArray((long[])object);
            }
            if (type == Float.TYPE) {
                return new JSONArray((float[])object);
            }
            if (type == Double.TYPE) {
                return new JSONArray((double[])object);
            }
            if (type == Character.TYPE) {
                return new JSONArray((char[])object);
            }
            throw new JSONException("Unsupported type");
        }
        if (JSONUtils.isBoolean(object) || JSONUtils.isFunction(object) || JSONUtils.isNumber(object) || JSONUtils.isNull(object) || JSONUtils.isString(object) || object instanceof JSON) {
            return new JSONArray().put(object, excludes, ignoreDefaultExcludes);
        }
        if (JSONUtils.isObject(object)) {
            return new JSONArray().put(JSONObject.fromObject(object, excludes, ignoreDefaultExcludes));
        }
        throw new JSONException("Unsupported type");
    }

    public static JSONArray fromString(String string) {
        return JSONArray.fromString(string, null, false);
    }

    public static JSONArray fromString(String string, String[] excludes) {
        return JSONArray.fromString(string, excludes, false);
    }

    public static JSONArray fromString(String string, String[] excludes, boolean ignoreDefaultExcludes) {
        return JSONArray.fromJSONTokener(new JSONTokener(string), excludes, ignoreDefaultExcludes);
    }

    public static int[] getDimensions(JSONArray jsonArray) {
        if (jsonArray == null || jsonArray.isEmpty()) {
            return new int[]{0};
        }
        ArrayList dims = new ArrayList();
        JSONArray.processArrayDimensions(jsonArray, dims, 0);
        int[] dimensions = new int[dims.size()];
        int j = 0;
        Iterator i = dims.iterator();
        while (i.hasNext()) {
            dimensions[j++] = (Integer)i.next();
        }
        return dimensions;
    }

    public static Object[] toArray(JSONArray jsonArray) {
        return JSONArray.toArray(jsonArray, null, null);
    }

    public static Object[] toArray(JSONArray jsonArray, Class objectClass) {
        return JSONArray.toArray(jsonArray, objectClass, null);
    }

    public static Object[] toArray(JSONArray jsonArray, Class objectClass, Map classMap) {
        if (jsonArray.length() == 0) {
            return new Object[0];
        }
        int[] dimensions = JSONArray.getDimensions(jsonArray);
        Object array = Array.newInstance(class$java$lang$Object == null ? (class$java$lang$Object = JSONArray.class$("java.lang.Object")) : class$java$lang$Object, dimensions);
        int size = jsonArray.length();
        for (int i = 0; i < size; ++i) {
            Class<?> type;
            Object value = jsonArray.get(i);
            if (JSONUtils.isNull(value)) {
                Array.set(array, i, null);
                continue;
            }
            if ((class$net$sf$json$JSONArray == null ? JSONArray.class$("net.sf.json.JSONArray") : class$net$sf$json$JSONArray).isAssignableFrom(type = value.getClass())) {
                Array.set(array, i, JSONArray.toArray((JSONArray)value, objectClass, classMap));
                continue;
            }
            if ((class$java$lang$String == null ? JSONArray.class$("java.lang.String") : class$java$lang$String).isAssignableFrom(type) || (class$java$lang$Boolean == null ? JSONArray.class$("java.lang.Boolean") : class$java$lang$Boolean).isAssignableFrom(type) || JSONUtils.isNumber(type) || (class$java$lang$Character == null ? JSONArray.class$("java.lang.Character") : class$java$lang$Character).isAssignableFrom(type) || (class$net$sf$json$JSONFunction == null ? JSONArray.class$("net.sf.json.JSONFunction") : class$net$sf$json$JSONFunction).isAssignableFrom(type)) {
                Array.set(array, i, value);
                continue;
            }
            if (objectClass != null) {
                Array.set(array, i, JSONObject.toBean((JSONObject)value, objectClass, classMap));
                continue;
            }
            Array.set(array, i, JSONObject.toBean((JSONObject)value));
        }
        return (Object[])array;
    }

    public static List toList(JSONArray jsonArray) {
        return JSONArray.toList(jsonArray, null, null);
    }

    public static List toList(JSONArray jsonArray, Class objectClass) {
        return JSONArray.toList(jsonArray, objectClass, null);
    }

    public static List toList(JSONArray jsonArray, Class objectClass, Map classMap) {
        ArrayList<Object> list = new ArrayList<Object>();
        int size = jsonArray.length();
        for (int i = 0; i < size; ++i) {
            Class<?> type;
            Object value = jsonArray.get(i);
            if (JSONUtils.isNull(value)) {
                list.add(null);
                continue;
            }
            if ((class$net$sf$json$JSONArray == null ? JSONArray.class$("net.sf.json.JSONArray") : class$net$sf$json$JSONArray).isAssignableFrom(type = value.getClass())) {
                list.add(JSONArray.toList((JSONArray)value, objectClass, classMap));
                continue;
            }
            if ((class$java$lang$String == null ? JSONArray.class$("java.lang.String") : class$java$lang$String).isAssignableFrom(type) || (class$java$lang$Boolean == null ? JSONArray.class$("java.lang.Boolean") : class$java$lang$Boolean).isAssignableFrom(type) || JSONUtils.isNumber(type) || (class$java$lang$Character == null ? JSONArray.class$("java.lang.Character") : class$java$lang$Character).isAssignableFrom(type) || (class$net$sf$json$JSONFunction == null ? JSONArray.class$("net.sf.json.JSONFunction") : class$net$sf$json$JSONFunction).isAssignableFrom(type)) {
                list.add(value);
                continue;
            }
            if (objectClass != null) {
                list.add(JSONObject.toBean((JSONObject)value, objectClass, classMap));
                continue;
            }
            list.add(JSONObject.toBean((JSONObject)value));
        }
        return list;
    }

    private static JSONArray fromJSONTokener(JSONTokener tokener, String[] excludes, boolean ignoreDefaultExcludes) {
        return new JSONArray(tokener, excludes, ignoreDefaultExcludes);
    }

    private static void processArrayDimensions(JSONArray jsonArray, List dims, int index) {
        if (dims.size() <= index) {
            dims.add(new Integer(jsonArray.length()));
        } else {
            int i = (Integer)dims.get(index);
            if (jsonArray.length() > i) {
                dims.set(index, new Integer(jsonArray.length()));
            }
        }
        Iterator i = jsonArray.iterator();
        while (i.hasNext()) {
            Object item = i.next();
            if (!(item instanceof JSONArray)) continue;
            JSONArray.processArrayDimensions((JSONArray)item, dims, index + 1);
        }
    }

    public JSONArray() {
    }

    public JSONArray(Collection collection) {
        this(collection, null, false);
    }

    public JSONArray(String string) {
        this(new JSONTokener(string), null, false);
    }

    private JSONArray(boolean[] array) {
        this.elements.addAll(Arrays.asList(ArrayUtils.toObject((boolean[])array)));
    }

    private JSONArray(byte[] array) {
        for (int i = 0; i < array.length; ++i) {
            Byte b = new Byte(array[i]);
            this.elements.add(JSONUtils.transformNumber(b));
        }
    }

    private JSONArray(char[] array) {
        this.elements.addAll(Arrays.asList(ArrayUtils.toObject((char[])array)));
    }

    private JSONArray(Collection collection, String[] excludes, boolean ignoreDefaultExcludes) {
        if (collection != null) {
            Iterator elements = collection.iterator();
            while (elements.hasNext()) {
                Object element = elements.next();
                this.add(element, excludes, ignoreDefaultExcludes);
            }
        }
    }

    private JSONArray(double[] array) {
        for (int i = 0; i < array.length; ++i) {
            Double d = new Double(array[i]);
            JSONUtils.testValidity(d);
            this.elements.add(d);
        }
    }

    private JSONArray(float[] array) {
        for (int i = 0; i < array.length; ++i) {
            Float f = new Float(array[i]);
            JSONUtils.testValidity(f);
            this.elements.add(f);
        }
    }

    private JSONArray(int[] array) {
        this.elements.addAll(Arrays.asList(ArrayUtils.toObject((int[])array)));
    }

    private JSONArray(JSONArray jsonArray) {
        if (jsonArray != null) {
            this.elements.addAll(jsonArray.elements);
        }
    }

    private JSONArray(JSONTokener x, String[] excludes, boolean ignoreDefaultExcludes) {
        this();
        if (x.nextClean() != '[') {
            throw x.syntaxError("A JSONArray text must start with '['");
        }
        if (x.nextClean() == ']') {
            return;
        }
        x.back();
        block4: while (true) {
            if (x.nextClean() == ',') {
                x.back();
                this.put(JSONNull.getInstance());
            } else {
                x.back();
                Object v = x.nextValue(excludes, ignoreDefaultExcludes);
                if (!JSONUtils.isFunctionHeader(v)) {
                    if (v instanceof String && JSONUtils.mayBeJSON((String)v)) {
                        this.add("\"" + v + "\"", excludes, ignoreDefaultExcludes);
                    } else {
                        this.add(v, excludes, ignoreDefaultExcludes);
                    }
                } else {
                    char ch;
                    String params = JSONUtils.getFunctionParams((String)v);
                    int i = 0;
                    StringBuffer sb = new StringBuffer();
                    while ((ch = x.next()) != '\u0000') {
                        if (ch == '{') {
                            ++i;
                        }
                        if (ch == '}') {
                            --i;
                        }
                        sb.append(ch);
                        if (i != 0) continue;
                        break;
                    }
                    if (i != 0) {
                        throw x.syntaxError("Unbalanced '{' or '}' on prop: " + v);
                    }
                    String text = sb.toString();
                    text = text.substring(1, text.length() - 1).trim();
                    this.elements.add(new JSONFunction(params != null ? StringUtils.split((String)params, (String)",") : null, text));
                }
            }
            switch (x.nextClean()) {
                case ',': 
                case ';': {
                    if (x.nextClean() == ']') {
                        return;
                    }
                    x.back();
                    continue block4;
                }
                case ']': {
                    return;
                }
            }
            break;
        }
        throw x.syntaxError("Expected a ',' or ']'");
    }

    private JSONArray(long[] array) {
        for (int i = 0; i < array.length; ++i) {
            Long l = new Long(array[i]);
            this.elements.add(JSONUtils.transformNumber(l));
        }
    }

    private JSONArray(Object[] array, String[] excludes, boolean ignoreDefaultExcludes) {
        for (int i = 0; i < array.length; ++i) {
            Object element = array[i];
            this.add(element, excludes, ignoreDefaultExcludes);
        }
    }

    private JSONArray(short[] array) {
        for (int i = 0; i < array.length; ++i) {
            Short s = new Short(array[i]);
            this.elements.add(JSONUtils.transformNumber(s));
        }
    }

    public Object get(int index) {
        Object o = this.opt(index);
        if (o == null) {
            throw new JSONException("JSONArray[" + index + "] not found.");
        }
        return o;
    }

    public boolean getBoolean(int index) {
        Object o = this.get(index);
        if (o.equals(Boolean.FALSE) || o instanceof String && ((String)o).equalsIgnoreCase("false")) {
            return false;
        }
        if (o.equals(Boolean.TRUE) || o instanceof String && ((String)o).equalsIgnoreCase("true")) {
            return true;
        }
        throw new JSONException("JSONArray[" + index + "] is not a Boolean.");
    }

    public double getDouble(int index) {
        Object o = this.get(index);
        try {
            return o instanceof Number ? ((Number)o).doubleValue() : Double.parseDouble((String)o);
        }
        catch (Exception e) {
            throw new JSONException("JSONArray[" + index + "] is not a number.");
        }
    }

    public int getInt(int index) {
        Object o = this.get(index);
        return o instanceof Number ? ((Number)o).intValue() : (int)this.getDouble(index);
    }

    public JSONArray getJSONArray(int index) {
        Object o = this.get(index);
        if (o instanceof JSONArray) {
            return (JSONArray)o;
        }
        throw new JSONException("JSONArray[" + index + "] is not a JSONArray.");
    }

    public JSONObject getJSONObject(int index) {
        Object o = this.get(index);
        if (o instanceof JSONObject) {
            return (JSONObject)o;
        }
        throw new JSONException("JSONArray[" + index + "] is not a JSONObject.");
    }

    public long getLong(int index) {
        Object o = this.get(index);
        return o instanceof Number ? ((Number)o).longValue() : (long)this.getDouble(index);
    }

    public String getString(int index) {
        return this.get(index).toString();
    }

    public boolean isArray() {
        return true;
    }

    public boolean isEmpty() {
        return this.elements.isEmpty();
    }

    public boolean isExpandElements() {
        return this.expandElements;
    }

    public Iterator iterator() {
        return this.elements.iterator();
    }

    public String join(String separator) {
        return this.join(separator, false);
    }

    public String join(String separator, boolean stripQuotes) {
        int len = this.length();
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < len; ++i) {
            if (i > 0) {
                sb.append(separator);
            }
            String value = JSONUtils.valueToString(this.elements.get(i));
            sb.append(stripQuotes ? JSONUtils.stripQuotes(value) : value);
        }
        return sb.toString();
    }

    public int length() {
        return this.elements.size();
    }

    public Object opt(int index) {
        return index < 0 || index >= this.length() ? null : this.elements.get(index);
    }

    public boolean optBoolean(int index) {
        return this.optBoolean(index, false);
    }

    public boolean optBoolean(int index, boolean defaultValue) {
        try {
            return this.getBoolean(index);
        }
        catch (Exception e) {
            return defaultValue;
        }
    }

    public double optDouble(int index) {
        return this.optDouble(index, Double.NaN);
    }

    public double optDouble(int index, double defaultValue) {
        try {
            return this.getDouble(index);
        }
        catch (Exception e) {
            return defaultValue;
        }
    }

    public int optInt(int index) {
        return this.optInt(index, 0);
    }

    public int optInt(int index, int defaultValue) {
        try {
            return this.getInt(index);
        }
        catch (Exception e) {
            return defaultValue;
        }
    }

    public JSONArray optJSONArray(int index) {
        Object o = this.opt(index);
        return o instanceof JSONArray ? (JSONArray)o : null;
    }

    public JSONObject optJSONObject(int index) {
        Object o = this.opt(index);
        return o instanceof JSONObject ? (JSONObject)o : null;
    }

    public long optLong(int index) {
        return this.optLong(index, 0L);
    }

    public long optLong(int index, long defaultValue) {
        try {
            return this.getLong(index);
        }
        catch (Exception e) {
            return defaultValue;
        }
    }

    public String optString(int index) {
        return this.optString(index, "");
    }

    public String optString(int index, String defaultValue) {
        Object o = this.opt(index);
        return o != null ? o.toString() : defaultValue;
    }

    public JSONArray put(boolean value) {
        this.put(value ? Boolean.TRUE : Boolean.FALSE);
        return this;
    }

    public JSONArray put(Collection value) {
        return this.put(value, null, false);
    }

    public JSONArray put(Collection value, String[] excludes) {
        return this.put(value, excludes, false);
    }

    public JSONArray put(Collection value, String[] excludes, boolean ignoreDefaultExcludes) {
        this.put(JSONArray.fromCollection(value, excludes, ignoreDefaultExcludes));
        return this;
    }

    public JSONArray put(double value) {
        Double d = new Double(value);
        JSONUtils.testValidity(d);
        this.put(d);
        return this;
    }

    public JSONArray put(int value) {
        this.put(new Integer(value));
        return this;
    }

    public JSONArray put(int index, boolean value) {
        this.put(index, value ? Boolean.TRUE : Boolean.FALSE);
        return this;
    }

    public JSONArray put(int index, Collection value) {
        return this.put(index, value, null, false);
    }

    public JSONArray put(int index, Collection value, String[] excludes) {
        return this.put(index, value, excludes, false);
    }

    public JSONArray put(int index, Collection value, String[] excludes, boolean ignoreDefaultExcludes) {
        this.put(index, JSONArray.fromCollection(value, excludes, ignoreDefaultExcludes));
        return this;
    }

    public JSONArray put(int index, double value) {
        this.put(index, new Double(value));
        return this;
    }

    public JSONArray put(int index, int value) {
        this.put(index, new Integer(value));
        return this;
    }

    public JSONArray put(int index, long value) {
        this.put(index, new Long(value));
        return this;
    }

    public JSONArray put(int index, Map value) {
        return this.put(index, value, null, false);
    }

    public JSONArray put(int index, Map value, String[] excludes) {
        return this.put(index, value, excludes, false);
    }

    public JSONArray put(int index, Map value, String[] excludes, boolean ignoreDefaultExcludes) {
        this.put(index, JSONObject.fromObject(value, excludes, ignoreDefaultExcludes));
        return this;
    }

    public JSONArray put(int index, Object value) {
        return this.put(index, value, null, false);
    }

    public JSONArray put(int index, Object value, String[] excludes) {
        return this.put(index, value, excludes, false);
    }

    public JSONArray put(int index, Object value, String[] excludes, boolean ignoreDefaultExcludes) {
        JSONUtils.testValidity(value);
        if (index < 0) {
            throw new JSONException("JSONArray[" + index + "] not found.");
        }
        if (index < this.length()) {
            if (value != null && (class$java$lang$Class == null ? (class$java$lang$Class = JSONArray.class$("java.lang.Class")) : class$java$lang$Class).isAssignableFrom(value.getClass()) || value instanceof Class) {
                this.elements.set(index, ((Class)value).getName());
            } else if (JSONUtils.isFunction(value)) {
                this.elements.set(index, value);
            } else if (value instanceof JSONString) {
                this.elements.set(index, JSONSerializer.toJSON((Object)((JSONString)value), excludes, ignoreDefaultExcludes));
            } else if (JSONUtils.isArray(value)) {
                this.elements.set(index, JSONArray.fromObject(value, excludes, ignoreDefaultExcludes));
            } else if (value instanceof JSON) {
                this.elements.set(index, value);
            } else if (value instanceof JSONTokener) {
                this.elements.set(index, JSONArray.fromJSONTokener((JSONTokener)value, excludes, ignoreDefaultExcludes));
            } else if (JSONUtils.isString(value)) {
                String str = String.valueOf(value);
                if (JSONUtils.mayBeJSON(str)) {
                    try {
                        this.elements.set(index, JSONSerializer.toJSON((Object)str, excludes, ignoreDefaultExcludes));
                    }
                    catch (JSONException jsone) {
                        this.elements.set(index, JSONUtils.stripQuotes(str));
                    }
                } else {
                    this.elements.set(index, JSONUtils.stripQuotes(str));
                }
            } else if (JSONUtils.isNumber(value) || JSONUtils.isBoolean(value)) {
                JSONUtils.testValidity(value);
                this.elements.set(index, value);
            } else {
                JSONObject jsonObject = JSONObject.fromObject(value, excludes, ignoreDefaultExcludes);
                if (jsonObject.isNullObject()) {
                    this.elements.set(index, JSONNull.getInstance());
                } else {
                    this.elements.set(index, jsonObject);
                }
            }
        } else {
            while (index != this.length()) {
                this.put(JSONNull.getInstance());
            }
            this.put(value, excludes, ignoreDefaultExcludes);
        }
        return this;
    }

    public JSONArray put(int index, String value) {
        return this.put(index, value, null, false);
    }

    public JSONArray put(int index, String value, String[] excludes) {
        return this.put(index, value, excludes, false);
    }

    public JSONArray put(int index, String value, String[] excludes, boolean ignoreDefaultExcludes) {
        if (index < 0) {
            throw new JSONException("JSONArray[" + index + "] not found.");
        }
        if (index < this.length()) {
            if (value == null) {
                this.elements.set(index, "");
            } else if (JSONUtils.mayBeJSON(value)) {
                try {
                    this.elements.set(index, JSONSerializer.toJSON((Object)value, excludes, ignoreDefaultExcludes));
                }
                catch (JSONException jsone) {
                    this.elements.set(index, JSONUtils.stripQuotes(value));
                }
            } else {
                this.elements.set(index, JSONUtils.stripQuotes(value));
            }
        } else {
            while (index != this.length()) {
                this.put(JSONNull.getInstance());
            }
            this.put(value, excludes, ignoreDefaultExcludes);
        }
        return this;
    }

    public JSONArray put(JSON value) {
        this.elements.add(value);
        return this;
    }

    public JSONArray put(long value) {
        this.put(JSONUtils.transformNumber(new Long(value)));
        return this;
    }

    public JSONArray put(Map value) {
        return this.put(value, null, false);
    }

    public JSONArray put(Map value, String[] excludes) {
        return this.put(value, excludes, false);
    }

    public JSONArray put(Map value, String[] excludes, boolean ignoreDefaultExcludes) {
        this.put(JSONObject.fromObject(value, excludes, ignoreDefaultExcludes));
        return this;
    }

    public JSONArray put(Object value) {
        return this.put(value, null, false);
    }

    public JSONArray put(Object value, String[] excludes) {
        return this.put(value, excludes, false);
    }

    public JSONArray put(Object value, String[] excludes, boolean ignoreDefaultExcludes) {
        return this.add(value, excludes, ignoreDefaultExcludes);
    }

    public JSONArray put(String value) {
        return this.put(value, null, false);
    }

    public JSONArray put(String value, String[] excludes) {
        return this.put(value, excludes, false);
    }

    public JSONArray put(String value, String[] excludes, boolean ignoreDefaultExcludes) {
        if (value == null) {
            this.elements.add("");
        } else if (JSONUtils.mayBeJSON(value)) {
            try {
                this.elements.add(JSONSerializer.toJSON(value));
            }
            catch (JSONException jsone) {
                this.elements.add(JSONUtils.stripQuotes(value));
            }
        } else {
            this.elements.add(JSONUtils.stripQuotes(value));
        }
        return this;
    }

    public void setExpandElements(boolean expandElements) {
        this.expandElements = expandElements;
    }

    public Object[] toArray() {
        return this.elements.toArray();
    }

    public JSONObject toJSONObject(JSONArray names) {
        if (names == null || names.length() == 0 || this.length() == 0) {
            return null;
        }
        JSONObject jo = new JSONObject();
        for (int i = 0; i < names.length(); ++i) {
            jo.put(names.getString(i), this.opt(i));
        }
        return jo;
    }

    public String toString() {
        try {
            return '[' + this.join(",") + ']';
        }
        catch (Exception e) {
            return null;
        }
    }

    public String toString(int indentFactor) {
        return this.toString(indentFactor, 0);
    }

    public String toString(int indentFactor, int indent) {
        int len = this.length();
        if (len == 0) {
            return "[]";
        }
        StringBuffer sb = new StringBuffer("[");
        if (len == 1) {
            sb.append(JSONUtils.valueToString(this.elements.get(0), indentFactor, indent));
        } else {
            int i;
            int newindent = indent + indentFactor;
            sb.append('\n');
            for (i = 0; i < len; ++i) {
                if (i > 0) {
                    sb.append(",\n");
                }
                for (int j = 0; j < newindent; ++j) {
                    sb.append(' ');
                }
                sb.append(JSONUtils.valueToString(this.elements.get(i), indentFactor, newindent));
            }
            sb.append('\n');
            for (i = 0; i < indent; ++i) {
                sb.append(' ');
            }
            for (i = 0; i < indent; ++i) {
                sb.insert(0, ' ');
            }
        }
        sb.append(']');
        return sb.toString();
    }

    public Writer write(Writer writer) {
        try {
            boolean b = false;
            int len = this.length();
            writer.write(91);
            for (int i = 0; i < len; ++i) {
                Object v;
                if (b) {
                    writer.write(44);
                }
                if ((v = this.elements.get(i)) instanceof JSONObject) {
                    ((JSONObject)v).write(writer);
                } else if (v instanceof JSONArray) {
                    ((JSONArray)v).write(writer);
                } else {
                    writer.write(JSONUtils.valueToString(v));
                }
                b = true;
            }
            writer.write(93);
            return writer;
        }
        catch (IOException e) {
            throw new JSONException(e);
        }
    }

    private JSONArray add(Object value, String[] excludes, boolean ignoreDefaultValues) {
        if (value != null && (class$java$lang$Class == null ? (class$java$lang$Class = JSONArray.class$("java.lang.Class")) : class$java$lang$Class).isAssignableFrom(value.getClass()) || value instanceof Class) {
            this.elements.add(((Class)value).getName());
        } else if (JSONUtils.isFunction(value)) {
            this.elements.add(value);
        } else if (value instanceof JSONString) {
            this.elements.add(JSONSerializer.toJSON((Object)((JSONString)value), excludes, ignoreDefaultValues));
        } else if (JSONUtils.isArray(value)) {
            this.elements.add(JSONArray.fromObject(value, excludes, ignoreDefaultValues));
        } else if (value instanceof JSON) {
            this.elements.add(value);
        } else if (value instanceof JSONTokener) {
            this.elements.add(JSONArray.fromJSONTokener((JSONTokener)value, excludes, ignoreDefaultValues));
        } else if (JSONUtils.isString(value)) {
            String str = String.valueOf(value);
            if (JSONUtils.mayBeJSON(str)) {
                try {
                    this.elements.add(JSONSerializer.toJSON((Object)str, excludes, ignoreDefaultValues));
                }
                catch (JSONException jsone) {
                    this.elements.add(JSONUtils.stripQuotes(str));
                }
            } else {
                this.elements.add(JSONUtils.stripQuotes(str));
            }
        } else if (JSONUtils.isNumber(value)) {
            JSONUtils.testValidity(value);
            this.elements.add(JSONUtils.transformNumber((Number)value));
        } else if (JSONUtils.isBoolean(value)) {
            this.elements.add(value);
        } else {
            JSONObject jsonObject = JSONObject.fromObject(value, excludes, ignoreDefaultValues);
            if (jsonObject.isNullObject()) {
                this.elements.add(JSONNull.getInstance());
            } else {
                this.elements.add(jsonObject);
            }
        }
        return this;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

