/*
 * Decompiled with CFR 0.152.
 */
package org.apache.curator.framework.imps;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.Callable;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.curator.CuratorZookeeperClient;
import org.apache.curator.RetryLoop;
import org.apache.curator.TimeTrace;
import org.apache.curator.framework.api.ACLBackgroundPathAndBytesable;
import org.apache.curator.framework.api.ACLCreateModeBackgroundPathAndBytesable;
import org.apache.curator.framework.api.ACLCreateModePathAndBytesable;
import org.apache.curator.framework.api.ACLCreateModeStatBackgroundPathAndBytesable;
import org.apache.curator.framework.api.ACLPathAndBytesable;
import org.apache.curator.framework.api.BackgroundCallback;
import org.apache.curator.framework.api.BackgroundPathAndBytesable;
import org.apache.curator.framework.api.CreateBackgroundModeACLable;
import org.apache.curator.framework.api.CreateBackgroundModeStatACLable;
import org.apache.curator.framework.api.CreateBuilder;
import org.apache.curator.framework.api.CreateBuilderMain;
import org.apache.curator.framework.api.CreateProtectACLCreateModePathAndBytesable;
import org.apache.curator.framework.api.CuratorEventType;
import org.apache.curator.framework.api.PathAndBytesable;
import org.apache.curator.framework.api.ProtectACLCreateModePathAndBytesable;
import org.apache.curator.framework.api.ProtectACLCreateModeStatPathAndBytesable;
import org.apache.curator.framework.api.transaction.OperationType;
import org.apache.curator.framework.api.transaction.TransactionCreateBuilder;
import org.apache.curator.framework.imps.ACLing;
import org.apache.curator.framework.imps.BackgroundOperation;
import org.apache.curator.framework.imps.Backgrounding;
import org.apache.curator.framework.imps.CuratorEventImpl;
import org.apache.curator.framework.imps.CuratorFrameworkImpl;
import org.apache.curator.framework.imps.CuratorMultiTransactionRecord;
import org.apache.curator.framework.imps.FindAndDeleteProtectedNodeInBackground;
import org.apache.curator.framework.imps.OperationAndData;
import org.apache.curator.framework.imps.PathAndBytes;
import org.apache.curator.utils.InternalACLProvider;
import org.apache.curator.utils.ThreadUtils;
import org.apache.curator.utils.ZKPaths;
import org.apache.zookeeper.AsyncCallback;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.Op;
import org.apache.zookeeper.ZooKeeper;
import org.apache.zookeeper.data.ACL;
import org.apache.zookeeper.data.Stat;

class CreateBuilderImpl
implements CreateBuilder,
BackgroundOperation<PathAndBytes> {
    private final CuratorFrameworkImpl client;
    private CreateMode createMode;
    private Backgrounding backgrounding;
    private boolean createParentsIfNeeded;
    private boolean createParentsAsContainers;
    private boolean doProtected;
    private boolean compress;
    private boolean setDataIfExists;
    private String protectedId;
    private ACLing acling;
    private Stat storingStat;
    @VisibleForTesting
    boolean failNextCreateForTesting = false;
    @VisibleForTesting
    static final String PROTECTED_PREFIX = "_c_";
    @VisibleForTesting
    volatile boolean debugForceFindProtectedNode = false;

    CreateBuilderImpl(CuratorFrameworkImpl client) {
        this.client = client;
        this.createMode = CreateMode.PERSISTENT;
        this.backgrounding = new Backgrounding();
        this.acling = new ACLing(client.getAclProvider());
        this.createParentsIfNeeded = false;
        this.createParentsAsContainers = false;
        this.compress = false;
        this.doProtected = false;
        this.setDataIfExists = false;
        this.protectedId = null;
        this.storingStat = null;
    }

    @Override
    public CreateBuilderMain orSetData() {
        this.setDataIfExists = true;
        return this;
    }

    <T> TransactionCreateBuilder<T> asTransactionCreateBuilder(final T context, final CuratorMultiTransactionRecord transaction) {
        return new TransactionCreateBuilder<T>(){

            @Override
            public PathAndBytesable<T> withACL(List<ACL> aclList) {
                CreateBuilderImpl.this.withACL((List)aclList);
                return this;
            }

            @Override
            public ACLPathAndBytesable<T> withMode(CreateMode mode) {
                CreateBuilderImpl.this.withMode(mode);
                return this;
            }

            @Override
            public ACLCreateModePathAndBytesable<T> compressed() {
                CreateBuilderImpl.this.compressed();
                return this;
            }

            @Override
            public T forPath(String path) throws Exception {
                return this.forPath(path, CreateBuilderImpl.this.client.getDefaultData());
            }

            @Override
            public T forPath(String path, byte[] data) throws Exception {
                if (CreateBuilderImpl.this.compress) {
                    data = CreateBuilderImpl.this.client.getCompressionProvider().compress(path, data);
                }
                String fixedPath = CreateBuilderImpl.this.client.fixForNamespace(path);
                transaction.add(Op.create((String)fixedPath, (byte[])data, CreateBuilderImpl.this.acling.getAclList(path), (CreateMode)CreateBuilderImpl.this.createMode), OperationType.CREATE, path);
                return context;
            }
        };
    }

    @Override
    public CreateBackgroundModeStatACLable compressed() {
        this.compress = true;
        return new CreateBackgroundModeStatACLable(){

            @Override
            public CreateBackgroundModeACLable storingStatIn(Stat stat) {
                CreateBuilderImpl.this.storingStat = stat;
                return CreateBuilderImpl.this.asCreateBackgroundModeACLable();
            }

            @Override
            public ACLCreateModePathAndBytesable<String> creatingParentsIfNeeded() {
                CreateBuilderImpl.this.createParentsIfNeeded = true;
                return CreateBuilderImpl.this.asACLCreateModePathAndBytesable();
            }

            @Override
            public ACLCreateModePathAndBytesable<String> creatingParentContainersIfNeeded() {
                CreateBuilderImpl.this.setCreateParentsAsContainers();
                return this.creatingParentsIfNeeded();
            }

            @Override
            public ACLPathAndBytesable<String> withProtectedEphemeralSequential() {
                return CreateBuilderImpl.this.withProtectedEphemeralSequential();
            }

            @Override
            public BackgroundPathAndBytesable<String> withACL(List<ACL> aclList) {
                return CreateBuilderImpl.this.withACL((List)aclList);
            }

            @Override
            public PathAndBytesable<String> inBackground(BackgroundCallback callback, Object context) {
                return CreateBuilderImpl.this.inBackground(callback, context);
            }

            @Override
            public PathAndBytesable<String> inBackground(BackgroundCallback callback, Object context, Executor executor) {
                return CreateBuilderImpl.this.inBackground(callback, context, executor);
            }

            @Override
            public PathAndBytesable<String> inBackground() {
                return CreateBuilderImpl.this.inBackground();
            }

            @Override
            public PathAndBytesable<String> inBackground(Object context) {
                return CreateBuilderImpl.this.inBackground(context);
            }

            @Override
            public PathAndBytesable<String> inBackground(BackgroundCallback callback) {
                return CreateBuilderImpl.this.inBackground(callback);
            }

            @Override
            public PathAndBytesable<String> inBackground(BackgroundCallback callback, Executor executor) {
                return CreateBuilderImpl.this.inBackground(callback, executor);
            }

            @Override
            public ACLBackgroundPathAndBytesable<String> withMode(CreateMode mode) {
                return CreateBuilderImpl.this.withMode(mode);
            }

            @Override
            public String forPath(String path, byte[] data) throws Exception {
                return CreateBuilderImpl.this.forPath(path, data);
            }

            @Override
            public String forPath(String path) throws Exception {
                return CreateBuilderImpl.this.forPath(path);
            }
        };
    }

    @Override
    public ACLBackgroundPathAndBytesable<String> withACL(List<ACL> aclList) {
        this.acling = new ACLing(this.client.getAclProvider(), aclList);
        return new ACLBackgroundPathAndBytesable<String>(){

            @Override
            public BackgroundPathAndBytesable<String> withACL(List<ACL> aclList) {
                return CreateBuilderImpl.this.withACL((List)aclList);
            }

            @Override
            public PathAndBytesable<String> inBackground() {
                return CreateBuilderImpl.this.inBackground();
            }

            @Override
            public PathAndBytesable<String> inBackground(BackgroundCallback callback, Object context) {
                return CreateBuilderImpl.this.inBackground(callback, context);
            }

            @Override
            public PathAndBytesable<String> inBackground(BackgroundCallback callback, Object context, Executor executor) {
                return CreateBuilderImpl.this.inBackground(callback, context, executor);
            }

            @Override
            public PathAndBytesable<String> inBackground(Object context) {
                return CreateBuilderImpl.this.inBackground(context);
            }

            @Override
            public PathAndBytesable<String> inBackground(BackgroundCallback callback) {
                return CreateBuilderImpl.this.inBackground(callback);
            }

            @Override
            public PathAndBytesable<String> inBackground(BackgroundCallback callback, Executor executor) {
                return CreateBuilderImpl.this.inBackground(callback, executor);
            }

            @Override
            public String forPath(String path, byte[] data) throws Exception {
                return CreateBuilderImpl.this.forPath(path, data);
            }

            @Override
            public String forPath(String path) throws Exception {
                return CreateBuilderImpl.this.forPath(path);
            }
        };
    }

    @Override
    public ProtectACLCreateModeStatPathAndBytesable<String> creatingParentContainersIfNeeded() {
        this.setCreateParentsAsContainers();
        return this.creatingParentsIfNeeded();
    }

    private void setCreateParentsAsContainers() {
        if (this.client.useContainerParentsIfAvailable()) {
            this.createParentsAsContainers = true;
        }
    }

    @Override
    public ProtectACLCreateModeStatPathAndBytesable<String> creatingParentsIfNeeded() {
        this.createParentsIfNeeded = true;
        return new ProtectACLCreateModeStatPathAndBytesable<String>(){

            @Override
            public ACLCreateModeBackgroundPathAndBytesable<String> withProtection() {
                return CreateBuilderImpl.this.withProtection();
            }

            @Override
            public BackgroundPathAndBytesable<String> withACL(List<ACL> aclList) {
                return CreateBuilderImpl.this.withACL((List)aclList);
            }

            @Override
            public PathAndBytesable<String> inBackground() {
                return CreateBuilderImpl.this.inBackground();
            }

            @Override
            public PathAndBytesable<String> inBackground(Object context) {
                return CreateBuilderImpl.this.inBackground(context);
            }

            @Override
            public PathAndBytesable<String> inBackground(BackgroundCallback callback) {
                return CreateBuilderImpl.this.inBackground(callback);
            }

            @Override
            public PathAndBytesable<String> inBackground(BackgroundCallback callback, Object context) {
                return CreateBuilderImpl.this.inBackground(callback, context);
            }

            @Override
            public PathAndBytesable<String> inBackground(BackgroundCallback callback, Executor executor) {
                return CreateBuilderImpl.this.inBackground(callback, executor);
            }

            @Override
            public PathAndBytesable<String> inBackground(BackgroundCallback callback, Object context, Executor executor) {
                return CreateBuilderImpl.this.inBackground(callback, context, executor);
            }

            @Override
            public ACLBackgroundPathAndBytesable<String> withMode(CreateMode mode) {
                return CreateBuilderImpl.this.withMode(mode);
            }

            @Override
            public String forPath(String path, byte[] data) throws Exception {
                return CreateBuilderImpl.this.forPath(path, data);
            }

            @Override
            public String forPath(String path) throws Exception {
                return CreateBuilderImpl.this.forPath(path);
            }

            @Override
            public ACLBackgroundPathAndBytesable<String> storingStatIn(Stat stat) {
                CreateBuilderImpl.this.storingStat = stat;
                return CreateBuilderImpl.this;
            }
        };
    }

    @Override
    public ACLCreateModeStatBackgroundPathAndBytesable<String> withProtection() {
        this.setProtected();
        return this.asACLCreateModeStatBackgroundPathAndBytesable();
    }

    @Override
    public ACLPathAndBytesable<String> withProtectedEphemeralSequential() {
        this.setProtected();
        this.createMode = CreateMode.EPHEMERAL_SEQUENTIAL;
        return new ACLPathAndBytesable<String>(){

            @Override
            public PathAndBytesable<String> withACL(List<ACL> aclList) {
                return CreateBuilderImpl.this.withACL((List)aclList);
            }

            @Override
            public String forPath(String path, byte[] data) throws Exception {
                return CreateBuilderImpl.this.forPath(path, data);
            }

            @Override
            public String forPath(String path) throws Exception {
                return CreateBuilderImpl.this.forPath(path);
            }
        };
    }

    @Override
    public ACLBackgroundPathAndBytesable<String> withMode(CreateMode mode) {
        this.createMode = mode;
        return this;
    }

    @Override
    public PathAndBytesable<String> inBackground(BackgroundCallback callback, Object context) {
        this.backgrounding = new Backgrounding(callback, context);
        return this;
    }

    @Override
    public PathAndBytesable<String> inBackground(BackgroundCallback callback, Object context, Executor executor) {
        this.backgrounding = new Backgrounding(this.client, callback, context, executor);
        return this;
    }

    @Override
    public PathAndBytesable<String> inBackground(BackgroundCallback callback) {
        this.backgrounding = new Backgrounding(callback);
        return this;
    }

    @Override
    public PathAndBytesable<String> inBackground(BackgroundCallback callback, Executor executor) {
        this.backgrounding = new Backgrounding(this.client, callback, executor);
        return this;
    }

    @Override
    public PathAndBytesable<String> inBackground() {
        this.backgrounding = new Backgrounding(true);
        return this;
    }

    @Override
    public PathAndBytesable<String> inBackground(Object context) {
        this.backgrounding = new Backgrounding(context);
        return this;
    }

    @Override
    public String forPath(String path) throws Exception {
        return this.forPath(path, this.client.getDefaultData());
    }

    @Override
    public String forPath(String givenPath, byte[] data) throws Exception {
        if (this.compress) {
            data = this.client.getCompressionProvider().compress(givenPath, data);
        }
        String adjustedPath = this.adjustPath(this.client.fixForNamespace(givenPath, this.createMode.isSequential()));
        String returnPath = null;
        if (this.backgrounding.inBackground()) {
            this.pathInBackground(adjustedPath, data, givenPath);
        } else {
            String path = this.protectedPathInForeground(adjustedPath, data);
            returnPath = this.client.unfixForNamespace(path);
        }
        return returnPath;
    }

    private String protectedPathInForeground(String adjustedPath, byte[] data) throws Exception {
        try {
            return this.pathInForeground(adjustedPath, data);
        }
        catch (Exception e) {
            ThreadUtils.checkInterrupted((Throwable)e);
            if ((e instanceof KeeperException.ConnectionLossException || !(e instanceof KeeperException)) && this.protectedId != null) {
                new FindAndDeleteProtectedNodeInBackground(this.client, ZKPaths.getPathAndNode((String)adjustedPath).getPath(), this.protectedId).execute();
                this.protectedId = UUID.randomUUID().toString();
            }
            throw e;
        }
    }

    @Override
    public void performBackgroundOperation(final OperationAndData<PathAndBytes> operationAndData) throws Exception {
        final TimeTrace trace = this.client.getZookeeperClient().startTracer("CreateBuilderImpl-Background");
        if (this.storingStat == null) {
            this.client.getZooKeeper().create(operationAndData.getData().getPath(), operationAndData.getData().getData(), this.acling.getAclList(operationAndData.getData().getPath()), this.createMode, new AsyncCallback.StringCallback(){

                public void processResult(int rc, String path, Object ctx, String name) {
                    trace.commit();
                    if (rc == KeeperException.Code.NONODE.intValue() && CreateBuilderImpl.this.createParentsIfNeeded) {
                        CreateBuilderImpl.backgroundCreateParentsThenNode(CreateBuilderImpl.this.client, operationAndData, ((PathAndBytes)operationAndData.getData()).getPath(), CreateBuilderImpl.this.backgrounding, CreateBuilderImpl.this.createParentsAsContainers);
                    } else if (rc == KeeperException.Code.NODEEXISTS.intValue() && CreateBuilderImpl.this.setDataIfExists) {
                        CreateBuilderImpl.this.backgroundSetData(CreateBuilderImpl.this.client, operationAndData, ((PathAndBytes)operationAndData.getData()).getPath(), CreateBuilderImpl.this.backgrounding);
                    } else {
                        CreateBuilderImpl.this.sendBackgroundResponse(rc, path, ctx, name, null, operationAndData);
                    }
                }
            }, this.backgrounding.getContext());
        } else {
            this.client.getZooKeeper().create(operationAndData.getData().getPath(), operationAndData.getData().getData(), this.acling.getAclList(operationAndData.getData().getPath()), this.createMode, new AsyncCallback.Create2Callback(){

                public void processResult(int rc, String path, Object ctx, String name, Stat stat) {
                    trace.commit();
                    if (stat != null) {
                        CreateBuilderImpl.this.storingStat.setAversion(stat.getAversion());
                        CreateBuilderImpl.this.storingStat.setCtime(stat.getCtime());
                        CreateBuilderImpl.this.storingStat.setCversion(stat.getCversion());
                        CreateBuilderImpl.this.storingStat.setCzxid(stat.getCzxid());
                        CreateBuilderImpl.this.storingStat.setDataLength(stat.getDataLength());
                        CreateBuilderImpl.this.storingStat.setEphemeralOwner(stat.getEphemeralOwner());
                        CreateBuilderImpl.this.storingStat.setMtime(stat.getMtime());
                        CreateBuilderImpl.this.storingStat.setMzxid(stat.getMzxid());
                        CreateBuilderImpl.this.storingStat.setNumChildren(stat.getNumChildren());
                        CreateBuilderImpl.this.storingStat.setPzxid(stat.getPzxid());
                        CreateBuilderImpl.this.storingStat.setVersion(stat.getVersion());
                    }
                    if (rc == KeeperException.Code.NONODE.intValue() && CreateBuilderImpl.this.createParentsIfNeeded) {
                        CreateBuilderImpl.backgroundCreateParentsThenNode(CreateBuilderImpl.this.client, operationAndData, ((PathAndBytes)operationAndData.getData()).getPath(), CreateBuilderImpl.this.backgrounding, CreateBuilderImpl.this.createParentsAsContainers);
                    } else {
                        CreateBuilderImpl.this.sendBackgroundResponse(rc, path, ctx, name, stat, operationAndData);
                    }
                }
            }, this.backgrounding.getContext());
        }
    }

    @Override
    public CreateProtectACLCreateModePathAndBytesable<String> storingStatIn(Stat stat) {
        this.storingStat = stat;
        return new CreateProtectACLCreateModePathAndBytesable<String>(){

            @Override
            public BackgroundPathAndBytesable<String> withACL(List<ACL> aclList) {
                return CreateBuilderImpl.this.withACL((List)aclList);
            }

            @Override
            public PathAndBytesable<String> inBackground() {
                return CreateBuilderImpl.this.inBackground();
            }

            @Override
            public PathAndBytesable<String> inBackground(Object context) {
                return CreateBuilderImpl.this.inBackground(context);
            }

            @Override
            public PathAndBytesable<String> inBackground(BackgroundCallback callback) {
                return CreateBuilderImpl.this.inBackground(callback);
            }

            @Override
            public PathAndBytesable<String> inBackground(BackgroundCallback callback, Object context) {
                return CreateBuilderImpl.this.inBackground(callback, context);
            }

            @Override
            public PathAndBytesable<String> inBackground(BackgroundCallback callback, Executor executor) {
                return CreateBuilderImpl.this.inBackground(callback, executor);
            }

            @Override
            public PathAndBytesable<String> inBackground(BackgroundCallback callback, Object context, Executor executor) {
                return CreateBuilderImpl.this.inBackground(callback, context, executor);
            }

            @Override
            public String forPath(String path, byte[] data) throws Exception {
                return CreateBuilderImpl.this.forPath(path, data);
            }

            @Override
            public String forPath(String path) throws Exception {
                return CreateBuilderImpl.this.forPath(path);
            }

            @Override
            public ACLBackgroundPathAndBytesable<String> withMode(CreateMode mode) {
                return CreateBuilderImpl.this.withMode(mode);
            }

            @Override
            public ACLCreateModeBackgroundPathAndBytesable<String> withProtection() {
                return CreateBuilderImpl.this.withProtection();
            }

            @Override
            public ProtectACLCreateModePathAndBytesable<String> creatingParentsIfNeeded() {
                return CreateBuilderImpl.this.creatingParentsIfNeeded();
            }

            @Override
            public ProtectACLCreateModePathAndBytesable<String> creatingParentContainersIfNeeded() {
                return CreateBuilderImpl.this.creatingParentContainersIfNeeded();
            }
        };
    }

    private static String getProtectedPrefix(String protectedId) {
        return PROTECTED_PREFIX + protectedId + "-";
    }

    static <T> void backgroundCreateParentsThenNode(final CuratorFrameworkImpl client, final OperationAndData<T> mainOperationAndData, final String path, Backgrounding backgrounding, final boolean createParentsAsContainers) {
        BackgroundOperation operation = new BackgroundOperation<T>(){

            @Override
            public void performBackgroundOperation(OperationAndData<T> dummy) throws Exception {
                try {
                    ZKPaths.mkdirs((ZooKeeper)client.getZooKeeper(), (String)path, (boolean)false, (InternalACLProvider)client.getAclProvider(), (boolean)createParentsAsContainers);
                }
                catch (KeeperException keeperException) {
                    // empty catch block
                }
                client.queueOperation(mainOperationAndData);
            }
        };
        OperationAndData<T> parentOperation = new OperationAndData<T>(operation, mainOperationAndData.getData(), null, null, backgrounding.getContext());
        client.queueOperation(parentOperation);
    }

    private void backgroundSetData(final CuratorFrameworkImpl client, final OperationAndData<PathAndBytes> mainOperationAndData, final String path, final Backgrounding backgrounding) {
        final AsyncCallback.StatCallback statCallback = new AsyncCallback.StatCallback(){

            public void processResult(int rc, String path, Object ctx, Stat stat) {
                if (rc == KeeperException.Code.NONODE.intValue()) {
                    client.queueOperation(mainOperationAndData);
                } else {
                    CreateBuilderImpl.this.sendBackgroundResponse(rc, path, ctx, path, stat, mainOperationAndData);
                }
            }
        };
        BackgroundOperation<PathAndBytes> operation = new BackgroundOperation<PathAndBytes>(){

            @Override
            public void performBackgroundOperation(OperationAndData<PathAndBytes> op) throws Exception {
                try {
                    client.getZooKeeper().setData(path, ((PathAndBytes)mainOperationAndData.getData()).getData(), -1, statCallback, backgrounding.getContext());
                }
                catch (KeeperException keeperException) {
                    // empty catch block
                }
                client.queueOperation(mainOperationAndData);
            }
        };
        client.queueOperation(new OperationAndData<Object>(operation, null, null, null, null));
    }

    private void sendBackgroundResponse(int rc, String path, Object ctx, String name, Stat stat, OperationAndData<PathAndBytes> operationAndData) {
        path = this.client.unfixForNamespace(path);
        name = this.client.unfixForNamespace(name);
        CuratorEventImpl event = new CuratorEventImpl(this.client, CuratorEventType.CREATE, rc, path, name, ctx, stat, null, null, null, null, null);
        this.client.processBackgroundOperation(operationAndData, event);
    }

    private void setProtected() {
        this.doProtected = true;
        this.protectedId = UUID.randomUUID().toString();
    }

    private ACLCreateModePathAndBytesable<String> asACLCreateModePathAndBytesable() {
        return new ACLCreateModePathAndBytesable<String>(){

            @Override
            public PathAndBytesable<String> withACL(List<ACL> aclList) {
                return CreateBuilderImpl.this.withACL((List)aclList);
            }

            @Override
            public ACLPathAndBytesable<String> withMode(CreateMode mode) {
                CreateBuilderImpl.this.createMode = mode;
                return new ACLPathAndBytesable<String>(){

                    @Override
                    public PathAndBytesable<String> withACL(List<ACL> aclList) {
                        return CreateBuilderImpl.this.withACL((List)aclList);
                    }

                    @Override
                    public String forPath(String path, byte[] data) throws Exception {
                        return CreateBuilderImpl.this.forPath(path, data);
                    }

                    @Override
                    public String forPath(String path) throws Exception {
                        return CreateBuilderImpl.this.forPath(path);
                    }
                };
            }

            @Override
            public String forPath(String path, byte[] data) throws Exception {
                return CreateBuilderImpl.this.forPath(path, data);
            }

            @Override
            public String forPath(String path) throws Exception {
                return CreateBuilderImpl.this.forPath(path);
            }
        };
    }

    private CreateBackgroundModeACLable asCreateBackgroundModeACLable() {
        return new CreateBackgroundModeACLable(){

            @Override
            public BackgroundPathAndBytesable<String> withACL(List<ACL> aclList) {
                return CreateBuilderImpl.this.withACL((List)aclList);
            }

            @Override
            public ACLBackgroundPathAndBytesable<String> withMode(CreateMode mode) {
                return CreateBuilderImpl.this.withMode(mode);
            }

            @Override
            public String forPath(String path) throws Exception {
                return CreateBuilderImpl.this.forPath(path);
            }

            @Override
            public String forPath(String path, byte[] data) throws Exception {
                return CreateBuilderImpl.this.forPath(path, data);
            }

            @Override
            public PathAndBytesable<String> inBackground(BackgroundCallback callback, Object context, Executor executor) {
                return CreateBuilderImpl.this.inBackground(callback, context, executor);
            }

            @Override
            public PathAndBytesable<String> inBackground(BackgroundCallback callback, Executor executor) {
                return CreateBuilderImpl.this.inBackground(callback, executor);
            }

            @Override
            public PathAndBytesable<String> inBackground(BackgroundCallback callback, Object context) {
                return CreateBuilderImpl.this.inBackground(callback, context);
            }

            @Override
            public PathAndBytesable<String> inBackground(BackgroundCallback callback) {
                return CreateBuilderImpl.this.inBackground(callback);
            }

            @Override
            public PathAndBytesable<String> inBackground(Object context) {
                return CreateBuilderImpl.this.inBackground(context);
            }

            @Override
            public PathAndBytesable<String> inBackground() {
                return CreateBuilderImpl.this.inBackground();
            }

            @Override
            public ACLPathAndBytesable<String> withProtectedEphemeralSequential() {
                return CreateBuilderImpl.this.withProtectedEphemeralSequential();
            }

            @Override
            public ACLCreateModePathAndBytesable<String> creatingParentsIfNeeded() {
                CreateBuilderImpl.this.createParentsIfNeeded = true;
                return CreateBuilderImpl.this.asACLCreateModePathAndBytesable();
            }

            @Override
            public ACLCreateModePathAndBytesable<String> creatingParentContainersIfNeeded() {
                CreateBuilderImpl.this.setCreateParentsAsContainers();
                return CreateBuilderImpl.this.asACLCreateModePathAndBytesable();
            }
        };
    }

    private ACLCreateModeStatBackgroundPathAndBytesable<String> asACLCreateModeStatBackgroundPathAndBytesable() {
        return new ACLCreateModeStatBackgroundPathAndBytesable<String>(){

            @Override
            public BackgroundPathAndBytesable<String> withACL(List<ACL> aclList) {
                return CreateBuilderImpl.this.withACL((List)aclList);
            }

            @Override
            public PathAndBytesable<String> inBackground() {
                return CreateBuilderImpl.this.inBackground();
            }

            @Override
            public PathAndBytesable<String> inBackground(BackgroundCallback callback, Object context, Executor executor) {
                return CreateBuilderImpl.this.inBackground(callback, context, executor);
            }

            @Override
            public PathAndBytesable<String> inBackground(BackgroundCallback callback, Executor executor) {
                return CreateBuilderImpl.this.inBackground(callback, executor);
            }

            @Override
            public PathAndBytesable<String> inBackground(BackgroundCallback callback, Object context) {
                return CreateBuilderImpl.this.inBackground(callback, context);
            }

            @Override
            public PathAndBytesable<String> inBackground(BackgroundCallback callback) {
                return CreateBuilderImpl.this.inBackground(callback);
            }

            @Override
            public PathAndBytesable<String> inBackground(Object context) {
                return CreateBuilderImpl.this.inBackground(context);
            }

            @Override
            public String forPath(String path) throws Exception {
                return CreateBuilderImpl.this.forPath(path);
            }

            @Override
            public String forPath(String path, byte[] data) throws Exception {
                return CreateBuilderImpl.this.forPath(path, data);
            }

            @Override
            public ACLBackgroundPathAndBytesable<String> withMode(CreateMode mode) {
                return CreateBuilderImpl.this.withMode(mode);
            }

            @Override
            public ACLCreateModeBackgroundPathAndBytesable<String> storingStatIn(Stat stat) {
                CreateBuilderImpl.this.storingStat = stat;
                return CreateBuilderImpl.this;
            }
        };
    }

    private void pathInBackground(final String path, final byte[] data, final String givenPath) {
        final AtomicBoolean firstTime = new AtomicBoolean(true);
        OperationAndData<PathAndBytes> operationAndData = new OperationAndData<PathAndBytes>((BackgroundOperation)this, new PathAndBytes(path, data), this.backgrounding.getCallback(), (OperationAndData.ErrorCallback)new OperationAndData.ErrorCallback<PathAndBytes>(){

            @Override
            public void retriesExhausted(OperationAndData<PathAndBytes> operationAndData) {
                if (CreateBuilderImpl.this.doProtected) {
                    new FindAndDeleteProtectedNodeInBackground(CreateBuilderImpl.this.client, ZKPaths.getPathAndNode((String)path).getPath(), CreateBuilderImpl.this.protectedId).execute();
                    CreateBuilderImpl.this.protectedId = UUID.randomUUID().toString();
                }
            }
        }, this.backgrounding.getContext()){

            @Override
            void callPerformBackgroundOperation() throws Exception {
                boolean localFirstTime;
                boolean callSuper = true;
                boolean bl = localFirstTime = firstTime.getAndSet(false) && !CreateBuilderImpl.this.debugForceFindProtectedNode;
                if (!localFirstTime && CreateBuilderImpl.this.doProtected) {
                    CreateBuilderImpl.this.debugForceFindProtectedNode = false;
                    String createdPath = null;
                    try {
                        createdPath = CreateBuilderImpl.this.findProtectedNodeInForeground(path);
                    }
                    catch (KeeperException.ConnectionLossException e) {
                        CreateBuilderImpl.this.sendBackgroundResponse(KeeperException.Code.CONNECTIONLOSS.intValue(), path, CreateBuilderImpl.this.backgrounding.getContext(), null, null, this);
                        callSuper = false;
                    }
                    if (createdPath != null) {
                        try {
                            CreateBuilderImpl.this.sendBackgroundResponse(KeeperException.Code.OK.intValue(), createdPath, CreateBuilderImpl.this.backgrounding.getContext(), createdPath, null, this);
                        }
                        catch (Exception e) {
                            ThreadUtils.checkInterrupted((Throwable)e);
                            CreateBuilderImpl.this.client.logError("Processing protected create for path: " + givenPath, e);
                        }
                        callSuper = false;
                    }
                }
                if (CreateBuilderImpl.this.failNextCreateForTesting) {
                    CreateBuilderImpl.this.pathInForeground(path, data);
                    CreateBuilderImpl.this.failNextCreateForTesting = false;
                    throw new KeeperException.ConnectionLossException();
                }
                if (callSuper) {
                    super.callPerformBackgroundOperation();
                }
            }
        };
        this.client.processBackgroundOperation(operationAndData, null);
    }

    private String pathInForeground(final String path, final byte[] data) throws Exception {
        TimeTrace trace = this.client.getZookeeperClient().startTracer("CreateBuilderImpl-Foreground");
        final AtomicBoolean firstTime = new AtomicBoolean(true);
        String returnPath = (String)RetryLoop.callWithRetry((CuratorZookeeperClient)this.client.getZookeeperClient(), (Callable)new Callable<String>(){

            @Override
            public String call() throws Exception {
                boolean localFirstTime = firstTime.getAndSet(false) && !CreateBuilderImpl.this.debugForceFindProtectedNode;
                String createdPath = null;
                if (!localFirstTime && CreateBuilderImpl.this.doProtected) {
                    CreateBuilderImpl.this.debugForceFindProtectedNode = false;
                    createdPath = CreateBuilderImpl.this.findProtectedNodeInForeground(path);
                }
                if (createdPath == null) {
                    try {
                        createdPath = CreateBuilderImpl.this.client.getZooKeeper().create(path, data, CreateBuilderImpl.this.acling.getAclList(path), CreateBuilderImpl.this.createMode, CreateBuilderImpl.this.storingStat);
                    }
                    catch (KeeperException.NoNodeException e) {
                        if (CreateBuilderImpl.this.createParentsIfNeeded) {
                            ZKPaths.mkdirs((ZooKeeper)CreateBuilderImpl.this.client.getZooKeeper(), (String)path, (boolean)false, (InternalACLProvider)CreateBuilderImpl.this.client.getAclProvider(), (boolean)CreateBuilderImpl.this.createParentsAsContainers);
                            createdPath = CreateBuilderImpl.this.client.getZooKeeper().create(path, data, CreateBuilderImpl.this.acling.getAclList(path), CreateBuilderImpl.this.createMode, CreateBuilderImpl.this.storingStat);
                        }
                        throw e;
                    }
                    catch (KeeperException.NodeExistsException e) {
                        if (CreateBuilderImpl.this.setDataIfExists) {
                            CreateBuilderImpl.this.client.getZooKeeper().setData(path, data, -1);
                            createdPath = path;
                        }
                        throw e;
                    }
                }
                if (CreateBuilderImpl.this.failNextCreateForTesting) {
                    CreateBuilderImpl.this.failNextCreateForTesting = false;
                    throw new KeeperException.ConnectionLossException();
                }
                return createdPath;
            }
        });
        trace.commit();
        return returnPath;
    }

    private String findProtectedNodeInForeground(final String path) throws Exception {
        TimeTrace trace = this.client.getZookeeperClient().startTracer("CreateBuilderImpl-findProtectedNodeInForeground");
        String returnPath = (String)RetryLoop.callWithRetry((CuratorZookeeperClient)this.client.getZookeeperClient(), (Callable)new Callable<String>(){

            @Override
            public String call() throws Exception {
                String foundNode = null;
                try {
                    ZKPaths.PathAndNode pathAndNode = ZKPaths.getPathAndNode((String)path);
                    List children = CreateBuilderImpl.this.client.getZooKeeper().getChildren(pathAndNode.getPath(), false);
                    foundNode = CreateBuilderImpl.findNode(children, pathAndNode.getPath(), CreateBuilderImpl.this.protectedId);
                }
                catch (KeeperException.NoNodeException noNodeException) {
                    // empty catch block
                }
                return foundNode;
            }
        });
        trace.commit();
        return returnPath;
    }

    @VisibleForTesting
    String adjustPath(String path) throws Exception {
        if (this.doProtected) {
            ZKPaths.PathAndNode pathAndNode = ZKPaths.getPathAndNode((String)path);
            String name = CreateBuilderImpl.getProtectedPrefix(this.protectedId) + pathAndNode.getNode();
            path = ZKPaths.makePath((String)pathAndNode.getPath(), (String)name);
        }
        return path;
    }

    static String findNode(List<String> children, String path, String protectedId) {
        final String protectedPrefix = CreateBuilderImpl.getProtectedPrefix(protectedId);
        String foundNode = (String)Iterables.find(children, (Predicate)new Predicate<String>(){

            public boolean apply(String node) {
                return node.startsWith(protectedPrefix);
            }
        }, null);
        if (foundNode != null) {
            foundNode = ZKPaths.makePath((String)path, (String)foundNode);
        }
        return foundNode;
    }
}

