/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.common.serialize.hessian2;

import com.alibaba.com.caucho.hessian.io.Deserializer;
import com.alibaba.com.caucho.hessian.io.InputStreamDeserializer;
import com.alibaba.com.caucho.hessian.io.JavaDeserializer;
import com.alibaba.com.caucho.hessian.io.JavaSerializer;
import com.alibaba.com.caucho.hessian.io.RecordDeserializer;
import com.alibaba.com.caucho.hessian.io.RecordUtil;
import com.alibaba.com.caucho.hessian.io.Serializer;
import com.alibaba.com.caucho.hessian.io.SerializerFactory;
import com.alibaba.com.caucho.hessian.io.UnsafeDeserializer;
import com.alibaba.com.caucho.hessian.io.UnsafeSerializer;
import java.io.InputStream;
import java.io.Serializable;
import org.apache.dubbo.common.utils.DefaultSerializeClassChecker;

public class Hessian2SerializerFactory
extends SerializerFactory {
    private final DefaultSerializeClassChecker defaultSerializeClassChecker;

    public Hessian2SerializerFactory(ClassLoader classLoader, DefaultSerializeClassChecker defaultSerializeClassChecker) {
        super(classLoader);
        this.defaultSerializeClassChecker = defaultSerializeClassChecker;
    }

    public Class<?> loadSerializedClass(String className) throws ClassNotFoundException {
        return this.defaultSerializeClassChecker.loadClass(this.getClassLoader(), className);
    }

    protected Serializer getDefaultSerializer(Class cl) {
        if (this._defaultSerializer != null) {
            return this._defaultSerializer;
        }
        try {
            this.defaultSerializeClassChecker.loadClass(this.getClassLoader(), cl.getName());
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        this.checkSerializable(cl);
        if (this.isEnableUnsafeSerializer() && JavaSerializer.getWriteReplace((Class)cl) == null) {
            return UnsafeSerializer.create((Class)cl);
        }
        return JavaSerializer.create((Class)cl);
    }

    protected Deserializer getDefaultDeserializer(Class cl) {
        if (InputStream.class.equals((Object)cl)) {
            return InputStreamDeserializer.DESER;
        }
        try {
            this.defaultSerializeClassChecker.loadClass(this.getClassLoader(), cl.getName());
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        this.checkSerializable(cl);
        if (RecordUtil.isRecord((Class)cl)) {
            return new RecordDeserializer(cl, this.getFieldDeserializerFactory());
        }
        if (this.isEnableUnsafeSerializer()) {
            return new UnsafeDeserializer(cl, this.getFieldDeserializerFactory());
        }
        return new JavaDeserializer(cl, this.getFieldDeserializerFactory());
    }

    private void checkSerializable(Class<?> cl) {
        if (!(Serializable.class.isAssignableFrom(cl) || this.isAllowNonSerializable() && !this.defaultSerializeClassChecker.isCheckSerializable())) {
            throw new IllegalStateException("Serialized class " + cl.getName() + " must implement java.io.Serializable");
        }
    }
}

