/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.config.spring.context;

import java.util.concurrent.Future;
import org.apache.dubbo.common.config.ConfigurationUtils;
import org.apache.dubbo.common.deploy.DeployListenerAdapter;
import org.apache.dubbo.common.deploy.DeployState;
import org.apache.dubbo.common.deploy.ModuleDeployer;
import org.apache.dubbo.common.logger.ErrorTypeAwareLogger;
import org.apache.dubbo.common.logger.LoggerFactory;
import org.apache.dubbo.common.utils.Assert;
import org.apache.dubbo.config.spring.context.DubboSpringInitializer;
import org.apache.dubbo.config.spring.context.event.DubboApplicationStateEvent;
import org.apache.dubbo.config.spring.context.event.DubboModuleStateEvent;
import org.apache.dubbo.config.spring.util.DubboBeanUtils;
import org.apache.dubbo.config.spring.util.LockUtils;
import org.apache.dubbo.rpc.model.ApplicationModel;
import org.apache.dubbo.rpc.model.ModuleModel;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationListener;
import org.springframework.context.event.ApplicationContextEvent;
import org.springframework.context.event.ContextClosedEvent;
import org.springframework.context.event.ContextRefreshedEvent;
import org.springframework.core.Ordered;
import org.springframework.util.ObjectUtils;

public class DubboDeployApplicationListener
implements ApplicationListener<ApplicationContextEvent>,
ApplicationContextAware,
Ordered {
    private static final ErrorTypeAwareLogger logger = LoggerFactory.getErrorTypeAwareLogger(DubboDeployApplicationListener.class);
    private ApplicationContext applicationContext;
    private ApplicationModel applicationModel;
    private ModuleModel moduleModel;

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
        this.applicationModel = DubboBeanUtils.getApplicationModel((BeanFactory)applicationContext);
        this.moduleModel = DubboBeanUtils.getModuleModel((BeanFactory)applicationContext);
        this.applicationModel.getDeployer().addDeployListener(new DeployListenerAdapter<ApplicationModel>(){

            @Override
            public void onStarting(ApplicationModel scopeModel) {
                DubboDeployApplicationListener.this.publishApplicationEvent(DeployState.STARTING);
            }

            @Override
            public void onStarted(ApplicationModel scopeModel) {
                DubboDeployApplicationListener.this.publishApplicationEvent(DeployState.STARTED);
            }

            @Override
            public void onCompletion(ApplicationModel scopeModel) {
                DubboDeployApplicationListener.this.publishApplicationEvent(DeployState.COMPLETION);
            }

            @Override
            public void onStopping(ApplicationModel scopeModel) {
                DubboDeployApplicationListener.this.publishApplicationEvent(DeployState.STOPPING);
            }

            @Override
            public void onStopped(ApplicationModel scopeModel) {
                DubboDeployApplicationListener.this.publishApplicationEvent(DeployState.STOPPED);
            }

            @Override
            public void onFailure(ApplicationModel scopeModel, Throwable cause) {
                DubboDeployApplicationListener.this.publishApplicationEvent(DeployState.FAILED, cause);
            }
        });
        this.moduleModel.getDeployer().addDeployListener(new DeployListenerAdapter<ModuleModel>(){

            @Override
            public void onStarting(ModuleModel scopeModel) {
                DubboDeployApplicationListener.this.publishModuleEvent(DeployState.STARTING);
            }

            @Override
            public void onStarted(ModuleModel scopeModel) {
                DubboDeployApplicationListener.this.publishModuleEvent(DeployState.STARTED);
            }

            @Override
            public void onCompletion(ModuleModel scopeModel) {
                DubboDeployApplicationListener.this.publishModuleEvent(DeployState.COMPLETION);
            }

            @Override
            public void onStopping(ModuleModel scopeModel) {
                DubboDeployApplicationListener.this.publishModuleEvent(DeployState.STOPPING);
            }

            @Override
            public void onStopped(ModuleModel scopeModel) {
                DubboDeployApplicationListener.this.publishModuleEvent(DeployState.STOPPED);
            }

            @Override
            public void onFailure(ModuleModel scopeModel, Throwable cause) {
                DubboDeployApplicationListener.this.publishModuleEvent(DeployState.FAILED, cause);
            }
        });
    }

    private void publishApplicationEvent(DeployState state) {
        this.applicationContext.publishEvent((ApplicationEvent)new DubboApplicationStateEvent(this.applicationModel, state));
    }

    private void publishApplicationEvent(DeployState state, Throwable cause) {
        this.applicationContext.publishEvent((ApplicationEvent)new DubboApplicationStateEvent(this.applicationModel, state, cause));
    }

    private void publishModuleEvent(DeployState state) {
        this.applicationContext.publishEvent((ApplicationEvent)new DubboModuleStateEvent(this.moduleModel, state));
    }

    private void publishModuleEvent(DeployState state, Throwable cause) {
        this.applicationContext.publishEvent((ApplicationEvent)new DubboModuleStateEvent(this.moduleModel, state, cause));
    }

    public void onApplicationEvent(ApplicationContextEvent event) {
        if (ObjectUtils.nullSafeEquals((Object)this.applicationContext, (Object)event.getSource())) {
            if (event instanceof ContextRefreshedEvent) {
                this.onContextRefreshedEvent((ContextRefreshedEvent)event);
            } else if (event instanceof ContextClosedEvent) {
                this.onContextClosedEvent((ContextClosedEvent)event);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onContextRefreshedEvent(ContextRefreshedEvent event) {
        ModuleDeployer deployer = this.moduleModel.getDeployer();
        Assert.notNull((Object)deployer, "Module deployer is null");
        Object singletonMutex = LockUtils.getSingletonMutex(this.applicationContext);
        Future future = null;
        Object object = singletonMutex;
        synchronized (object) {
            future = deployer.start();
        }
        if (!deployer.isBackground()) {
            try {
                future.get();
            }
            catch (InterruptedException e) {
                logger.warn("5-14", "", "", "Interrupted while waiting for dubbo module start: " + e.getMessage());
            }
            catch (Exception e) {
                logger.warn("5-14", "", "", "An error occurred while waiting for dubbo module start: " + e.getMessage(), e);
            }
        }
    }

    private void onContextClosedEvent(ContextClosedEvent event) {
        try {
            boolean keepRunningOnClosed;
            Object value = this.moduleModel.getAttribute("keepRunningOnSpringClosed");
            if (value == null) {
                value = ConfigurationUtils.getProperty(this.moduleModel, "dubbo.module.keepRunningOnSpringClosed");
            }
            if (!(keepRunningOnClosed = Boolean.parseBoolean(String.valueOf(value))) && !this.moduleModel.isDestroyed()) {
                this.moduleModel.destroy();
            }
        }
        catch (Exception e) {
            logger.error("5-20", "", "", "Unexpected error occurred when stop dubbo module: " + e.getMessage(), e);
        }
        DubboSpringInitializer.remove(event.getApplicationContext());
    }

    public int getOrder() {
        return Integer.MAX_VALUE;
    }
}

