/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.config.spring.status;

import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Method;
import org.apache.dubbo.common.extension.Activate;
import org.apache.dubbo.common.logger.ErrorTypeAwareLogger;
import org.apache.dubbo.common.logger.LoggerFactory;
import org.apache.dubbo.common.status.Status;
import org.apache.dubbo.common.status.StatusChecker;
import org.apache.dubbo.config.spring.extension.SpringExtensionInjector;
import org.apache.dubbo.rpc.model.ApplicationModel;
import org.springframework.context.ApplicationContext;
import org.springframework.context.Lifecycle;

@Activate
public class SpringStatusChecker
implements StatusChecker {
    private static final ErrorTypeAwareLogger logger = LoggerFactory.getErrorTypeAwareLogger(SpringStatusChecker.class);
    private ApplicationModel applicationModel;
    private ApplicationContext applicationContext;

    public SpringStatusChecker(ApplicationModel applicationModel) {
        this.applicationModel = applicationModel;
    }

    public SpringStatusChecker(ApplicationContext applicationContext) {
        this.applicationContext = applicationContext;
    }

    @Override
    public Status check() {
        if (this.applicationContext == null && this.applicationModel != null) {
            SpringExtensionInjector springExtensionInjector = SpringExtensionInjector.get(this.applicationModel);
            this.applicationContext = springExtensionInjector.getContext();
        }
        if (this.applicationContext == null) {
            return new Status(Status.Level.UNKNOWN);
        }
        Status.Level level = this.applicationContext instanceof Lifecycle ? (((Lifecycle)this.applicationContext).isRunning() ? Status.Level.OK : Status.Level.ERROR) : Status.Level.UNKNOWN;
        StringBuilder buf = new StringBuilder();
        try {
            Class cls = this.applicationContext.getClass();
            AccessibleObject method = null;
            while (cls != null && method == null) {
                try {
                    method = cls.getDeclaredMethod("getConfigLocations", new Class[0]);
                }
                catch (NoSuchMethodException t) {
                    cls = cls.getSuperclass();
                }
            }
            if (method != null) {
                String[] configs;
                if (!method.isAccessible()) {
                    ((Method)method).setAccessible(true);
                }
                if ((configs = (String[])((Method)method).invoke(this.applicationContext, new Object[0])) != null && configs.length > 0) {
                    for (String config : configs) {
                        if (buf.length() > 0) {
                            buf.append(',');
                        }
                        buf.append(config);
                    }
                }
            }
        }
        catch (Throwable t) {
            if (t.getCause() instanceof UnsupportedOperationException) {
                logger.debug(t.getMessage(), t);
            }
            logger.warn("5-31", "", "", t.getMessage(), t);
        }
        return new Status(level, buf.toString());
    }
}

