/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.metrics.event;

import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.Map;
import org.apache.dubbo.common.beans.factory.ScopeBeanFactory;
import org.apache.dubbo.metrics.event.MetricsEventMulticaster;
import org.apache.dubbo.metrics.exception.MetricsNeverHappenException;
import org.apache.dubbo.metrics.model.key.TypeWrapper;
import org.apache.dubbo.rpc.model.ApplicationModel;

public abstract class MetricsEvent {
    protected final transient ApplicationModel source;
    private boolean available = true;
    private final TypeWrapper typeWrapper;
    private final String appName;
    private final MetricsEventMulticaster metricsEventMulticaster;
    private final Map<String, Object> attachments = new IdentityHashMap<String, Object>(8);

    public MetricsEvent(ApplicationModel source, TypeWrapper typeWrapper) {
        this(source, null, null, typeWrapper);
    }

    public MetricsEvent(ApplicationModel source, String appName, MetricsEventMulticaster metricsEventMulticaster, TypeWrapper typeWrapper) {
        MetricsEventMulticaster dispatcher;
        ScopeBeanFactory beanFactory;
        this.typeWrapper = typeWrapper;
        if (source == null) {
            this.source = ApplicationModel.defaultModel();
            this.available = false;
        } else {
            this.source = source;
        }
        this.metricsEventMulticaster = metricsEventMulticaster == null ? (this.source.isDestroyed() ? null : ((beanFactory = this.source.getBeanFactory()).isDestroyed() ? null : (dispatcher = beanFactory.getBean(MetricsEventMulticaster.class)))) : metricsEventMulticaster;
        this.appName = appName == null ? this.source.tryGetApplicationName() : appName;
    }

    public <T> T getAttachmentValue(String key) {
        if (key == null) {
            throw new MetricsNeverHappenException("Attachment key is null");
        }
        return (T)this.attachments.get(key);
    }

    public Map<String, Object> getAttachments() {
        return Collections.unmodifiableMap(this.attachments);
    }

    public void putAttachment(String key, Object value) {
        this.attachments.put(key, value);
    }

    public void putAttachments(Map<String, String> attachments) {
        this.attachments.putAll(attachments);
    }

    public void setAvailable(boolean available) {
        this.available = available;
    }

    public boolean isAvailable() {
        return this.available;
    }

    public void customAfterPost(Object postResult) {
    }

    public ApplicationModel getSource() {
        return this.source;
    }

    public MetricsEventMulticaster getMetricsEventMulticaster() {
        return this.metricsEventMulticaster;
    }

    public String appName() {
        return this.appName;
    }

    public TypeWrapper getTypeWrapper() {
        return this.typeWrapper;
    }

    public boolean isAssignableFrom(Object type) {
        return this.typeWrapper.isAssignableFrom(type);
    }

    public String toString() {
        return this.getClass().getName() + "[source=" + this.source + "]";
    }

    public static enum Type {
        TOTAL("TOTAL_%s"),
        SUCCEED("SUCCEED_%s"),
        BUSINESS_FAILED("BUSINESS_FAILED_%s"),
        REQUEST_TIMEOUT("REQUEST_TIMEOUT_%s"),
        REQUEST_LIMIT("REQUEST_LIMIT_%s"),
        PROCESSING("PROCESSING_%s"),
        UNKNOWN_FAILED("UNKNOWN_FAILED_%s"),
        TOTAL_FAILED("TOTAL_FAILED_%s"),
        APPLICATION_INFO("APPLICATION_INFO_%s"),
        NETWORK_EXCEPTION("NETWORK_EXCEPTION_%s"),
        SERVICE_UNAVAILABLE("SERVICE_UNAVAILABLE_%s"),
        CODEC_EXCEPTION("CODEC_EXCEPTION_%s"),
        NO_INVOKER_AVAILABLE("NO_INVOKER_AVAILABLE_%s");

        private final String name;

        public final String getName() {
            return this.name;
        }

        public final String getNameByType(String type) {
            return String.format(this.name, type);
        }

        private Type(String name) {
            this.name = name;
        }
    }
}

