/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.registry.client.metadata;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ThreadLocalRandom;
import org.apache.dubbo.common.URL;
import org.apache.dubbo.common.aot.NativeDetector;
import org.apache.dubbo.common.extension.ExtensionLoader;
import org.apache.dubbo.common.logger.ErrorTypeAwareLogger;
import org.apache.dubbo.common.logger.LoggerFactory;
import org.apache.dubbo.common.utils.CollectionUtils;
import org.apache.dubbo.common.utils.StringUtils;
import org.apache.dubbo.metadata.MetadataInfo;
import org.apache.dubbo.metadata.MetadataRequest;
import org.apache.dubbo.metadata.MetadataService;
import org.apache.dubbo.metadata.MetadataServiceV2;
import org.apache.dubbo.metadata.MetadataServiceV2Detector;
import org.apache.dubbo.metadata.definition.model.FullServiceDefinition;
import org.apache.dubbo.metadata.report.MetadataReport;
import org.apache.dubbo.metadata.report.MetadataReportInstance;
import org.apache.dubbo.metadata.report.identifier.MetadataIdentifier;
import org.apache.dubbo.metadata.report.identifier.SubscriberMetadataIdentifier;
import org.apache.dubbo.metadata.util.MetadataServiceVersionUtils;
import org.apache.dubbo.registry.client.ServiceInstance;
import org.apache.dubbo.registry.client.metadata.MetadataServiceURLBuilder;
import org.apache.dubbo.registry.client.metadata.ServiceInstanceMetadataUtils;
import org.apache.dubbo.rpc.Invoker;
import org.apache.dubbo.rpc.Protocol;
import org.apache.dubbo.rpc.ProxyFactory;
import org.apache.dubbo.rpc.cluster.filter.FilterChainBuilder;
import org.apache.dubbo.rpc.model.ApplicationModel;
import org.apache.dubbo.rpc.model.ConsumerModel;
import org.apache.dubbo.rpc.model.ModuleModel;
import org.apache.dubbo.rpc.model.ScopeModelUtil;
import org.apache.dubbo.rpc.model.ServiceDescriptor;
import org.apache.dubbo.rpc.service.Destroyable;
import org.apache.dubbo.rpc.stub.StubSuppliers;

public class MetadataUtils {
    public static final ErrorTypeAwareLogger logger = LoggerFactory.getErrorTypeAwareLogger(MetadataUtils.class);

    public static void publishServiceDefinition(URL url, ServiceDescriptor serviceDescriptor, ApplicationModel applicationModel) {
        if (MetadataUtils.getMetadataReports(applicationModel).isEmpty()) {
            logger.info("Remote Metadata Report Server is not provided or unavailable, will stop registering service definition to remote center!");
            return;
        }
        try {
            String side = url.getSide();
            if ("provider".equalsIgnoreCase(side)) {
                String serviceKey = url.getServiceKey();
                FullServiceDefinition serviceDefinition = serviceDescriptor.getFullServiceDefinition(serviceKey);
                if (StringUtils.isNotEmpty(serviceKey) && serviceDefinition != null) {
                    serviceDefinition.setParameters(url.getParameters());
                    for (Map.Entry<String, MetadataReport> entry : MetadataUtils.getMetadataReports(applicationModel).entrySet()) {
                        MetadataReport metadataReport = entry.getValue();
                        if (!metadataReport.shouldReportDefinition()) {
                            logger.info("Report of service definition is disabled for " + entry.getKey());
                            continue;
                        }
                        metadataReport.storeProviderMetadata(new MetadataIdentifier(url.getServiceInterface(), url.getVersion() == null ? "" : url.getVersion(), url.getGroup() == null ? "" : url.getGroup(), "provider", applicationModel.getApplicationName()), serviceDefinition);
                    }
                }
            } else {
                for (Map.Entry<String, MetadataReport> entry : MetadataUtils.getMetadataReports(applicationModel).entrySet()) {
                    MetadataReport metadataReport = entry.getValue();
                    if (!metadataReport.shouldReportDefinition()) {
                        logger.info("Report of service definition is disabled for " + entry.getKey());
                        continue;
                    }
                    metadataReport.storeConsumerMetadata(new MetadataIdentifier(url.getServiceInterface(), url.getVersion() == null ? "" : url.getVersion(), url.getGroup() == null ? "" : url.getGroup(), "consumer", applicationModel.getApplicationName()), url.getParameters());
                }
            }
        }
        catch (Exception e) {
            logger.error("1-11", "", "", "publish service definition metadata error.", e);
        }
    }

    public static RemoteMetadataService referMetadataService(ServiceInstance instance) {
        RemoteMetadataService remoteMetadataService;
        Invoker<Object> invoker;
        ConsumerModel consumerModel;
        URL url = MetadataUtils.buildMetadataUrl(instance);
        ApplicationModel applicationModel = instance.getApplicationModel();
        ModuleModel internalModel = applicationModel.getInternalModule();
        boolean useV2 = "2.0.0".equals(url.getAttribute("meta-v"));
        if (!MetadataServiceV2Detector.support()) {
            useV2 = false;
        }
        boolean inNativeImage = NativeDetector.inNativeImage();
        if (useV2 && !inNativeImage) {
            url = url.addParameter("proxy", "nativestub");
            url = url.setPath(MetadataServiceV2.class.getName());
            url = url.addParameter("version", "2.0.0");
            consumerModel = applicationModel.getInternalModule().registerInternalConsumer(MetadataServiceV2.class, url, StubSuppliers.getServiceDescriptor(MetadataServiceV2.class.getName()));
        } else {
            consumerModel = applicationModel.getInternalModule().registerInternalConsumer(MetadataService.class, url);
        }
        if (inNativeImage) {
            url = url.addParameter("proxy", "jdk");
        }
        Protocol protocol = applicationModel.getExtensionLoader(Protocol.class).getExtension(url.getProtocol(), false);
        if ((url = url.setServiceModel(consumerModel)).getParameter("auth", false)) {
            url = url.addParameter("filter", "-default,consumersign");
        }
        ProxyFactory proxyFactory = applicationModel.getExtensionLoader(ProxyFactory.class).getAdaptiveExtension();
        if (useV2) {
            invoker = protocol.refer(MetadataServiceV2.class, url);
            if (url.getParameter("auth", false)) {
                FilterChainBuilder filterChainBuilder = ScopeModelUtil.getExtensionLoader(FilterChainBuilder.class, url.getScopeModel()).getDefaultExtension();
                invoker = filterChainBuilder.buildInvokerChain(invoker, "reference.filter", "consumer");
            }
            remoteMetadataService = new RemoteMetadataService(consumerModel, proxyFactory.getProxy(invoker), internalModel);
        } else {
            invoker = protocol.refer(MetadataService.class, url);
            if (url.getParameter("auth", false)) {
                FilterChainBuilder filterChainBuilder = ScopeModelUtil.getExtensionLoader(FilterChainBuilder.class, url.getScopeModel()).getDefaultExtension();
                invoker = filterChainBuilder.buildInvokerChain(invoker, "reference.filter", "consumer");
            }
            remoteMetadataService = new RemoteMetadataService(consumerModel, (MetadataService)((Object)proxyFactory.getProxy(invoker)), internalModel);
        }
        Object metadataServiceProxy = remoteMetadataService.getInternalProxy();
        consumerModel.getServiceMetadata().setTarget(metadataServiceProxy);
        consumerModel.getServiceMetadata().addAttribute("refClass", metadataServiceProxy);
        consumerModel.setProxyObject(metadataServiceProxy);
        consumerModel.initMethodModels();
        return remoteMetadataService;
    }

    private static URL buildMetadataUrl(ServiceInstance instance) {
        ExtensionLoader<MetadataServiceURLBuilder> loader = instance.getApplicationModel().getExtensionLoader(MetadataServiceURLBuilder.class);
        Map<String, String> metadata = instance.getMetadata();
        String dubboUrlsForJson = metadata.get("dubbo.metadata-service.urls");
        MetadataServiceURLBuilder builder = metadata.isEmpty() || StringUtils.isEmpty(dubboUrlsForJson) ? loader.getExtension("standard") : loader.getExtension("spring-cloud");
        List<URL> urls = builder.build(instance);
        if (CollectionUtils.isEmpty(urls)) {
            throw new IllegalStateException("Introspection service discovery mode is enabled " + instance + ", but no metadata service can build from it.");
        }
        URL url = urls.get(0);
        String version = metadata.get("meta-v");
        url = url.putAttribute("meta-v", version);
        url = url.addParameter("check", false);
        return url;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static MetadataInfo getRemoteMetadata(String revision, List<ServiceInstance> instances, MetadataReport metadataReport) {
        MetadataInfo metadataInfo;
        block8: {
            ServiceInstance instance = MetadataUtils.selectInstance(instances);
            String metadataType = ServiceInstanceMetadataUtils.getMetadataStorageType(instance);
            try {
                if (logger.isDebugEnabled()) {
                    logger.debug("Instance " + instance.getAddress() + " is using metadata type " + metadataType);
                }
                if ("remote".equals(metadataType)) {
                    metadataInfo = MetadataUtils.getMetadata(revision, instance, metadataReport);
                    break block8;
                }
                RemoteMetadataService remoteMetadataService = null;
                try {
                    remoteMetadataService = MetadataUtils.referMetadataService(instance);
                    metadataInfo = remoteMetadataService.getRemoteMetadata(ServiceInstanceMetadataUtils.getExportedServicesRevision(instance));
                }
                finally {
                    MetadataUtils.destroyProxy(remoteMetadataService);
                }
            }
            catch (Exception e) {
                logger.error("1-39", "", "", "Failed to get app metadata for revision " + revision + " for type " + metadataType + " from instance " + instance.getAddress(), e);
                metadataInfo = null;
            }
        }
        if (metadataInfo == null) {
            metadataInfo = MetadataInfo.EMPTY;
        }
        return metadataInfo;
    }

    public static void destroyProxy(RemoteMetadataService remoteMetadataService) {
        if (remoteMetadataService != null) {
            remoteMetadataService.destroy();
        }
    }

    public static MetadataInfo getMetadata(String revision, ServiceInstance instance, MetadataReport metadataReport) {
        SubscriberMetadataIdentifier identifier = new SubscriberMetadataIdentifier(instance.getServiceName(), revision);
        if (metadataReport == null) {
            throw new IllegalStateException("No valid remote metadata report specified.");
        }
        String registryCluster = instance.getRegistryCluster();
        HashMap<String, String> params = new HashMap<String, String>(instance.getExtendParams());
        if (registryCluster != null && !registryCluster.equalsIgnoreCase((String)params.get("REGISTRY_CLUSTER"))) {
            params.put("REGISTRY_CLUSTER", registryCluster);
        }
        return metadataReport.getAppMetadata(identifier, params);
    }

    private static Map<String, MetadataReport> getMetadataReports(ApplicationModel applicationModel) {
        return applicationModel.getBeanFactory().getBean(MetadataReportInstance.class).getMetadataReports(false);
    }

    private static ServiceInstance selectInstance(List<ServiceInstance> instances) {
        if (instances.size() == 1) {
            return instances.get(0);
        }
        return instances.get(ThreadLocalRandom.current().nextInt(0, instances.size()));
    }

    public static class RemoteMetadataService {
        private final ConsumerModel consumerModel;
        @Deprecated
        private MetadataService proxy;
        private MetadataServiceV2 proxyV2;
        private final ModuleModel internalModel;

        public RemoteMetadataService(ConsumerModel consumerModel, MetadataService proxy, ModuleModel internalModel) {
            this.consumerModel = consumerModel;
            this.proxy = proxy;
            this.internalModel = internalModel;
        }

        public RemoteMetadataService(ConsumerModel consumerModel, MetadataServiceV2 proxyV2, ModuleModel internalModel) {
            this.consumerModel = consumerModel;
            this.proxyV2 = proxyV2;
            this.internalModel = internalModel;
        }

        public void destroy() {
            if (this.proxy instanceof Destroyable) {
                ((Destroyable)((Object)this.proxy)).$destroy();
            }
            if (this.proxyV2 instanceof Destroyable) {
                ((Destroyable)((Object)this.proxyV2)).$destroy();
            }
            this.internalModel.getServiceRepository().unregisterConsumer(this.consumerModel);
        }

        public ConsumerModel getConsumerModel() {
            return this.consumerModel;
        }

        public Object getInternalProxy() {
            return this.proxy == null ? this.proxyV2 : this.proxy;
        }

        public ModuleModel getInternalModel() {
            return this.internalModel;
        }

        public MetadataInfo getRemoteMetadata(String revision) {
            Object existProxy = this.getInternalProxy();
            if (existProxy instanceof MetadataService) {
                return ((MetadataService)existProxy).getMetadataInfo(revision);
            }
            return MetadataServiceVersionUtils.toV1(((MetadataServiceV2)existProxy).getMetadataInfo(MetadataRequest.newBuilder().setRevision(revision).build()));
        }
    }
}

